/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class InputChannelIDTest {
    private static final NettyBufferPool ALLOCATOR = new NettyBufferPool(1);

    @Test
    public void testByteBufWriteAndRead() {
        InputChannelID inputChannelID = new InputChannelID();
        int byteBufLen = InputChannelID.getByteBufLength();
        ByteBuf byteBuf = ALLOCATOR.directBuffer(byteBufLen, byteBufLen);
        inputChannelID.writeTo(byteBuf);
        Assert.assertThat((Object)byteBuf.writerIndex(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)InputChannelID.getByteBufLength())));
        Assert.assertThat((Object)InputChannelID.fromByteBuf((ByteBuf)byteBuf), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)inputChannelID)));
    }
}

