/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.time.Duration;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FixedRetryStrategy;
import org.apache.flink.util.concurrent.RetryStrategy;
import org.junit.Assert;
import org.junit.Test;

public class FixedRetryStrategyTest
extends TestLogger {
    @Test
    public void testGetters() throws Exception {
        FixedRetryStrategy retryStrategy = new FixedRetryStrategy(10, Duration.ofMillis(5L));
        Assert.assertEquals((long)10L, (long)retryStrategy.getNumRemainingRetries());
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)retryStrategy.getRetryDelay());
        RetryStrategy nextRetryStrategy = retryStrategy.getNextRetryStrategy();
        Assert.assertEquals((long)9L, (long)nextRetryStrategy.getNumRemainingRetries());
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)nextRetryStrategy.getRetryDelay());
    }

    @Test(expected=IllegalStateException.class)
    public void testRetryFailure() throws Throwable {
        new FixedRetryStrategy(0, Duration.ofMillis(5L)).getNextRetryStrategy();
    }
}

