/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.FullyFinishedOperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Test;

public class FullyFinishedOperatorStateTest {
    @Test
    public void testFullyFinishedOperatorState() {
        FullyFinishedOperatorState operatorState = new FullyFinishedOperatorState(new OperatorID(), 5, 256);
        Assert.assertTrue((boolean)operatorState.isFullyFinished());
        Assert.assertEquals((long)0L, (long)operatorState.getSubtaskStates().size());
        Assert.assertEquals((long)0L, (long)operatorState.getStates().size());
        Assert.assertEquals((long)0L, (long)operatorState.getNumberCollectedStates());
        try {
            operatorState.putState(0, OperatorSubtaskState.builder().build());
            Assert.fail((String)"Should not be able to put new subtask states for a fully finished state");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            operatorState.setCoordinatorState(new ByteStreamStateHandle("test", new byte[]{1, 2, 3, 4}));
            Assert.fail((String)"Should not be able to set coordinator states for a fully finished state");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

