/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobCachePutTest;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobClientTest;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobKeyTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerDeleteTest;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class BlobCacheGetTest
extends TestLogger {
    private final Random rnd = new Random();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testGetTransientFailsDuringLookup1() throws IOException, InterruptedException {
        this.testGetFailsDuringLookup(null, new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetTransientFailsDuringLookup2() throws IOException, InterruptedException {
        this.testGetFailsDuringLookup(new JobID(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetTransientFailsDuringLookup3() throws IOException, InterruptedException {
        this.testGetFailsDuringLookup(new JobID(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetFailsDuringLookupHa() throws IOException, InterruptedException {
        this.testGetFailsDuringLookup(new JobID(), new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testGetFailsDuringLookup(JobID jobId1, JobID jobId2, BlobKey.BlobType blobType) throws IOException, InterruptedException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId1, data, blobType);
            Assert.assertNotNull((Object)key);
            BlobKeyTest.verifyType(blobType, key);
            File blobFile = server.getStorageLocation(jobId1, key);
            Assert.assertTrue((boolean)blobFile.delete());
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId1, key);
            BlobKey key2 = BlobServerPutTest.put((BlobService)server, jobId2, data, blobType);
            Assert.assertNotNull((Object)key2);
            BlobKeyTest.verifyKeyDifferentHashEquals(key, key2);
            BlobServerGetTest.get((BlobService)cache, jobId2, key2);
            BlobServerGetTest.verifyDeleted((BlobService)cache, jobId1, key);
            if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
                Assert.assertTrue((boolean)server.getStorageLocation(jobId2, key2).exists());
                blobFile = cache.getPermanentBlobService().getStorageLocation(jobId2, key2);
                Assert.assertTrue((boolean)blobFile.delete());
                BlobServerGetTest.get((BlobService)cache, jobId2, key2);
                blobFile = cache.getPermanentBlobService().getStorageLocation(jobId2, key2);
                Assert.assertTrue((boolean)blobFile.delete());
                blobFile = server.getStorageLocation(jobId2, key2);
                Assert.assertTrue((boolean)blobFile.delete());
                BlobServerGetTest.verifyDeleted((BlobService)cache, jobId2, key2);
            } else {
                BlobCachePutTest.verifyDeletedEventually(server, jobId2, key2);
                blobFile = cache.getTransientBlobService().getStorageLocation(jobId2, key2);
                Assert.assertTrue((boolean)blobFile.delete());
                BlobServerGetTest.verifyDeleted((BlobService)cache, jobId2, key2);
            }
        }
    }

    @Test
    public void testGetFailsIncomingNoJob() throws IOException {
        this.testGetFailsIncoming(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetFailsIncomingForJob() throws IOException {
        this.testGetFailsIncoming(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetFailsIncomingForJobHa() throws IOException {
        this.testGetFailsIncoming(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetFailsIncoming(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File tempFileDir = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey blobKey = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            BlobKeyTest.verifyType(blobType, blobKey);
            tempFileDir = blobType == BlobKey.BlobType.PERMANENT_BLOB ? cache.getPermanentBlobService().createTemporaryFilename().getParentFile() : cache.getTransientBlobService().createTemporaryFilename().getParentFile();
            Assert.assertTrue((boolean)tempFileDir.setExecutable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setReadable(true, false));
            Assert.assertTrue((boolean)tempFileDir.setWritable(false, false));
            this.exception.expect(IOException.class);
            this.exception.expectMessage("Failed to fetch BLOB ");
            try {
                BlobServerGetTest.get((BlobService)cache, jobId, blobKey);
            }
            finally {
                HashSet<String> expectedDirs = new HashSet<String>();
                expectedDirs.add("incoming");
                if (jobId != null) {
                    expectedDirs.add("job_" + jobId);
                    File storageDir = tempFileDir.getParentFile();
                    String[] actualDirs = storageDir.list();
                    Assert.assertNotNull((Object)actualDirs);
                    Assert.assertEquals(expectedDirs, new HashSet<String>(Arrays.asList(actualDirs)));
                    File jobDir = new File(tempFileDir.getParentFile(), "job_" + jobId);
                    Assert.assertArrayEquals((Object[])new String[0], (Object[])jobDir.list());
                } else {
                    expectedDirs.add("no_job");
                    File storageDir = tempFileDir.getParentFile();
                    String[] actualDirs = storageDir.list();
                    Assert.assertNotNull((Object)actualDirs);
                    Assert.assertEquals(expectedDirs, new HashSet<String>(Arrays.asList(actualDirs)));
                    File noJobDir = new File(tempFileDir.getParentFile(), "no_job");
                    Assert.assertArrayEquals((Object[])new String[0], (Object[])noJobDir.list());
                }
                Assert.assertTrue((boolean)server.getStorageLocation(jobId, blobKey).exists());
            }
        }
        finally {
            if (tempFileDir != null) {
                tempFileDir.setWritable(true, false);
            }
        }
    }

    @Test
    public void testGetTransientFailsStoreNoJob() throws IOException, InterruptedException {
        this.testGetFailsStore(null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetTransientFailsStoreForJob() throws IOException, InterruptedException {
        this.testGetFailsStore(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testGetPermanentFailsStoreForJob() throws IOException, InterruptedException {
        this.testGetFailsStore(new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetFailsStore(@Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException, InterruptedException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File jobStoreDir = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            File incomingFileDir;
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            BlobKey blobKey = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            BlobKeyTest.verifyType(blobType, blobKey);
            jobStoreDir = blobType == BlobKey.BlobType.PERMANENT_BLOB ? cache.getPermanentBlobService().getStorageLocation(jobId, (BlobKey)new PermanentBlobKey()).getParentFile() : cache.getTransientBlobService().getStorageLocation(jobId, (BlobKey)new TransientBlobKey()).getParentFile();
            Assert.assertTrue((boolean)jobStoreDir.setExecutable(true, false));
            Assert.assertTrue((boolean)jobStoreDir.setReadable(true, false));
            Assert.assertTrue((boolean)jobStoreDir.setWritable(false, false));
            this.exception.expect(AccessDeniedException.class);
            try {
                BlobServerGetTest.get((BlobService)cache, jobId, blobKey);
                incomingFileDir = new File(jobStoreDir.getParent(), "incoming");
            }
            catch (Throwable throwable) {
                File incomingFileDir2 = new File(jobStoreDir.getParent(), "incoming");
                Assert.assertArrayEquals((Object[])new String[0], (Object[])incomingFileDir2.list());
                Assert.assertArrayEquals((Object[])new String[0], (Object[])jobStoreDir.list());
                if (blobType == BlobKey.BlobType.TRANSIENT_BLOB) {
                    BlobCachePutTest.verifyDeletedEventually(server, jobId, blobKey);
                } else {
                    Assert.assertTrue((boolean)server.getStorageLocation(jobId, blobKey).exists());
                }
                throw throwable;
            }
            Assert.assertArrayEquals((Object[])new String[0], (Object[])incomingFileDir.list());
            Assert.assertArrayEquals((Object[])new String[0], (Object[])jobStoreDir.list());
            if (blobType == BlobKey.BlobType.TRANSIENT_BLOB) {
                BlobCachePutTest.verifyDeletedEventually(server, jobId, blobKey);
            } else {
                Assert.assertTrue((boolean)server.getStorageLocation(jobId, blobKey).exists());
            }
        }
        finally {
            if (jobStoreDir != null) {
                jobStoreDir.setWritable(true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFailsHaStoreForJobHa() throws IOException {
        JobID jobId = new JobID();
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            byte[] data = new byte[2000000];
            this.rnd.nextBytes(data);
            PermanentBlobKey blobKey = (PermanentBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.PERMANENT_BLOB);
            Assert.assertTrue((boolean)server.getStorageLocation(jobId, (BlobKey)blobKey).delete());
            File tempFileDir = server.createTemporaryFilename().getParentFile();
            this.exception.expect(IOException.class);
            this.exception.expectMessage("Failed to fetch BLOB ");
            try {
                BlobServerGetTest.get((BlobService)cache, jobId, (BlobKey)blobKey);
            }
            finally {
                HashSet<String> expectedDirs = new HashSet<String>();
                expectedDirs.add("incoming");
                expectedDirs.add("job_" + jobId);
                File storageDir = tempFileDir.getParentFile();
                String[] actualDirs = storageDir.list();
                Assert.assertNotNull((Object)actualDirs);
                Assert.assertEquals(expectedDirs, new HashSet<String>(Arrays.asList(actualDirs)));
                File jobDir = new File(tempFileDir.getParentFile(), "job_" + jobId);
                Assert.assertArrayEquals((Object[])new String[0], (Object[])jobDir.list());
            }
        }
    }

    @Test
    public void testGetTransientRemoteDeleteFailsNoJob() throws IOException {
        this.testGetTransientRemoteDeleteFails(null);
    }

    @Test
    public void testGetTransientRemoteDeleteFailsForJob() throws IOException {
        this.testGetTransientRemoteDeleteFails(new JobID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetTransientRemoteDeleteFails(@Nullable JobID jobId) throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        File blobFile = null;
        File directory = null;
        try (BlobServer server = new BlobServer(config, (BlobStore)new VoidBlobStore());
             BlobCacheService cache = new BlobCacheService(config, (BlobView)new VoidBlobStore(), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            try {
                byte[] data = new byte[2000000];
                this.rnd.nextBytes(data);
                TransientBlobKey key = (TransientBlobKey)BlobServerPutTest.put((BlobService)server, jobId, data, BlobKey.BlobType.TRANSIENT_BLOB);
                Assert.assertNotNull((Object)key);
                blobFile = server.getStorageLocation(jobId, (BlobKey)key);
                directory = blobFile.getParentFile();
                Assert.assertTrue((boolean)blobFile.setWritable(false, false));
                Assert.assertTrue((boolean)directory.setWritable(false, false));
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, (BlobKey)key, data);
                Assert.assertTrue((boolean)BlobServerDeleteTest.delete((BlobService)cache, jobId, key));
                File blobFileAtCache = cache.getTransientBlobService().getStorageLocation(jobId, (BlobKey)key);
                Assert.assertFalse((boolean)blobFileAtCache.exists());
                BlobServerPutTest.verifyContents((BlobService)server, jobId, (BlobKey)key, data);
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, (BlobKey)key, data);
            }
            finally {
                if (blobFile != null && directory != null) {
                    blobFile.setWritable(true, false);
                    directory.setWritable(true, false);
                }
            }
        }
    }

    @Test
    public void testConcurrentGetOperationsNoJob() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentGetOperations(null, BlobKey.BlobType.TRANSIENT_BLOB, false);
    }

    @Test
    public void testConcurrentGetOperationsForJob() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentGetOperations(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB, false);
    }

    @Test
    public void testConcurrentGetOperationsForJobHa() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentGetOperations(new JobID(), BlobKey.BlobType.PERMANENT_BLOB, false);
    }

    @Test
    public void testConcurrentGetOperationsForJobHa2() throws IOException, ExecutionException, InterruptedException {
        this.testConcurrentGetOperations(new JobID(), BlobKey.BlobType.PERMANENT_BLOB, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentGetOperations(JobID jobId, BlobKey.BlobType blobType, boolean cacheAccessesHAStore) throws IOException, InterruptedException, ExecutionException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobStore blobStoreServer = (BlobStore)Mockito.mock(BlobStore.class);
        BlobStore blobStoreCache = (BlobStore)Mockito.mock(BlobStore.class);
        int numberConcurrentGetOperations = 3;
        ArrayList<CompletableFuture<File>> getOperations = new ArrayList<CompletableFuture<File>>(3);
        byte[] data = new byte[]{1, 2, 3, 4, 99, 42};
        ExecutorService executor = Executors.newFixedThreadPool(3);
        try (BlobServer server = new BlobServer(config, blobStoreServer);
             BlobCacheService cache = new BlobCacheService(config, (BlobView)(cacheAccessesHAStore ? blobStoreServer : blobStoreCache), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            BlobKey blobKey = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            for (int i = 0; i < 3; ++i) {
                CompletableFuture<File> getOperation = CompletableFuture.supplyAsync(() -> {
                    try {
                        File file = BlobServerGetTest.get((BlobService)cache, jobId, blobKey);
                        BlobClientTest.validateGetAndClose((InputStream)new FileInputStream(file), data);
                        return file;
                    }
                    catch (IOException e) {
                        throw new CompletionException((Throwable)new FlinkException("Could not read blob for key " + blobKey + '.', (Throwable)e));
                    }
                }, executor);
                getOperations.add(getOperation);
            }
            FutureUtils.ConjunctFuture filesFuture = FutureUtils.combineAll(getOperations);
            if (blobType == BlobKey.BlobType.PERMANENT_BLOB) {
                filesFuture.get();
            } else {
                int completedSuccessfully = 0;
                for (CompletableFuture completableFuture : getOperations) {
                    try {
                        completableFuture.get();
                        ++completedSuccessfully;
                    }
                    catch (Throwable t) {
                        if (org.apache.commons.lang3.exception.ExceptionUtils.getRootCause((Throwable)t) instanceof FileNotFoundException) continue;
                        ExceptionUtils.rethrowIOException((Throwable)t);
                    }
                }
                MatcherAssert.assertThat((Object)completedSuccessfully, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
            }
        }
        finally {
            executor.shutdownNow();
        }
    }
}

