/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

public class LongArrayList {
    private int size = 0;
    private long[] array;

    public LongArrayList(int capacity) {
        this.array = new long[capacity];
    }

    public int size() {
        return this.size;
    }

    public boolean add(long number) {
        this.grow(this.size + 1);
        this.array[this.size++] = number;
        return true;
    }

    public long removeLong(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        long old = this.array[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index);
        }
        return old;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private void grow(int length) {
        if (length > this.array.length) {
            int newLength = (int)Math.max(Math.min(2L * (long)this.array.length, 0x7FFFFFF7L), (long)length);
            long[] t = new long[newLength];
            System.arraycopy(this.array, 0, t, 0, this.size);
            this.array = t;
        }
    }
}

