/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.shipping;

import org.apache.flink.api.common.distributions.DataDistribution;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.types.Key;
import org.apache.flink.types.Record;

public class RecordOutputEmitter
implements ChannelSelector<Record> {
    private static final byte[] DEFAULT_SALT = new byte[]{17, 31, 47, 51, 83, 1};
    private final ShipStrategyType strategy;
    private final TypeComparator<Record> comparator;
    private int[] channels;
    private Key<?>[][] partitionBoundaries;
    private final DataDistribution distribution;
    private final Partitioner<Object> partitioner;
    private int nextChannelToSendTo;
    private Object[] extractedKeys;

    public RecordOutputEmitter(ShipStrategyType strategy) {
        this(strategy, null);
    }

    public RecordOutputEmitter(ShipStrategyType strategy, TypeComparator<Record> comparator) {
        this(strategy, comparator, null, null);
    }

    public RecordOutputEmitter(ShipStrategyType strategy, TypeComparator<Record> comparator, DataDistribution distr) {
        this(strategy, comparator, null, distr);
    }

    public RecordOutputEmitter(ShipStrategyType strategy, TypeComparator<Record> comparator, Partitioner<?> partitioner) {
        this(strategy, comparator, partitioner, null);
    }

    public RecordOutputEmitter(ShipStrategyType strategy, TypeComparator<Record> comparator, Partitioner<?> partitioner, DataDistribution distr) {
        if (strategy == null) {
            throw new NullPointerException();
        }
        this.strategy = strategy;
        this.comparator = comparator;
        this.distribution = distr;
        this.partitioner = partitioner;
        switch (strategy) {
            case FORWARD: 
            case PARTITION_FORCED_REBALANCE: 
            case PARTITION_HASH: 
            case PARTITION_RANGE: 
            case PARTITION_RANDOM: {
                this.channels = new int[1];
                break;
            }
            case BROADCAST: 
            case PARTITION_CUSTOM: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid shipping strategy for OutputEmitter: " + strategy.name());
            }
        }
        if (strategy == ShipStrategyType.PARTITION_RANGE && distr == null) {
            throw new NullPointerException("Data distribution must not be null when the ship strategy is range partitioning.");
        }
        if (strategy == ShipStrategyType.PARTITION_CUSTOM && partitioner == null) {
            throw new NullPointerException("Partitioner must not be null when the ship strategy is set to custom partitioning.");
        }
    }

    @Override
    public final int[] selectChannels(Record record, int numberOfChannels) {
        switch (this.strategy) {
            case FORWARD: 
            case PARTITION_FORCED_REBALANCE: 
            case PARTITION_RANDOM: {
                return this.robin(numberOfChannels);
            }
            case PARTITION_HASH: {
                return this.hashPartitionDefault(record, numberOfChannels);
            }
            case PARTITION_CUSTOM: {
                return this.customPartition(record, numberOfChannels);
            }
            case BROADCAST: {
                return this.broadcast(numberOfChannels);
            }
            case PARTITION_RANGE: {
                return this.rangePartition(record, numberOfChannels);
            }
        }
        throw new UnsupportedOperationException("Unsupported distribution strategy: " + this.strategy.name());
    }

    private final int[] robin(int numberOfChannels) {
        int channel = this.nextChannelToSendTo;
        this.nextChannelToSendTo = channel > 0 ? channel - 1 : numberOfChannels - 1;
        this.channels[0] = channel;
        return this.channels;
    }

    private final int[] broadcast(int numberOfChannels) {
        if (this.channels == null || this.channels.length != numberOfChannels) {
            this.channels = new int[numberOfChannels];
            for (int i = 0; i < numberOfChannels; ++i) {
                this.channels[i] = i;
            }
        }
        return this.channels;
    }

    private final int[] hashPartitionDefault(Record record, int numberOfChannels) {
        int hash = this.comparator.hash((Object)record);
        for (int i = 0; i < DEFAULT_SALT.length; ++i) {
            hash ^= (hash << 5) + DEFAULT_SALT[i] + (hash >> 2);
        }
        this.channels[0] = hash < 0 ? (hash == Integer.MIN_VALUE ? Integer.MAX_VALUE % numberOfChannels : -hash % numberOfChannels) : hash % numberOfChannels;
        return this.channels;
    }

    private final int[] rangePartition(Record record, int numberOfChannels) {
        if (this.partitionBoundaries == null) {
            this.partitionBoundaries = new Key[numberOfChannels - 1][];
            for (int i = 0; i < numberOfChannels - 1; ++i) {
                this.partitionBoundaries[i] = this.distribution.getBucketBoundary(i, numberOfChannels);
            }
        }
        if (numberOfChannels == this.partitionBoundaries.length + 1) {
            Key<?>[][] boundaries = this.partitionBoundaries;
            this.comparator.setReference((Object)record);
            int low = 0;
            int high = this.partitionBoundaries.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int result = this.comparator.compareAgainstReference(boundaries[mid]);
                if (result < 0) {
                    low = mid + 1;
                    continue;
                }
                if (result > 0) {
                    high = mid - 1;
                    continue;
                }
                this.channels[0] = mid;
                return this.channels;
            }
            this.channels[0] = low;
            return this.channels;
        }
        throw new IllegalStateException("The number of channels to partition among is inconsistent with the partitioners state.");
    }

    private final int[] customPartition(Record record, int numberOfChannels) {
        if (this.channels == null) {
            this.channels = new int[1];
            this.extractedKeys = new Object[1];
        }
        try {
            if (this.comparator.extractKeys((Object)record, this.extractedKeys, 0) == 1) {
                Object key = this.extractedKeys[0];
                this.channels[0] = this.partitioner.partition(key, numberOfChannels);
                return this.channels;
            }
            throw new RuntimeException("Inconsistency in the key comparator - comparator extracted more than one field.");
        }
        catch (Throwable t) {
            throw new RuntimeException("Error while calling custom partitioner.", t);
        }
    }
}

