/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.shipping;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.types.Record;
import org.apache.flink.util.Collector;

public class RecordOutputCollector
implements Collector<Record> {
    protected RecordWriter<Record>[] writers;

    public RecordOutputCollector(List<RecordWriter<Record>> writers) {
        this.writers = writers.toArray(new RecordWriter[writers.size()]);
    }

    public void addWriter(RecordWriter<Record> writer) {
        if (this.writers == null) {
            this.writers = new RecordWriter[]{writer};
        } else {
            RecordWriter[] ws = new RecordWriter[this.writers.length + 1];
            System.arraycopy(this.writers, 0, ws, 0, this.writers.length);
            ws[this.writers.length] = writer;
            this.writers = ws;
        }
    }

    public void collect(Record record) {
        try {
            for (int i = 0; i < this.writers.length; ++i) {
                this.writers[i].emit(record);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Emitting the record caused an I/O exception: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Emitting the record was interrupted: " + e.getMessage(), e);
        }
    }

    public void close() {
        for (RecordWriter<Record> writer : this.writers) {
            try {
                writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public List<RecordWriter<Record>> getWriters() {
        return Collections.unmodifiableList(Arrays.asList(this.writers));
    }
}

