/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.flink.runtime.instance.SlotSharingGroupAssignment;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class SlotSharingGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<JobVertexID> ids = new TreeSet<JobVertexID>();
    private transient SlotSharingGroupAssignment taskAssignment;

    public SlotSharingGroup() {
    }

    public SlotSharingGroup(JobVertexID ... sharedVertices) {
        for (JobVertexID id : sharedVertices) {
            this.ids.add(id);
        }
    }

    public void addVertexToGroup(JobVertexID id) {
        this.ids.add(id);
    }

    public void removeVertexFromGroup(JobVertexID id) {
        this.ids.remove((Object)id);
    }

    public Set<JobVertexID> getJobVertexIds() {
        return Collections.unmodifiableSet(this.ids);
    }

    public SlotSharingGroupAssignment getTaskAssignment() {
        if (this.taskAssignment == null) {
            this.taskAssignment = new SlotSharingGroupAssignment();
        }
        return this.taskAssignment;
    }

    public void clearTaskAssignment() {
        if (this.taskAssignment != null && this.taskAssignment.getNumberOfSlots() > 0) {
            throw new IllegalStateException("SlotSharingGroup cannot clear task assignment, group still has allocated resources.");
        }
        this.taskAssignment = null;
    }

    public String toString() {
        return "SlotSharingGroup " + this.ids.toString();
    }
}

