/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.jobmanager.JobManagerMode;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class JobManagerCliOptions {
    private String configDir;
    private JobManagerMode jobManagerMode;
    private StreamingMode streamingMode = StreamingMode.BATCH_ONLY;
    private String host;
    private int webUIPort = -1;

    public String getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public JobManagerMode getJobManagerMode() {
        return this.jobManagerMode;
    }

    public void setJobManagerMode(String modeName) {
        if (modeName.equalsIgnoreCase("cluster")) {
            this.jobManagerMode = JobManagerMode.CLUSTER;
        } else if (modeName.equalsIgnoreCase("local")) {
            this.jobManagerMode = JobManagerMode.LOCAL;
        } else {
            throw new IllegalArgumentException("Unknown execution mode. Execution mode must be one of 'cluster' or 'local'.");
        }
    }

    public StreamingMode getStreamingMode() {
        return this.streamingMode;
    }

    public void setStreamingMode(String modeName) {
        if (modeName.equalsIgnoreCase("streaming")) {
            this.streamingMode = StreamingMode.STREAMING;
        } else if (modeName.equalsIgnoreCase("batch")) {
            this.streamingMode = StreamingMode.BATCH_ONLY;
        } else {
            throw new IllegalArgumentException("Unknown streaming mode. Streaming mode must be one of 'BATCH' or 'STREAMING'.");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = Preconditions.checkNotNull(host);
    }

    public int getWebUIPort() {
        return this.webUIPort;
    }

    public void setWebUIPort(int webUIPort) {
        this.webUIPort = webUIPort;
    }
}

