/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.Serializable;
import java.util.List;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class JobSnapshottingSettings
implements Serializable {
    private static final long serialVersionUID = -2593319571078198180L;
    public static final long DEFAULT_SNAPSHOT_TIMEOUT = 600000L;
    private final List<JobVertexID> verticesToTrigger;
    private final List<JobVertexID> verticesToAcknowledge;
    private final List<JobVertexID> verticesToConfirm;
    private final long checkpointInterval;
    private final long checkpointTimeout;

    public JobSnapshottingSettings(List<JobVertexID> verticesToTrigger, List<JobVertexID> verticesToAcknowledge, List<JobVertexID> verticesToConfirm, long checkpointInterval) {
        this(verticesToTrigger, verticesToAcknowledge, verticesToConfirm, checkpointInterval, 600000L);
    }

    public JobSnapshottingSettings(List<JobVertexID> verticesToTrigger, List<JobVertexID> verticesToAcknowledge, List<JobVertexID> verticesToConfirm, long checkpointInterval, long checkpointTimeout) {
        this.verticesToTrigger = verticesToTrigger;
        this.verticesToAcknowledge = verticesToAcknowledge;
        this.verticesToConfirm = verticesToConfirm;
        this.checkpointInterval = checkpointInterval;
        this.checkpointTimeout = checkpointTimeout;
    }

    public List<JobVertexID> getVerticesToTrigger() {
        return this.verticesToTrigger;
    }

    public List<JobVertexID> getVerticesToAcknowledge() {
        return this.verticesToAcknowledge;
    }

    public List<JobVertexID> getVerticesToConfirm() {
        return this.verticesToConfirm;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public long getCheckpointTimeout() {
        return this.checkpointTimeout;
    }

    public String toString() {
        return String.format("SnapshotSettings: interval=%d, timeout=%d, trigger=%s, ack=%s, commit=%s", this.checkpointInterval, this.checkpointTimeout, this.verticesToTrigger, this.verticesToAcknowledge, this.verticesToConfirm);
    }
}

