/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.jsonplan;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;

public class JsonPlanGenerator {
    private static final String NOT_SET = "(not set)";
    private static final String EMPTY = "{}";

    public static String generatePlan(JobGraph jg) {
        try {
            StringWriter writer = new StringWriter(1024);
            JsonFactory factory = new JsonFactory();
            JsonGenerator gen = factory.createGenerator((Writer)writer);
            gen.writeStartObject();
            gen.writeStringField("jid", jg.getJobID().toString());
            gen.writeStringField("name", jg.getName());
            gen.writeArrayFieldStart("nodes");
            for (JobVertex vertex : jg.getVertices()) {
                String operator = vertex.getOperatorName() != null ? vertex.getOperatorName() : NOT_SET;
                String operatorDescr = vertex.getOperatorDescription() != null ? vertex.getOperatorDescription() : NOT_SET;
                String optimizerProps = vertex.getResultOptimizerProperties() != null ? vertex.getResultOptimizerProperties() : EMPTY;
                String description = vertex.getOperatorPrettyName() != null ? vertex.getOperatorPrettyName() : vertex.getName();
                description = StringEscapeUtils.escapeHtml4(description);
                description = description.replace("\n", "<br/>");
                description = description.replace("\\", "&#92;");
                operatorDescr = StringEscapeUtils.escapeHtml4(operatorDescr);
                operatorDescr = operatorDescr.replace("\n", "<br/>");
                gen.writeStartObject();
                gen.writeStringField("id", vertex.getID().toString());
                gen.writeNumberField("parallelism", vertex.getParallelism());
                gen.writeStringField("operator", operator);
                gen.writeStringField("operator_strategy", operatorDescr);
                gen.writeStringField("description", description);
                if (!vertex.isInputVertex()) {
                    gen.writeArrayFieldStart("inputs");
                    List<JobEdge> inputs = vertex.getInputs();
                    for (int inputNum = 0; inputNum < inputs.size(); ++inputNum) {
                        JobEdge edge = inputs.get(inputNum);
                        if (edge.getSource() == null) continue;
                        JobVertex predecessor = edge.getSource().getProducer();
                        String shipStrategy = edge.getShipStrategyName();
                        String preProcessingOperation = edge.getPreProcessingOperationName();
                        String operatorLevelCaching = edge.getOperatorLevelCachingDescription();
                        gen.writeStartObject();
                        gen.writeNumberField("num", inputNum);
                        gen.writeStringField("id", predecessor.getID().toString());
                        if (shipStrategy != null) {
                            gen.writeStringField("ship_strategy", shipStrategy);
                        }
                        if (preProcessingOperation != null) {
                            gen.writeStringField("local_strategy", preProcessingOperation);
                        }
                        if (operatorLevelCaching != null) {
                            gen.writeStringField("caching", operatorLevelCaching);
                        }
                        gen.writeStringField("exchange", edge.getSource().getResultType().name().toLowerCase());
                        gen.writeEndObject();
                    }
                    gen.writeEndArray();
                }
                gen.writeFieldName("optimizer_properties");
                gen.writeRawValue(optimizerProps);
                gen.writeEndObject();
            }
            gen.writeEndArray();
            gen.writeEndObject();
            gen.close();
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate plan", e);
        }
    }
}

