/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyServer;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyClient {
    private static final Logger LOG = LoggerFactory.getLogger(NettyClient.class);
    private final NettyConfig config;
    private Bootstrap bootstrap;

    NettyClient(NettyConfig config) {
        this.config = config;
    }

    void init(final NettyProtocol protocol) throws IOException {
        Preconditions.checkState(this.bootstrap == null, "Netty client has already been initialized.");
        long start = System.currentTimeMillis();
        this.bootstrap = new Bootstrap();
        switch (this.config.getTransportType()) {
            case NIO: {
                this.initNioBootstrap();
                break;
            }
            case EPOLL: {
                this.initEpollBootstrap();
                break;
            }
            case AUTO: {
                if (Epoll.isAvailable()) {
                    this.initEpollBootstrap();
                    LOG.info("Transport type 'auto': using EPOLL.");
                    break;
                }
                this.initNioBootstrap();
                LOG.info("Transport type 'auto': using NIO.");
            }
        }
        this.bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(this.config.getClientConnectTimeoutSeconds() * 1000));
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        int receiveAndSendBufferSize = this.config.getSendAndReceiveBufferSize();
        if (receiveAndSendBufferSize > 0) {
            this.bootstrap.option(ChannelOption.SO_SNDBUF, (Object)receiveAndSendBufferSize);
            this.bootstrap.option(ChannelOption.SO_RCVBUF, (Object)receiveAndSendBufferSize);
        }
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                channel.pipeline().addLast(protocol.getClientChannelHandlers());
            }
        });
        long end = System.currentTimeMillis();
        LOG.info("Successful initialization (took {} ms).", (Object)(end - start));
    }

    NettyConfig getConfig() {
        return this.config;
    }

    void shutdown() {
        long start = System.currentTimeMillis();
        if (this.bootstrap != null) {
            if (this.bootstrap.group() != null) {
                this.bootstrap.group().shutdownGracefully();
            }
            this.bootstrap = null;
        }
        long end = System.currentTimeMillis();
        LOG.info("Successful shutdown (took {} ms).", (Object)(end - start));
    }

    private void initNioBootstrap() {
        String name = "Flink Netty Client (" + this.config.getServerPort() + ")";
        NioEventLoopGroup nioGroup = new NioEventLoopGroup(this.config.getClientNumThreads(), NettyServer.getNamedThreadFactory(name));
        ((Bootstrap)this.bootstrap.group((EventLoopGroup)nioGroup)).channel(NioSocketChannel.class);
    }

    private void initEpollBootstrap() {
        String name = "Flink Netty Client (" + this.config.getServerPort() + ")";
        EpollEventLoopGroup epollGroup = new EpollEventLoopGroup(this.config.getServerNumThreads(), NettyServer.getNamedThreadFactory(name));
        ((Bootstrap)this.bootstrap.group((EventLoopGroup)epollGroup)).channel(EpollSocketChannel.class);
    }

    ChannelFuture connect(SocketAddress serverSocketAddress) {
        Preconditions.checkState(this.bootstrap != null, "Client has not been initialized yet.");
        try {
            return this.bootstrap.connect(serverSocketAddress);
        }
        catch (ChannelException e) {
            if (e.getCause() instanceof SocketException && e.getCause().getMessage().equals("Too many open files") || e.getCause() instanceof ChannelException && e.getCause().getCause() instanceof SocketException && e.getCause().getCause().getMessage().equals("Too many open files")) {
                throw new ChannelException("The operating system does not offer enough file handles to open the network connection. Please increase the number of of available file handles.", e.getCause());
            }
            throw e;
        }
    }
}

