/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.deployment.InputChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.PartialInputChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import scala.concurrent.duration.FiniteDuration;

public class ExecutionVertex
implements Serializable {
    private static final long serialVersionUID = 42L;
    private static final Logger LOG = ExecutionGraph.LOG;
    private static final int MAX_DISTINCT_LOCATIONS_TO_CONSIDER = 8;
    private final ExecutionJobVertex jobVertex;
    private Map<IntermediateResultPartitionID, IntermediateResultPartition> resultPartitions;
    private ExecutionEdge[][] inputEdges;
    private final int subTaskIndex;
    private final List<Execution> priorExecutions;
    private final FiniteDuration timeout;
    private volatile CoLocationConstraint locationConstraint;
    private volatile Execution currentExecution;
    private volatile List<Instance> locationConstraintInstances;
    private volatile boolean scheduleLocalOnly;

    public ExecutionVertex(ExecutionJobVertex jobVertex, int subTaskIndex, IntermediateResult[] producedDataSets, FiniteDuration timeout) {
        this(jobVertex, subTaskIndex, producedDataSets, timeout, System.currentTimeMillis());
    }

    public ExecutionVertex(ExecutionJobVertex jobVertex, int subTaskIndex, IntermediateResult[] producedDataSets, FiniteDuration timeout, long createTimestamp) {
        this.jobVertex = jobVertex;
        this.subTaskIndex = subTaskIndex;
        this.resultPartitions = new LinkedHashMap<IntermediateResultPartitionID, IntermediateResultPartition>(producedDataSets.length, 1.0f);
        for (IntermediateResult result : producedDataSets) {
            IntermediateResultPartition irp = new IntermediateResultPartition(result, this, subTaskIndex);
            result.setPartition(subTaskIndex, irp);
            this.resultPartitions.put(irp.getPartitionId(), irp);
        }
        this.inputEdges = new ExecutionEdge[jobVertex.getJobVertex().getInputs().size()][];
        this.priorExecutions = new CopyOnWriteArrayList<Execution>();
        this.currentExecution = new Execution(this.getExecutionGraph().getExecutionContext(), this, 0, createTimestamp, timeout);
        CoLocationGroup clg = jobVertex.getCoLocationGroup();
        this.locationConstraint = clg != null ? clg.getLocationConstraint(subTaskIndex) : null;
        this.timeout = timeout;
    }

    public JobID getJobId() {
        return this.jobVertex.getJobId();
    }

    public ExecutionJobVertex getJobVertex() {
        return this.jobVertex;
    }

    public JobVertexID getJobvertexId() {
        return this.jobVertex.getJobVertexId();
    }

    public String getTaskName() {
        return this.jobVertex.getJobVertex().getName();
    }

    public String getTaskNameWithSubtaskIndex() {
        return String.format("%s (%d/%d)", this.jobVertex.getJobVertex().getName(), this.subTaskIndex + 1, this.getTotalNumberOfParallelSubtasks());
    }

    public int getSubTaskIndex() {
        return this.subTaskIndex;
    }

    public int getTotalNumberOfParallelSubtasks() {
        return this.jobVertex.getParallelism();
    }

    public int getParallelSubtaskIndex() {
        return this.subTaskIndex;
    }

    public int getNumberOfInputs() {
        return this.inputEdges.length;
    }

    public ExecutionEdge[] getInputEdges(int input) {
        if (input < 0 || input >= this.inputEdges.length) {
            throw new IllegalArgumentException(String.format("Input %d is out of range [0..%d)", input, this.inputEdges.length));
        }
        return this.inputEdges[input];
    }

    public CoLocationConstraint getLocationConstraint() {
        return this.locationConstraint;
    }

    public Execution getCurrentExecutionAttempt() {
        return this.currentExecution;
    }

    public ExecutionState getExecutionState() {
        return this.currentExecution.getState();
    }

    public long getStateTimestamp(ExecutionState state) {
        return this.currentExecution.getStateTimestamp(state);
    }

    public Throwable getFailureCause() {
        return this.currentExecution.getFailureCause();
    }

    public SimpleSlot getCurrentAssignedResource() {
        return this.currentExecution.getAssignedResource();
    }

    public InstanceConnectionInfo getCurrentAssignedResourceLocation() {
        return this.currentExecution.getAssignedResourceLocation();
    }

    public Execution getPriorExecutionAttempt(int attemptNumber) {
        if (attemptNumber >= 0 && attemptNumber < this.priorExecutions.size()) {
            return this.priorExecutions.get(attemptNumber);
        }
        throw new IllegalArgumentException("attempt does not exist");
    }

    public ExecutionGraph getExecutionGraph() {
        return this.jobVertex.getGraph();
    }

    public Map<IntermediateResultPartitionID, IntermediateResultPartition> getProducedPartitions() {
        return this.resultPartitions;
    }

    public void connectSource(int inputNumber, IntermediateResult source, JobEdge edge, int consumerNumber) {
        ExecutionEdge[] edges;
        DistributionPattern pattern = edge.getDistributionPattern();
        IntermediateResultPartition[] sourcePartitions = source.getPartitions();
        switch (pattern) {
            case POINTWISE: {
                edges = this.connectPointwise(sourcePartitions, inputNumber);
                break;
            }
            case ALL_TO_ALL: {
                edges = this.connectAllToAll(sourcePartitions, inputNumber);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized distribution pattern.");
            }
        }
        this.inputEdges[inputNumber] = edges;
        for (ExecutionEdge ee : edges) {
            ee.getSource().addConsumer(ee, consumerNumber);
        }
    }

    private ExecutionEdge[] connectAllToAll(IntermediateResultPartition[] sourcePartitions, int inputNumber) {
        ExecutionEdge[] edges = new ExecutionEdge[sourcePartitions.length];
        for (int i = 0; i < sourcePartitions.length; ++i) {
            IntermediateResultPartition irp = sourcePartitions[i];
            edges[i] = new ExecutionEdge(irp, this, inputNumber);
        }
        return edges;
    }

    private ExecutionEdge[] connectPointwise(IntermediateResultPartition[] sourcePartitions, int inputNumber) {
        int numSources = sourcePartitions.length;
        int parallelism = this.getTotalNumberOfParallelSubtasks();
        if (numSources == parallelism) {
            return new ExecutionEdge[]{new ExecutionEdge(sourcePartitions[this.subTaskIndex], this, inputNumber)};
        }
        if (numSources < parallelism) {
            int sourcePartition;
            if (parallelism % numSources == 0) {
                int factor = parallelism / numSources;
                sourcePartition = this.subTaskIndex / factor;
            } else {
                float factor = (float)parallelism / (float)numSources;
                sourcePartition = (int)((float)this.subTaskIndex / factor);
            }
            return new ExecutionEdge[]{new ExecutionEdge(sourcePartitions[sourcePartition], this, inputNumber)};
        }
        if (numSources % parallelism == 0) {
            int factor = numSources / parallelism;
            int startIndex = this.subTaskIndex * factor;
            ExecutionEdge[] edges = new ExecutionEdge[factor];
            for (int i = 0; i < factor; ++i) {
                edges[i] = new ExecutionEdge(sourcePartitions[startIndex + i], this, inputNumber);
            }
            return edges;
        }
        float factor = (float)numSources / (float)parallelism;
        int start = (int)((float)this.subTaskIndex * factor);
        int end = this.subTaskIndex == this.getTotalNumberOfParallelSubtasks() - 1 ? sourcePartitions.length : (int)((float)(this.subTaskIndex + 1) * factor);
        ExecutionEdge[] edges = new ExecutionEdge[end - start];
        for (int i = 0; i < edges.length; ++i) {
            edges[i] = new ExecutionEdge(sourcePartitions[start + i], this, inputNumber);
        }
        return edges;
    }

    public void setLocationConstraintHosts(List<Instance> instances) {
        this.locationConstraintInstances = instances;
    }

    public void setScheduleLocalOnly(boolean scheduleLocalOnly) {
        if (scheduleLocalOnly && this.inputEdges != null && this.inputEdges.length > 0) {
            throw new IllegalArgumentException("Strictly local scheduling is only supported for sources.");
        }
        this.scheduleLocalOnly = scheduleLocalOnly;
    }

    public boolean isScheduleLocalOnly() {
        return this.scheduleLocalOnly;
    }

    public Iterable<Instance> getPreferredLocations() {
        List<Instance> constraintInstances = this.locationConstraintInstances;
        if (constraintInstances != null && !constraintInstances.isEmpty()) {
            return constraintInstances;
        }
        if (this.inputEdges == null) {
            return Collections.emptySet();
        }
        HashSet<Instance> locations = new HashSet<Instance>();
        HashSet<Instance> inputLocations = new HashSet<Instance>();
        for (int i = 0; i < this.inputEdges.length; ++i) {
            inputLocations.clear();
            ExecutionEdge[] sources = this.inputEdges[i];
            if (sources != null) {
                for (int k = 0; k < sources.length; ++k) {
                    SimpleSlot sourceSlot = sources[k].getSource().getProducer().getCurrentAssignedResource();
                    if (sourceSlot == null) continue;
                    inputLocations.add(sourceSlot.getInstance());
                    if (inputLocations.size() <= 8) continue;
                    inputLocations.clear();
                    break;
                }
            }
            if (!locations.isEmpty() && (inputLocations.isEmpty() || inputLocations.size() >= locations.size())) continue;
            locations.clear();
            locations.addAll(inputLocations);
        }
        return locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForNewExecution() {
        LOG.debug("Resetting execution vertex {} for new execution.", (Object)this.getSimpleName());
        List<Execution> list = this.priorExecutions;
        synchronized (list) {
            Execution execution = this.currentExecution;
            ExecutionState state = execution.getState();
            if (state == ExecutionState.FINISHED || state == ExecutionState.CANCELED || state == ExecutionState.FAILED) {
                this.priorExecutions.add(execution);
                this.currentExecution = new Execution(this.getExecutionGraph().getExecutionContext(), this, execution.getAttemptNumber() + 1, System.currentTimeMillis(), this.timeout);
                CoLocationGroup grp = this.jobVertex.getCoLocationGroup();
                if (grp != null) {
                    this.locationConstraint = grp.getLocationConstraint(this.subTaskIndex);
                }
            } else {
                throw new IllegalStateException("Cannot reset a vertex that is in state " + (Object)((Object)state));
            }
        }
    }

    public boolean scheduleForExecution(Scheduler scheduler, boolean queued) throws NoResourceAvailableException {
        return this.currentExecution.scheduleForExecution(scheduler, queued);
    }

    public void deployToSlot(SimpleSlot slot) throws JobException {
        this.currentExecution.deployToSlot(slot);
    }

    public void cancel() {
        this.currentExecution.cancel();
    }

    public void fail(Throwable t) {
        this.currentExecution.fail(t);
    }

    public void sendMessageToCurrentExecution(Serializable message, ExecutionAttemptID attemptID) {
        Execution exec = this.getCurrentExecutionAttempt();
        if (exec != null && exec.getAttemptId().equals((Object)attemptID)) {
            SimpleSlot slot = exec.getAssignedResource();
            if (slot != null) {
                ActorGateway gateway = slot.getInstance().getActorGateway();
                if (gateway != null) {
                    gateway.tell(message);
                }
            } else {
                LOG.debug("Skipping message to undeployed task execution {}/{}", (Object)this.getSimpleName(), (Object)attemptID);
            }
        } else {
            LOG.debug("Skipping message to {}/{} because it does not match the current execution", (Object)this.getSimpleName(), (Object)attemptID);
        }
    }

    void scheduleOrUpdateConsumers(ResultPartitionID partitionId) {
        Execution execution = this.currentExecution;
        if (!partitionId.getProducerId().equals((Object)execution.getAttemptId())) {
            return;
        }
        IntermediateResultPartition partition = this.resultPartitions.get((Object)partitionId.getPartitionId());
        if (partition == null) {
            throw new IllegalStateException("Unknown partition " + partitionId + ".");
        }
        if (!partition.getIntermediateResult().getResultType().isPipelined()) {
            throw new IllegalArgumentException("ScheduleOrUpdateConsumers msg is only valid forpipelined partitions.");
        }
        execution.scheduleOrUpdateConsumers(partition.getConsumers());
    }

    public void prepareForArchiving() throws IllegalStateException {
        Execution execution = this.currentExecution;
        ExecutionState state = execution.getState();
        if (state != ExecutionState.FINISHED && state != ExecutionState.CANCELED && state != ExecutionState.FAILED) {
            throw new IllegalStateException("Cannot archive ExecutionVertex that is not in a finished state.");
        }
        execution.prepareForArchiving();
        for (Execution exec : this.priorExecutions) {
            exec.prepareForArchiving();
        }
        this.resultPartitions = null;
        this.inputEdges = null;
        this.locationConstraint = null;
        this.locationConstraintInstances = null;
    }

    public void cachePartitionInfo(PartialInputChannelDeploymentDescriptor partitionInfo) {
        this.getCurrentExecutionAttempt().cachePartitionInfo(partitionInfo);
    }

    void sendPartitionInfos() {
        this.currentExecution.sendPartitionInfos();
    }

    List<IntermediateResultPartition> finishAllBlockingPartitions() {
        LinkedList<IntermediateResultPartition> finishedBlockingPartitions = null;
        for (IntermediateResultPartition partition : this.resultPartitions.values()) {
            if (!partition.getResultType().isBlocking() || !partition.markFinished()) continue;
            if (finishedBlockingPartitions == null) {
                finishedBlockingPartitions = new LinkedList<IntermediateResultPartition>();
            }
            finishedBlockingPartitions.add(partition);
        }
        if (finishedBlockingPartitions == null) {
            return Collections.emptyList();
        }
        return finishedBlockingPartitions;
    }

    void executionFinished() {
        this.jobVertex.vertexFinished(this.subTaskIndex);
    }

    void executionCanceled() {
        this.jobVertex.vertexCancelled(this.subTaskIndex);
    }

    void executionFailed(Throwable t) {
        this.jobVertex.vertexFailed(this.subTaskIndex, t);
    }

    void notifyStateTransition(ExecutionAttemptID executionId, ExecutionState newState, Throwable error) {
        this.getExecutionGraph().notifyExecutionChange(this.getJobvertexId(), this.subTaskIndex, executionId, newState, error);
    }

    TaskDeploymentDescriptor createDeploymentDescriptor(ExecutionAttemptID executionId, SimpleSlot targetSlot, SerializedValue<StateHandle<?>> operatorState) {
        ArrayList<ResultPartitionDeploymentDescriptor> producedPartitions = new ArrayList<ResultPartitionDeploymentDescriptor>(this.resultPartitions.size());
        for (IntermediateResultPartition partition : this.resultPartitions.values()) {
            producedPartitions.add(ResultPartitionDeploymentDescriptor.from(partition));
        }
        ArrayList<InputGateDeploymentDescriptor> consumedPartitions = new ArrayList<InputGateDeploymentDescriptor>();
        for (ExecutionEdge[] edges : this.inputEdges) {
            InputChannelDeploymentDescriptor[] partitions = InputChannelDeploymentDescriptor.fromEdges(edges, targetSlot);
            int numConsumerEdges = edges[0].getSource().getConsumers().get(0).size();
            int queueToRequest = this.subTaskIndex % numConsumerEdges;
            IntermediateDataSetID resultId = edges[0].getSource().getIntermediateResult().getId();
            consumedPartitions.add(new InputGateDeploymentDescriptor(resultId, queueToRequest, partitions));
        }
        List<BlobKey> jarFiles = this.getExecutionGraph().getRequiredJarFiles();
        List<URL> classpaths = this.getExecutionGraph().getRequiredClasspaths();
        return new TaskDeploymentDescriptor(this.getJobId(), this.getJobvertexId(), executionId, this.getTaskName(), this.subTaskIndex, this.getTotalNumberOfParallelSubtasks(), this.getExecutionGraph().getJobConfiguration(), this.jobVertex.getJobVertex().getConfiguration(), this.jobVertex.getJobVertex().getInvokableClassName(), producedPartitions, consumedPartitions, jarFiles, classpaths, targetSlot.getRoot().getSlotNumber(), operatorState);
    }

    public String getSimpleName() {
        return this.getTaskName() + " (" + (this.getParallelSubtaskIndex() + 1) + '/' + this.getTotalNumberOfParallelSubtasks() + ')';
    }

    public String toString() {
        return this.getSimpleName();
    }
}

