/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.StateForTask;

public class CompletedCheckpoint
implements Serializable {
    private static final long serialVersionUID = -8360248179615702014L;
    private final JobID job;
    private final long checkpointID;
    private final long timestamp;
    private final ArrayList<StateForTask> states;

    public CompletedCheckpoint(JobID job, long checkpointID, long timestamp, ArrayList<StateForTask> states) {
        this.job = job;
        this.checkpointID = checkpointID;
        this.timestamp = timestamp;
        this.states = states;
    }

    public JobID getJobId() {
        return this.job;
    }

    public long getCheckpointID() {
        return this.checkpointID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<StateForTask> getStates() {
        return this.states;
    }

    public void discard(ClassLoader userClassLoader) {
        for (StateForTask state : this.states) {
            state.discard(userClassLoader);
        }
        this.states.clear();
    }

    public String toString() {
        return String.format("Checkpoint %d @ %d for %s", this.checkpointID, this.timestamp, this.job);
    }
}

