/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import akka.actor.ActorSystem;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebMonitorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WebMonitorUtils.class);

    public static WebMonitor startWebRuntimeMonitor(Configuration config, LeaderRetrievalService leaderRetrievalService, ActorSystem actorSystem) {
        try {
            String classname = "org.apache.flink.runtime.webmonitor.WebRuntimeMonitor";
            Class<WebMonitor> clazz = Class.forName(classname).asSubclass(WebMonitor.class);
            Constructor<WebMonitor> constructor = clazz.getConstructor(Configuration.class, LeaderRetrievalService.class, ActorSystem.class);
            return constructor.newInstance(config, leaderRetrievalService, actorSystem);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not load web runtime monitor. Probably reason: flink-runtime-web is not in the classpath");
            LOG.debug("Caught exception", e);
            return null;
        }
        catch (InvocationTargetException e) {
            LOG.error("WebServer could not be created", e.getTargetException());
            return null;
        }
        catch (Throwable t) {
            LOG.error("Failed to instantiate web runtime monitor.", t);
            return null;
        }
    }

    public static Map<String, String> fromKeyValueJsonArray(JSONArray parsed) throws JSONException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < parsed.length(); ++i) {
            JSONObject jsonObject = parsed.getJSONObject(i);
            String key = jsonObject.getString("key");
            String value = jsonObject.getString("value");
            hashMap.put(key, value);
        }
        return hashMap;
    }

    public static JobDetails createDetailsForJob(ExecutionGraph job) {
        JobStatus status = job.getState();
        long started = job.getStatusTimestamp(JobStatus.CREATED);
        long finished = status.isTerminalState() ? job.getStatusTimestamp(status) : -1L;
        int[] countsPerStatus = new int[ExecutionState.values().length];
        long lastChanged = 0L;
        int numTotalTasks = 0;
        for (ExecutionJobVertex ejv : job.getVerticesTopologically()) {
            ExecutionVertex[] vertices = ejv.getTaskVertices();
            numTotalTasks += vertices.length;
            for (ExecutionVertex vertex : vertices) {
                ExecutionState state = vertex.getExecutionState();
                int n = state.ordinal();
                countsPerStatus[n] = countsPerStatus[n] + 1;
                lastChanged = Math.max(lastChanged, vertex.getStateTimestamp(state));
            }
        }
        lastChanged = Math.max(lastChanged, finished);
        return new JobDetails(job.getJobID(), job.getJobName(), started, finished, status, lastChanged, countsPerStatus, numTotalTasks);
    }

    private WebMonitorUtils() {
        throw new RuntimeException();
    }

    public static class LogFiles {
        private static LogFiles INSTANCE;
        public final File logFile;
        public final File stdOutFile;

        private LogFiles(String logFile) {
            this.logFile = LogFiles.checkFileLocation(logFile);
            String stdOutFile = logFile.replaceFirst("\\.log$", ".out");
            this.stdOutFile = LogFiles.checkFileLocation(stdOutFile);
        }

        private static File checkFileLocation(String logFilePath) {
            File logFile = new File(logFilePath);
            if (logFile.exists() && logFile.canRead()) {
                return logFile;
            }
            throw new IllegalConfigurationException("Job manager log file was supposed to be at " + logFile.getAbsolutePath() + " but it does not exist or is not readable.");
        }

        public static LogFiles find(Configuration config) {
            if (INSTANCE == null) {
                String logEnv = "log.file";
                String logFilePath = System.getProperty("log.file");
                if (logFilePath == null) {
                    LOG.warn("Log file environment variable '{}' is not set.", (Object)"log.file");
                    logFilePath = config.getString("jobmanager.web.log.path", null);
                }
                if (logFilePath == null) {
                    throw new IllegalConfigurationException("JobManager log file not found. Can't serve log files. Log file location couldn't be determined via the log.file environment variable or the config constant jobmanager.web.log.path");
                }
                INSTANCE = new LogFiles(logFilePath);
            }
            return INSTANCE;
        }
    }
}

