/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.taskmanager.TaskManager;
import scala.Option;
import scala.Tuple2;

public final class StandaloneUtils {
    public static StandaloneLeaderRetrievalService createLeaderRetrievalService(Configuration configuration) throws UnknownHostException {
        return StandaloneUtils.createLeaderRetrievalService(configuration, null);
    }

    public static StandaloneLeaderRetrievalService createLeaderRetrievalService(Configuration configuration, String jobManagerName) throws UnknownHostException {
        InetSocketAddress hostPort;
        Tuple2<String, Object> stringIntPair = TaskManager.getAndCheckJobManagerAddress(configuration);
        String jobManagerHostname = (String)stringIntPair._1();
        int jobManagerPort = (Integer)stringIntPair._2();
        try {
            InetAddress inetAddress = InetAddress.getByName(jobManagerHostname);
            hostPort = new InetSocketAddress(inetAddress, jobManagerPort);
        }
        catch (UnknownHostException e) {
            throw new UnknownHostException("Cannot resolve the JobManager hostname '" + jobManagerHostname + "' specified in the configuration");
        }
        String jobManagerAkkaUrl = JobManager.getRemoteJobManagerAkkaURL(hostPort, (Option<String>)Option.apply((Object)jobManagerName));
        return new StandaloneLeaderRetrievalService(jobManagerAkkaUrl);
    }

    private StandaloneUtils() {
        throw new RuntimeException();
    }
}

