/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.filesystem.FileSerializableStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FsHeapKvState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsStateBackend
extends StateBackend<FsStateBackend> {
    private static final long serialVersionUID = -8191916350224044011L;
    private static final Logger LOG = LoggerFactory.getLogger(FsStateBackend.class);
    private final Path basePath;
    private transient Path checkpointDirectory;
    private transient FileSystem filesystem;

    public FsStateBackend(String checkpointDataUri) throws IOException {
        this(new Path(checkpointDataUri));
    }

    public FsStateBackend(Path checkpointDataUri) throws IOException {
        this(checkpointDataUri.toUri());
    }

    public FsStateBackend(URI checkpointDataUri) throws IOException {
        String scheme = checkpointDataUri.getScheme();
        String path = checkpointDataUri.getPath();
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI.");
        }
        if (path == null) {
            throw new IllegalArgumentException("The path to store the checkpoint data in is null. Please specify a directory path for the checkpoint data.");
        }
        if (path.length() == 0 || path.equals("/")) {
            throw new IllegalArgumentException("Cannot use the root directory for checkpoints.");
        }
        this.filesystem = FileSystem.get((URI)checkpointDataUri);
        if (this.filesystem == null) {
            throw new IOException("Could not find a file system for the given scheme in the available configurations.");
        }
        URI fsURI = this.filesystem.getUri();
        try {
            URI baseURI = new URI(fsURI.getScheme(), fsURI.getAuthority(), path, null, null);
            this.basePath = new Path(baseURI);
        }
        catch (URISyntaxException e) {
            throw new IOException(String.format("Cannot create file system URI for checkpointDataUri %s and filesystem URI %s", checkpointDataUri, fsURI), e);
        }
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public Path getCheckpointDirectory() {
        return this.checkpointDirectory;
    }

    public boolean isInitialized() {
        return this.filesystem != null && this.checkpointDirectory != null;
    }

    public FileSystem getFileSystem() {
        if (this.filesystem != null) {
            return this.filesystem;
        }
        throw new IllegalStateException("State backend has not been initialized.");
    }

    @Override
    public void initializeForJob(JobID jobId) throws Exception {
        Path dir = new Path(this.basePath, jobId.toString());
        LOG.info("Initializing file state backend to URI " + dir);
        this.filesystem = this.basePath.getFileSystem();
        this.filesystem.mkdirs(dir);
        this.checkpointDirectory = dir;
    }

    @Override
    public void disposeAllStateForCurrentJob() throws Exception {
        FileSystem fs = this.filesystem;
        Path dir = this.checkpointDirectory;
        if (fs == null || dir == null) {
            throw new IllegalStateException("state backend has not been initialized");
        }
        this.filesystem = null;
        this.checkpointDirectory = null;
        fs.delete(dir, true);
    }

    @Override
    public void close() throws Exception {
    }

    public <K, V> FsHeapKvState<K, V> createKvState(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, V defaultValue) throws Exception {
        return new FsHeapKvState<K, V>(keySerializer, valueSerializer, defaultValue, this);
    }

    @Override
    public <S extends Serializable> StateHandle<S> checkpointStateSerializable(S state, long checkpointID, long timestamp) throws Exception {
        this.checkFileSystemInitialized();
        Path checkpointDir = this.createCheckpointDirPath(checkpointID);
        this.filesystem.mkdirs(checkpointDir);
        Exception latestException = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            FSDataOutputStream outStream;
            Path targetPath = new Path(checkpointDir, UUID.randomUUID().toString());
            try {
                outStream = this.filesystem.create(targetPath, false);
            }
            catch (Exception e) {
                latestException = e;
                continue;
            }
            ObjectOutputStream os = new ObjectOutputStream((OutputStream)outStream);
            os.writeObject(state);
            os.close();
            return new FileSerializableStateHandle(targetPath);
        }
        throw new Exception("Could not open output stream for state backend", latestException);
    }

    @Override
    public FsCheckpointStateOutputStream createCheckpointStateOutputStream(long checkpointID, long timestamp) throws Exception {
        this.checkFileSystemInitialized();
        Path checkpointDir = this.createCheckpointDirPath(checkpointID);
        this.filesystem.mkdirs(checkpointDir);
        Exception latestException = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            Path targetPath = new Path(checkpointDir, UUID.randomUUID().toString());
            try {
                FSDataOutputStream outStream = this.filesystem.create(targetPath, false);
                return new FsCheckpointStateOutputStream(outStream, targetPath, this.filesystem);
            }
            catch (Exception e) {
                latestException = e;
                continue;
            }
        }
        throw new Exception("Could not open output stream for state backend", latestException);
    }

    private void checkFileSystemInitialized() throws IllegalStateException {
        if (this.filesystem == null || this.checkpointDirectory == null) {
            throw new IllegalStateException("filesystem has not been re-initialized after deserialization");
        }
    }

    private Path createCheckpointDirPath(long checkpointID) {
        return new Path(this.checkpointDirectory, "chk-" + checkpointID);
    }

    public String toString() {
        return this.checkpointDirectory == null ? "File State Backend @ " + this.basePath : "File State Backend (initialized) @ " + this.checkpointDirectory;
    }

    public static final class FsCheckpointStateOutputStream
    extends StateBackend.CheckpointStateOutputStream {
        private final FSDataOutputStream outStream;
        private final Path filePath;
        private final FileSystem fs;
        private boolean closed;

        FsCheckpointStateOutputStream(FSDataOutputStream outStream, Path filePath, FileSystem fs) {
            this.outStream = outStream;
            this.filePath = filePath;
            this.fs = fs;
        }

        @Override
        public void write(int b) throws IOException {
            this.outStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.outStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            FsCheckpointStateOutputStream fsCheckpointStateOutputStream = this;
            synchronized (fsCheckpointStateOutputStream) {
                if (!this.closed) {
                    this.closed = true;
                    try {
                        this.outStream.close();
                        this.fs.delete(this.filePath, false);
                        try {
                            this.fs.delete(this.filePath.getParent(), false);
                        }
                        catch (IOException iOException) {}
                    }
                    catch (Exception e) {
                        LOG.warn("Cannot delete closed and discarded state stream to " + this.filePath, e);
                    }
                }
            }
        }

        @Override
        public FileStreamStateHandle closeAndGetHandle() throws IOException {
            return new FileStreamStateHandle(this.closeAndGetPath());
        }

        public Path closeAndGetPath() throws IOException {
            FsCheckpointStateOutputStream fsCheckpointStateOutputStream = this;
            synchronized (fsCheckpointStateOutputStream) {
                if (!this.closed) {
                    this.closed = true;
                    this.outStream.close();
                    return this.filePath;
                }
                throw new IOException("Stream has already been closed and discarded.");
            }
        }
    }
}

