/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.pattern.Patterns$;
import akka.pattern.package$;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.client.JobClient;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.messages.TaskManagerMessages$NotifyWhenRegisteredAtAnyJobManager$;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster$;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0011=a!B\u0001\u0003\u0003\u0003i!\u0001\u0005$mS:\\W*\u001b8j\u00072,8\u000f^3s\u0015\t\u0019A!A\u0006nS:L7\r\\;ti\u0016\u0014(BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0006\t\u0003\u001fQi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001\\1oO*\t1#\u0001\u0003kCZ\f\u0017BA\u000b\u0011\u0005\u0019y%M[3diB\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0010Y\u0016\fG-\u001a:sKR\u0014\u0018.\u001a<bY&\u00111\u0004\u0007\u0002\u0018\u0019\u0016\fG-\u001a:SKR\u0014\u0018.\u001a<bY2K7\u000f^3oKJD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0012kN,'oQ8oM&<WO]1uS>tW#A\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t2\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002%C\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0013kN,'oQ8oM&<WO]1uS>t\u0007\u0005\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0001*\u0003Q)8/Z*j]\u001edW-Q2u_J\u001c\u0016p\u001d;f[V\t!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCFA\u0004C_>dW-\u00198\t\u0011E\u0002!\u0011!Q\u0001\n)\nQ#^:f'&tw\r\\3BGR|'oU=ti\u0016l\u0007\u0005\u0003\u00054\u0001\t\u0015\r\u0011\"\u00015\u00035\u0019HO]3b[&tw-T8eKV\tQ\u0007\u0005\u00027o5\tA!\u0003\u00029\t\ti1\u000b\u001e:fC6LgnZ'pI\u0016D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006I!N\u0001\u000fgR\u0014X-Y7j]\u001elu\u000eZ3!\u0011\u0015a\u0004\u0001\"\u0001>\u0003\u0019a\u0014N\\5u}Q!a\bQ!C!\ty\u0004!D\u0001\u0003\u0011\u0015i2\b1\u0001 \u0011\u0015A3\b1\u0001+\u0011\u0015\u00194\b1\u00016\u0011\u0015a\u0004\u0001\"\u0001E)\rqTI\u0012\u0005\u0006;\r\u0003\ra\b\u0005\u0006\u000f\u000e\u0003\rAK\u0001\u0012g&tw\r\\3BGR|'oU=ti\u0016l\u0007bB%\u0001\u0005\u0004%\tBS\u0001\u0004\u0019>;U#A&\u0011\u00051{U\"A'\u000b\u00059S\u0011!B:mMRR\u0017B\u0001)N\u0005\u0019aunZ4fe\"1!\u000b\u0001Q\u0001\n-\u000bA\u0001T(HA!9A\u000b\u0001b\u0001\n\u0003)\u0016\u0001\u00035pgRt\u0017-\\3\u0016\u0003Y\u0003\"aD,\n\u0005a\u0003\"AB*ue&tw\r\u0003\u0004[\u0001\u0001\u0006IAV\u0001\nQ>\u001cHO\\1nK\u0002BqA\t\u0001C\u0002\u0013\u0005a\u0004\u0003\u0004^\u0001\u0001\u0006IaH\u0001\u000fG>tg-[4ve\u0006$\u0018n\u001c8!\u0011\u001dy\u0006\u00011A\u0005\u0002\u0001\fQ\u0002\\3bI\u0016\u0014x)\u0019;fo\u0006LX#A1\u0011\u0007\t,w-D\u0001d\u0015\t!G&\u0001\u0006d_:\u001cWO\u001d:f]RL!AZ2\u0003\u000fA\u0013x.\\5tKB\u0011\u0001n[\u0007\u0002S*\u0011!\u000eB\u0001\tS:\u001cH/\u00198dK&\u0011A.\u001b\u0002\r\u0003\u000e$xN]$bi\u0016<\u0018-\u001f\u0005\b]\u0002\u0001\r\u0011\"\u0001p\u0003EaW-\u00193fe\u001e\u000bG/Z<bs~#S-\u001d\u000b\u0003aN\u0004\"aK9\n\u0005Id#\u0001B+oSRDq\u0001^7\u0002\u0002\u0003\u0007\u0011-A\u0002yIEBaA\u001e\u0001!B\u0013\t\u0017A\u00047fC\u0012,'oR1uK^\f\u0017\u0010\t\u0005\bq\u0002\u0001\r\u0011\"\u0001z\u0003-aW-\u00193fe&sG-\u001a=\u0016\u0003i\u00042AY3|!\tYC0\u0003\u0002~Y\t\u0019\u0011J\u001c;\t\u0011}\u0004\u0001\u0019!C\u0001\u0003\u0003\tq\u0002\\3bI\u0016\u0014\u0018J\u001c3fq~#S-\u001d\u000b\u0004a\u0006\r\u0001b\u0002;\u007f\u0003\u0003\u0005\rA\u001f\u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003{\u00031aW-\u00193fe&sG-\u001a=!\u0011%\tY\u0001\u0001b\u0001\n\u0003\ti!\u0001\u0006gkR,(/\u001a'pG.,\u0012A\u0004\u0005\b\u0003#\u0001\u0001\u0015!\u0003\u000f\u0003-1W\u000f^;sK2{7m\u001b\u0011\t\u0013\u0005U\u0001A1A\u0005\u0004\u0005]\u0011\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\t\tI\u0002E\u0002c\u00037I1!!\bd\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN\u001d\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002\u001a\u0005\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\t\u0013\u0005\u0015\u0002A1A\u0005\u0004\u0005\u001d\u0012a\u0002;j[\u0016|W\u000f^\u000b\u0003\u0003S\u0001B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_\u0019\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\u0005M\u0012Q\u0006\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011!\t9\u0004\u0001Q\u0001\n\u0005%\u0012\u0001\u0003;j[\u0016|W\u000f\u001e\u0011\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005u\u0012\u0001\u0004:fG>4XM]=N_\u0012,WCAA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#\t\u0005Q!n\u001c2nC:\fw-\u001a:\n\t\u0005%\u00131\t\u0002\r%\u0016\u001cwN^3ss6{G-\u001a\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002@\u0005i!/Z2pm\u0016\u0014\u00180T8eK\u0002B\u0011\"!\u0015\u0001\u0005\u0004%\t!a\u0015\u0002\u001d9,XNS8c\u001b\u0006t\u0017mZ3sgV\t1\u0010C\u0004\u0002X\u0001\u0001\u000b\u0011B>\u0002\u001f9,XNS8c\u001b\u0006t\u0017mZ3sg\u0002B\u0011\"a\u0017\u0001\u0005\u0004%\t!a\u0015\u0002\u001f9,X\u000eV1tW6\u000bg.Y4feNDq!a\u0018\u0001A\u0003%10\u0001\tok6$\u0016m]6NC:\fw-\u001a:tA!I\u00111\r\u0001A\u0002\u0013\u0005\u0011QM\u0001\u0017U>\u0014W*\u00198bO\u0016\u0014\u0018i\u0019;peNK8\u000f^3ngV\u0011\u0011q\r\t\u0006W\u0005%\u0014QN\u0005\u0004\u0003Wb#AB(qi&|g\u000e\u0005\u0004\u0002p\u0005}\u0014Q\u0011\b\u0005\u0003c\nYH\u0004\u0003\u0002t\u0005eTBAA;\u0015\r\t9\bD\u0001\u0007yI|w\u000e\u001e \n\u00035J1!! -\u0003\u001d\u0001\u0018mY6bO\u0016LA!!!\u0002\u0004\n\u00191+Z9\u000b\u0007\u0005uD\u0006\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005\u0005=\u0015\u0001B1lW\u0006LA!a%\u0002\n\nY\u0011i\u0019;peNK8\u000f^3n\u0011%\t9\n\u0001a\u0001\n\u0003\tI*\u0001\u000ek_\nl\u0015M\\1hKJ\f5\r^8s'f\u001cH/Z7t?\u0012*\u0017\u000fF\u0002q\u00037C\u0011\u0002^AK\u0003\u0003\u0005\r!a\u001a\t\u0011\u0005}\u0005\u0001)Q\u0005\u0003O\nqC[8c\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]*zgR,Wn\u001d\u0011\t\u0013\u0005\r\u0006\u00011A\u0005\u0002\u0005\u0015\u0016\u0001\u00056pE6\u000bg.Y4fe\u0006\u001bGo\u001c:t+\t\t9\u000bE\u0003,\u0003S\nI\u000b\u0005\u0004\u0002p\u0005}\u00141\u0016\t\u0005\u0003\u000f\u000bi+\u0003\u0003\u00020\u0006%%\u0001C!di>\u0014(+\u001a4\t\u0013\u0005M\u0006\u00011A\u0005\u0002\u0005U\u0016\u0001\u00066pE6\u000bg.Y4fe\u0006\u001bGo\u001c:t?\u0012*\u0017\u000fF\u0002q\u0003oC\u0011\u0002^AY\u0003\u0003\u0005\r!a*\t\u0011\u0005m\u0006\u0001)Q\u0005\u0003O\u000b\u0011C[8c\u001b\u0006t\u0017mZ3s\u0003\u000e$xN]:!\u0011%\ty\f\u0001a\u0001\n\u0003\t\t-\u0001\u0006xK\nluN\\5u_J,\"!a1\u0011\u000b-\nI'!2\u0011\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013T1!a3\u0005\u0003)9XMY7p]&$xN]\u0005\u0005\u0003\u001f\fIM\u0001\u0006XK\nluN\\5u_JD\u0011\"a5\u0001\u0001\u0004%\t!!6\u0002\u001d],'-T8oSR|'o\u0018\u0013fcR\u0019\u0001/a6\t\u0013Q\f\t.!AA\u0002\u0005\r\u0007\u0002CAn\u0001\u0001\u0006K!a1\u0002\u0017],'-T8oSR|'\u000f\t\u0005\n\u0003?\u0004\u0001\u0019!C\u0001\u0003K\nq\u0003^1tW6\u000bg.Y4fe\u0006\u001bGo\u001c:TsN$X-\\:\t\u0013\u0005\r\b\u00011A\u0005\u0002\u0005\u0015\u0018a\u0007;bg.l\u0015M\\1hKJ\f5\r^8s'f\u001cH/Z7t?\u0012*\u0017\u000fF\u0002q\u0003OD\u0011\u0002^Aq\u0003\u0003\u0005\r!a\u001a\t\u0011\u0005-\b\u0001)Q\u0005\u0003O\n\u0001\u0004^1tW6\u000bg.Y4fe\u0006\u001bGo\u001c:TsN$X-\\:!\u0011%\ty\u000f\u0001a\u0001\n\u0003\t)+A\tuCN\\W*\u00198bO\u0016\u0014\u0018i\u0019;peND\u0011\"a=\u0001\u0001\u0004%\t!!>\u0002+Q\f7o['b]\u0006<WM]!di>\u00148o\u0018\u0013fcR\u0019\u0001/a>\t\u0013Q\f\t0!AA\u0002\u0005\u001d\u0006\u0002CA~\u0001\u0001\u0006K!a*\u0002%Q\f7o['b]\u0006<WM]!di>\u00148\u000f\t\u0005\n\u0003\u007f\u0004\u0001\u0019!C\t\u0005\u0003\ta\u0003\\3bI\u0016\u0014(+\u001a;sS\u00164\u0018\r\\*feZL7-Z\u000b\u0003\u0005\u0007\u0001RaKA5\u0005\u000b\u00012a\u0006B\u0004\u0013\r\u0011I\u0001\u0007\u0002\u0017\u0019\u0016\fG-\u001a:SKR\u0014\u0018.\u001a<bYN+'O^5dK\"I!Q\u0002\u0001A\u0002\u0013E!qB\u0001\u001bY\u0016\fG-\u001a:SKR\u0014\u0018.\u001a<bYN+'O^5dK~#S-\u001d\u000b\u0004a\nE\u0001\"\u0003;\u0003\f\u0005\u0005\t\u0019\u0001B\u0002\u0011!\u0011)\u0002\u0001Q!\n\t\r\u0011a\u00067fC\u0012,'OU3ue&,g/\u00197TKJ4\u0018nY3!\u0011!\u0011I\u0002\u0001a\u0001\n\u0013I\u0013!C5t%Vtg.\u001b8h\u0011%\u0011i\u0002\u0001a\u0001\n\u0013\u0011y\"A\u0007jgJ+hN\\5oO~#S-\u001d\u000b\u0004a\n\u0005\u0002\u0002\u0003;\u0003\u001c\u0005\u0005\t\u0019\u0001\u0016\t\u000f\t\u0015\u0002\u0001)Q\u0005U\u0005Q\u0011n\u001d*v]:Lgn\u001a\u0011\t\u000f\t%\u0002A\"\u0001\u0003,\u0005)r-\u001a8fe\u0006$XmQ8oM&<WO]1uS>tGcA\u0010\u0003.!1QDa\nA\u0002}AqA!\r\u0001\r\u0003\u0011\u0019$A\bti\u0006\u0014HOS8c\u001b\u0006t\u0017mZ3s)\u0019\tYK!\u000e\u0003:!9!q\u0007B\u0018\u0001\u0004Y\u0018!B5oI\u0016D\b\u0002\u0003B\u001e\u0005_\u0001\r!!\"\u0002\rML8\u000f^3n\u0011\u001d\u0011y\u0004\u0001D\u0001\u0005\u0003\n\u0001c\u001d;beR$\u0016m]6NC:\fw-\u001a:\u0015\r\u0005-&1\tB#\u0011\u001d\u00119D!\u0010A\u0002mD\u0001Ba\u000f\u0003>\u0001\u0007\u0011Q\u0011\u0005\b\u0005\u0013\u0002A\u0011AA*\u0003Y9W\r\u001e(v[\n,'o\u00144K_\nl\u0015M\\1hKJ\u001c\bb\u0002B'\u0001\u0011\u0005!qJ\u0001\u0015O\u0016$(j\u001c2NC:\fw-\u001a:t\u0003NT\u0015M^1\u0016\u0005\tE\u0003C\u0002B*\u00053\nY+\u0004\u0002\u0003V)\u0019!q\u000b\n\u0002\tU$\u0018\u000e\\\u0005\u0005\u00057\u0012)F\u0001\u0003MSN$\bb\u0002B0\u0001\u0011\u0005!\u0011M\u0001\u0010O\u0016$H+Y:l\u001b\u0006t\u0017mZ3sgV\u0011\u0011\u0011\u0016\u0005\b\u0005K\u0002A\u0011\u0001B(\u0003U9W\r\u001e+bg.l\u0015M\\1hKJ\u001c\u0018i\u001d&bm\u0006DqA!\u001b\u0001\t\u0003\u0011Y'\u0001\fhKRdU-\u00193fe\u001e\u000bG/Z<bs\u001a+H/\u001e:f+\t\u0011i\u0007\u0005\u0003c\u0005_:\u0017b\u0001B9G\n1a)\u001e;ve\u0016DqA!\u001e\u0001\t\u0003\u00119(\u0001\thKRdU-\u00193fe\u001e\u000bG/Z<bsR\u0019qM!\u001f\t\u0011\u0005\u0015\"1\u000fa\u0001\u0003SAqA! \u0001\t\u0003\u0011y(\u0001\u000bhKRdU-\u00193fe&sG-\u001a=GkR,(/Z\u000b\u0003\u0005\u0003\u0003BA\u0019B8w\"9!Q\u0011\u0001\u0005\u0002\t\u001d\u0015AD4fi2+\u0017\rZ3s\u0013:$W\r\u001f\u000b\u0004w\n%\u0005\u0002CA\u0013\u0005\u0007\u0003\r!!\u000b\t\u000f\t5\u0005\u0001\"\u0001\u0003\u0010\u00069r-\u001a;K_\nl\u0015M\\1hKJ\f5n[1D_:4\u0017n\u001a\u000b\u0005\u0005#\u0013)\u000b\u0005\u0003\u0003\u0014\n\u0005VB\u0001BK\u0015\u0011\u00119J!'\u0002\r\r|gNZ5h\u0015\u0011\u0011YJ!(\u0002\u0011QL\b/Z:bM\u0016T!Aa(\u0002\u0007\r|W.\u0003\u0003\u0003$\nU%AB\"p]\u001aLw\rC\u0004\u00038\t-\u0005\u0019A>\t\u000f\t%\u0006\u0001\"\u0001\u0003,\u0006Ar-\u001a;UCN\\W*\u00198bO\u0016\u0014\u0018i[6b\u0007>tg-[4\u0015\t\tE%Q\u0016\u0005\b\u0005o\u00119\u000b1\u0001|\u0011\u001d\u0011\t\f\u0001C\u0001\u0005g\u000b!d\u001d;beRTuNY'b]\u0006<WM]!di>\u00148+_:uK6$B!!\"\u00036\"9!q\u0007BX\u0001\u0004Y\bb\u0002B]\u0001\u0011\u0005!1X\u0001\u001cgR\f'\u000f\u001e+bg.l\u0015M\\1hKJ\f5\r^8s'f\u001cH/Z7\u0015\t\u0005\u0015%Q\u0018\u0005\b\u0005o\u00119\f1\u0001|\u0011\u001d\u0011\t\r\u0001C\u0001\u0005\u0007\f\u0011d\u001d;beRTuNY\"mS\u0016tG/Q2u_J\u001c\u0016p\u001d;f[R!\u0011Q\u0011Bc\u0011!\u00119Ma0A\u0002\t%\u0017!\u00026pE&#\u0005\u0003\u0002Bf\u0005+l!A!4\u000b\t\t='\u0011[\u0001\u0007G>lWn\u001c8\u000b\u0007\tMg!A\u0002ba&LAAa6\u0003N\n)!j\u001c2J\t\"9!1\u001c\u0001\u0005\u0002\tu\u0017!B:uCJ$H#\u00019\t\u000f\tm\u0007\u0001\"\u0001\u0003bR\u0019\u0001Oa9\t\u000f\t\u0015(q\u001ca\u0001U\u0005qr/Y5u\r>\u0014H+Y:l\u001b\u0006t\u0017mZ3s%\u0016<\u0017n\u001d;sCRLwN\u001c\u0005\b\u0005S\u0004A\u0011\u0001Bv\u00039\u0019H/\u0019:u/\u0016\u00147+\u001a:wKJ$\u0002\"a1\u0003n\n=(1\u001f\u0005\b\u0005/\u00139\u000f1\u0001 \u0011!\u0011\tPa:A\u0002\u0005\u0015\u0015aC1di>\u00148+_:uK6D\u0001B!>\u0003h\u0002\u0007!q_\u0001\u0012U>\u0014W*\u00198bO\u0016\u0014\u0018i[6b+Jc\u0005\u0003\u0002B}\u0005\u007ft1a\u000bB~\u0013\r\u0011i\u0010L\u0001\u0007!J,G-\u001a4\n\u0007a\u001b\tAC\u0002\u0003~2Bqa!\u0002\u0001\t\u0003\u0011i.\u0001\u0003ti>\u0004\bbBB\u0005\u0001\u0011E!Q\\\u0001\tg\",H\u000fZ8x]\"91Q\u0002\u0001\u0005\u0002\tu\u0017\u0001E1xC&$H+\u001a:nS:\fG/[8o\u0011\u0019\u0019\t\u0002\u0001C\u0001S\u00059!/\u001e8oS:<\u0007bBB\u000b\u0001\u0011\u0005!Q\\\u0001\"o\u0006LGOR8s)\u0006\u001c8.T1oC\u001e,'o\u001d+p\u0005\u0016\u0014VmZ5ti\u0016\u0014X\r\u001a\u0015\u0007\u0007'\u0019Iba\u000e\u0011\u000b-\u001aYba\b\n\u0007\ruAF\u0001\u0004uQJ|wo\u001d\t\u0005\u0007C\u0019\u0019\u0003\u0004\u0001\u0005\u000f\r\u0015\u0002A1\u0001\u0004(\t\tA+\u0005\u0003\u0004*\r=\u0002cA\u0016\u0004,%\u00191Q\u0006\u0017\u0003\u000f9{G\u000f[5oOB!1\u0011GB\u001a\u001d\rY\u00131P\u0005\u0005\u0007k\t\u0019IA\u0005UQJ|w/\u00192mK\u000e\u00121\u0011\b\t\u0005\u0003_\u001aY$\u0003\u0003\u0004>\u0005\r%\u0001F%oi\u0016\u0014(/\u001e9uK\u0012,\u0005pY3qi&|g\u000e\u000b\u0004\u0004\u0014\r\u00053q\t\t\u0006W\rm11\t\t\u0005\u0007C\u0019)\u0005B\u0004\u0004&\u0001\u0011\raa\n$\u0005\r%\u0003\u0003BB&\u0007'rAa!\u0014\u0004R9!\u0011\u0011OB(\u0013\t!G&C\u0002\u0002~\rLAa!\u0016\u0004X\t\u0001B+[7f_V$X\t_2faRLwN\u001c\u0006\u0004\u0003{\u001a\u0007bBB\u000b\u0001\u0011\u000511\f\u000b\u0004a\u000eu\u0003\u0002CA\u0013\u00073\u0002\r!!\u000b)\r\re3\u0011MB\u001c!\u0015Y31DB2!\u0011\u0019\tc!\u001a\u0005\u000f\r\u0015\u0002A1\u0001\u0004(!21\u0011LB5\u0007\u000f\u0002RaKB\u000e\u0007W\u0002Ba!\t\u0004n\u001191Q\u0005\u0001C\u0002\r\u001d\u0002bBB9\u0001\u0011\u000511O\u0001\u0011gV\u0014W.\u001b;K_\n\fe\u000eZ,bSR$ba!\u001e\u0004|\r-\u0005\u0003\u0002Bf\u0007oJAa!\u001f\u0003N\n\u0011\"j\u001c2Fq\u0016\u001cW\u000f^5p]J+7/\u001e7u\u0011!\u0019iha\u001cA\u0002\r}\u0014\u0001\u00036pE\u001e\u0013\u0018\r\u001d5\u0011\t\r\u00055qQ\u0007\u0003\u0007\u0007S1a!\"\u0005\u0003!QwNY4sCBD\u0017\u0002BBE\u0007\u0007\u0013\u0001BS8c\u000fJ\f\u0007\u000f\u001b\u0005\b\u0007\u001b\u001by\u00071\u0001+\u00031\u0001(/\u001b8u+B$\u0017\r^3tQ\u0019\u0019yg!%\u0004\u0018B)1fa\u0007\u0004\u0014B!1\u0011EBK\t\u001d\u0019)\u0003\u0001b\u0001\u0007O\u0019#a!'\u0011\t\rm5\u0011U\u0007\u0003\u0007;S1aa(\u0005\u0003\u0019\u0019G.[3oi&!11UBO\u0005UQuNY#yK\u000e,H/[8o\u000bb\u001cW\r\u001d;j_:Dqa!\u001d\u0001\t\u0003\u00199\u000b\u0006\u0005\u0004v\r%61VBW\u0011!\u0019ih!*A\u0002\r}\u0004bBBG\u0007K\u0003\rA\u000b\u0005\t\u0003K\u0019)\u000b1\u0001\u0002*!91\u0011\u000f\u0001\u0005\u0002\rEFCCB;\u0007g\u001b)la.\u0004:\"A1QPBX\u0001\u0004\u0019y\bC\u0004\u0004\u000e\u000e=\u0006\u0019\u0001\u0016\t\u0011\u0005\u00152q\u0016a\u0001\u0003SA\u0001\"a@\u00040\u0002\u0007!Q\u0001\u0015\u0007\u0007_\u001bila&\u0011\u000b-\u001aYba0\u0011\t\r\u00052\u0011\u0019\u0003\b\u0007K\u0001!\u0019AB\u0014\u0011\u001d\u0019)\r\u0001C\u0001\u0007\u000f\f\u0011c];c[&$(j\u001c2EKR\f7\r[3e)\u0011\u0019Ima4\u0011\t\t-71Z\u0005\u0005\u0007\u001b\u0014iMA\nK_\n\u001cVOY7jgNLwN\u001c*fgVdG\u000f\u0003\u0005\u0004~\r\r\u0007\u0019AB@Q\u0019\u0019\u0019ma5\u0004\u0018B)1fa\u0007\u0004VB!1\u0011EBl\t\u001d\u0019)\u0003\u0001b\u0001\u0007OAqaa7\u0001\t\u0003\u0019i.\u0001\u000ftQV$Hm\\<o\u0015>\u00147\t\\5f]R\f5\r^8s'f\u001cH/Z7\u0015\u0007A\u001cy\u000e\u0003\u0005\u0003r\u000ee\u0007\u0019AAC\u0011\u001d\u0019\u0019\u000f\u0001C\t\u0007K\fAd\u0019:fCR,G*Z1eKJ\u0014V\r\u001e:jKZ\fGnU3sm&\u001cW\r\u0006\u0002\u0003\u0006!91\u0011\u001e\u0001\u0005\u0012\tu\u0017aC2mK\u0006\u0014H*Z1eKJDqa!<\u0001\t\u0003\u001ay/A\no_RLg-\u001f'fC\u0012,'/\u00113ee\u0016\u001c8\u000fF\u0003q\u0007c\u001c)\u0010\u0003\u0005\u0004t\u000e-\b\u0019\u0001B|\u0003\u001d\tG\r\u001a:fgND\u0001ba>\u0004l\u0002\u00071\u0011`\u0001\u0010Y\u0016\fG-\u001a:TKN\u001c\u0018n\u001c8J\tB!!1KB~\u0013\u0011\u0019iP!\u0016\u0003\tU+\u0016\n\u0012\u0005\b\t\u0003\u0001A\u0011\tC\u0002\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\u0007A$)\u0001\u0003\u0005\u0005\b\r}\b\u0019\u0001C\u0005\u0003%)\u0007pY3qi&|g\u000e\u0005\u0003\u0002p\u0011-\u0011\u0002\u0002C\u0007\u0003\u0007\u0013\u0011\"\u0012=dKB$\u0018n\u001c8")
public abstract class FlinkMiniCluster
implements LeaderRetrievalListener {
    private final Configuration userConfiguration;
    private final boolean useSingleActorSystem;
    private final StreamingMode streamingMode;
    private final Logger LOG;
    private final String hostname;
    private final Configuration configuration;
    private Promise<ActorGateway> leaderGateway;
    private Promise<Object> leaderIndex;
    private final Object futureLock;
    private final ExecutionContextExecutor executionContext;
    private final FiniteDuration timeout;
    private final RecoveryMode recoveryMode;
    private final int numJobManagers;
    private final int numTaskManagers;
    private Option<Seq<ActorSystem>> jobManagerActorSystems;
    private Option<Seq<ActorRef>> jobManagerActors;
    private Option<WebMonitor> webMonitor;
    private Option<Seq<ActorSystem>> taskManagerActorSystems;
    private Option<Seq<ActorRef>> taskManagerActors;
    private Option<LeaderRetrievalService> leaderRetrievalService;
    private boolean isRunning;

    public Configuration userConfiguration() {
        return this.userConfiguration;
    }

    public boolean useSingleActorSystem() {
        return this.useSingleActorSystem;
    }

    public StreamingMode streamingMode() {
        return this.streamingMode;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public String hostname() {
        return this.hostname;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Promise<ActorGateway> leaderGateway() {
        return this.leaderGateway;
    }

    public void leaderGateway_$eq(Promise<ActorGateway> x$1) {
        this.leaderGateway = x$1;
    }

    public Promise<Object> leaderIndex() {
        return this.leaderIndex;
    }

    public void leaderIndex_$eq(Promise<Object> x$1) {
        this.leaderIndex = x$1;
    }

    public Object futureLock() {
        return this.futureLock;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public RecoveryMode recoveryMode() {
        return this.recoveryMode;
    }

    public int numJobManagers() {
        return this.numJobManagers;
    }

    public int numTaskManagers() {
        return this.numTaskManagers;
    }

    public Option<Seq<ActorSystem>> jobManagerActorSystems() {
        return this.jobManagerActorSystems;
    }

    public void jobManagerActorSystems_$eq(Option<Seq<ActorSystem>> x$1) {
        this.jobManagerActorSystems = x$1;
    }

    public Option<Seq<ActorRef>> jobManagerActors() {
        return this.jobManagerActors;
    }

    public void jobManagerActors_$eq(Option<Seq<ActorRef>> x$1) {
        this.jobManagerActors = x$1;
    }

    public Option<WebMonitor> webMonitor() {
        return this.webMonitor;
    }

    public void webMonitor_$eq(Option<WebMonitor> x$1) {
        this.webMonitor = x$1;
    }

    public Option<Seq<ActorSystem>> taskManagerActorSystems() {
        return this.taskManagerActorSystems;
    }

    public void taskManagerActorSystems_$eq(Option<Seq<ActorSystem>> x$1) {
        this.taskManagerActorSystems = x$1;
    }

    public Option<Seq<ActorRef>> taskManagerActors() {
        return this.taskManagerActors;
    }

    public void taskManagerActors_$eq(Option<Seq<ActorRef>> x$1) {
        this.taskManagerActors = x$1;
    }

    public Option<LeaderRetrievalService> leaderRetrievalService() {
        return this.leaderRetrievalService;
    }

    public void leaderRetrievalService_$eq(Option<LeaderRetrievalService> x$1) {
        this.leaderRetrievalService = x$1;
    }

    private boolean isRunning() {
        return this.isRunning;
    }

    private void isRunning_$eq(boolean x$1) {
        this.isRunning = x$1;
    }

    public abstract Configuration generateConfiguration(Configuration var1);

    public abstract ActorRef startJobManager(int var1, ActorSystem var2);

    public abstract ActorRef startTaskManager(int var1, ActorSystem var2);

    public int getNumberOfJobManagers() {
        RecoveryMode recoveryMode = this.recoveryMode();
        RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
        return !(recoveryMode != null ? !((Object)((Object)recoveryMode)).equals((Object)recoveryMode2) : recoveryMode2 != null) ? 1 : this.configuration().getInteger("local.number-jobmanager", 1);
    }

    public List<ActorRef> getJobManagersAsJava() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.jobManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        })).asJava();
    }

    public Seq<ActorRef> getTaskManagers() {
        return (Seq)this.taskManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
    }

    public List<ActorRef> getTaskManagersAsJava() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.taskManagerActors().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        })).asJava();
    }

    public Future<ActorGateway> getLeaderGatewayFuture() {
        return this.leaderGateway().future();
    }

    public ActorGateway getLeaderGateway(FiniteDuration timeout) {
        Future<ActorGateway> jmFuture = this.getLeaderGatewayFuture();
        return (ActorGateway)Await$.MODULE$.result(jmFuture, (Duration)timeout);
    }

    public Future<Object> getLeaderIndexFuture() {
        return this.leaderIndex().future();
    }

    public int getLeaderIndex(FiniteDuration timeout) {
        Future<Object> indexFuture = this.getLeaderIndexFuture();
        return BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result(indexFuture, (Duration)timeout));
    }

    public Config getJobManagerAkkaConfig(int index) {
        Config config;
        if (this.useSingleActorSystem()) {
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)None$.MODULE$);
        } else {
            int port = this.configuration().getInteger("jobmanager.rpc.port", 6123);
            int resolvedPort = port != 0 ? port + index : port;
            config = AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)resolvedPort))));
        }
        return config;
    }

    public Config getTaskManagerAkkaConfig(int index) {
        int port = this.configuration().getInteger("taskmanager.rpc.port", 0);
        int resolvedPort = port != 0 ? port + index : port;
        return AkkaUtils$.MODULE$.getAkkaConfig(this.configuration(), (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)this.hostname(), (Object)BoxesRunTime.boxToInteger((int)resolvedPort))));
    }

    public ActorSystem startJobManagerActorSystem(int index) {
        Config config = this.getJobManagerAkkaConfig(index);
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    public ActorSystem startTaskManagerActorSystem(int index) {
        Config config = this.getTaskManagerAkkaConfig(index);
        return AkkaUtils$.MODULE$.createActorSystem(config);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ActorSystem startJobClientActorSystem(JobID jobID) {
        ActorSystem actorSystem;
        if (!this.useSingleActorSystem()) {
            actorSystem = JobClient.startJobClientActorSystem(this.configuration());
            return actorSystem;
        }
        Option<Seq<ActorSystem>> option = this.jobManagerActorSystems();
        if (option instanceof Some) {
            ActorSystem actorSystem2;
            Some some = (Some)option;
            Seq jmActorSystems = (Seq)some.x();
            actorSystem = actorSystem2 = (ActorSystem)jmActorSystems.apply(0);
            return actorSystem;
        }
        None$ none$ = None$.MODULE$;
        Option<Seq<ActorSystem>> option2 = option;
        if (none$ == null) {
            if (option2 == null) throw new JobExecutionException(jobID, "The FlinkMiniCluster has not been started yet.");
            throw new MatchError(option);
        }
        if (!none$.equals(option2)) throw new MatchError(option);
        throw new JobExecutionException(jobID, "The FlinkMiniCluster has not been started yet.");
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean waitForTaskManagerRegistration) {
        ObjectRef singleActorSystem$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        this.LOG().info("Starting FlinkMiniCluster.");
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numJobManagers()).map((Function1)new $anonfun$1(this, singleActorSystem$lzy, bitmap$0), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            IndexedSeq jmActorSystems = (IndexedSeq)tuple2._1();
            IndexedSeq jmActors = (IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)jmActorSystems, (Object)jmActors);
            IndexedSeq jmActorSystems2 = (IndexedSeq)tuple23._1();
            IndexedSeq jmActors2 = (IndexedSeq)tuple23._2();
            this.jobManagerActorSystems_$eq((Option<Seq<ActorSystem>>)new Some((Object)jmActorSystems2));
            this.jobManagerActors_$eq((Option<Seq<ActorRef>>)new Some((Object)jmActors2));
            LeaderRetrievalService lrs = this.createLeaderRetrievalService();
            this.leaderRetrievalService_$eq((Option<LeaderRetrievalService>)new Some((Object)lrs));
            lrs.start(this);
            Tuple2 tuple24 = ((GenericTraversableTemplate)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numTaskManagers()).map((Function1)new $anonfun$2(this, jmActorSystems2), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.conforms());
            if (tuple24 != null) {
                Tuple2 tuple25;
                IndexedSeq tmActorSystems = (IndexedSeq)tuple24._1();
                IndexedSeq tmActors = (IndexedSeq)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)tmActorSystems, (Object)tmActors);
                IndexedSeq tmActorSystems2 = (IndexedSeq)tuple26._1();
                IndexedSeq tmActors2 = (IndexedSeq)tuple26._2();
                this.taskManagerActorSystems_$eq((Option<Seq<ActorSystem>>)new Some((Object)tmActorSystems2));
                this.taskManagerActors_$eq((Option<Seq<ActorRef>>)new Some((Object)tmActors2));
                String jobManagerAkkaURL = AkkaUtils$.MODULE$.getAkkaURL((ActorSystem)jmActorSystems2.apply(0), (ActorRef)jmActors2.apply(0));
                this.webMonitor_$eq(this.startWebServer(this.configuration(), (ActorSystem)jmActorSystems2.apply(0), jobManagerAkkaURL));
                if (waitForTaskManagerRegistration) {
                    this.waitForTaskManagersToBeRegistered();
                }
                this.isRunning_$eq(true);
                return;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<WebMonitor> startWebServer(Configuration config, ActorSystem actorSystem, String jobManagerAkkaURL) {
        None$ none$;
        if (config.getBoolean("local.start-webserver", false) && config.getInteger("jobmanager.web.port", 0) >= 0) {
            StandaloneLeaderRetrievalService leaderRetrievalService = new StandaloneLeaderRetrievalService(jobManagerAkkaURL);
            this.LOG().info("Starting JobManger web frontend");
            WebMonitor webServer = WebMonitorUtils.startWebRuntimeMonitor(config, leaderRetrievalService, actorSystem);
            webServer.start(jobManagerAkkaURL);
            none$ = Option$.MODULE$.apply((Object)webServer);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void stop() {
        this.LOG().info("Stopping FlinkMiniCluster.");
        this.shutdown();
        this.awaitTermination();
        this.leaderRetrievalService().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LeaderRetrievalService x$3) {
                x$3.stop();
            }
        });
        this.isRunning_$eq(false);
    }

    public void shutdown() {
        this.webMonitor().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(WebMonitor x$4) {
                x$4.stop();
            }
        });
        Seq tmFutures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Seq<Future<Boolean>> apply(Seq<ActorRef> x$5) {
                return (Seq)x$5.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final Future<Boolean> apply(ActorRef x$6) {
                        return Patterns$.MODULE$.gracefulStop(x$6, this.$outer.org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer().timeout());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ FlinkMiniCluster org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Seq jmFutures = (Seq)this.jobManagerActors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FlinkMiniCluster $outer;

            public final Seq<Future<Boolean>> apply(Seq<ActorRef> x$7) {
                return (Seq)x$7.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final Future<Boolean> apply(ActorRef x$8) {
                        return Patterns$.MODULE$.gracefulStop(x$8, this.$outer.org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer().timeout());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ FlinkMiniCluster org$apache$flink$runtime$minicluster$FlinkMiniCluster$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        ExecutionContextExecutor executionContext = ExecutionContext$.MODULE$.global();
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)jmFutures.$plus$plus((GenTraversableOnce)tmFutures, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), (ExecutionContext)executionContext), (Duration)this.timeout());
        if (!this.useSingleActorSystem()) {
            this.taskManagerActorSystems().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Seq<ActorSystem> x$9) {
                    x$9.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(ActorSystem x$10) {
                            x$10.shutdown();
                        }
                    });
                }
            });
        }
        this.jobManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$11) {
                x$11.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$12) {
                        x$12.shutdown();
                    }
                });
            }
        });
    }

    public void awaitTermination() {
        this.jobManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$13) {
                x$13.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$14) {
                        x$14.awaitTermination();
                    }
                });
            }
        });
        this.taskManagerActorSystems().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<ActorSystem> x$15) {
                x$15.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ActorSystem x$16) {
                        x$16.awaitTermination();
                    }
                });
            }
        });
    }

    public boolean running() {
        return this.isRunning();
    }

    public void waitForTaskManagersToBeRegistered() throws TimeoutException, InterruptedException {
        this.waitForTaskManagersToBeRegistered(this.timeout());
    }

    public void waitForTaskManagersToBeRegistered(FiniteDuration timeout) throws TimeoutException, InterruptedException {
        Seq futures = (Seq)this.taskManagerActors().map((Function1)new Serializable(this, timeout){
            public static final long serialVersionUID = 0L;
            public final FiniteDuration timeout$1;

            public final Seq<Future<Object>> apply(Seq<ActorRef> x$17) {
                return (Seq)x$17.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final Future<Object> apply(ActorRef taskManager) {
                        return AskableActorRef$.MODULE$.$qmark$extension(package$.MODULE$.ask(taskManager), (Object)TaskManagerMessages$NotifyWhenRegisteredAtAnyJobManager$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.$outer.timeout$1));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.timeout$1 = timeout$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, Seq$.MODULE$.canBuildFrom(), (ExecutionContext)this.executionContext()), (Duration)timeout);
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates) throws JobExecutionException {
        return this.submitJobAndWait(jobGraph, printUpdates, this.timeout());
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates, FiniteDuration timeout) {
        return this.submitJobAndWait(jobGraph, printUpdates, timeout, this.createLeaderRetrievalService());
    }

    public JobExecutionResult submitJobAndWait(JobGraph jobGraph, boolean printUpdates, FiniteDuration timeout, LeaderRetrievalService leaderRetrievalService) throws JobExecutionException {
        ActorSystem clientActorSystem = this.startJobClientActorSystem(jobGraph.getJobID());
        try {
            return JobClient.submitJobAndWait(clientActorSystem, leaderRetrievalService, jobGraph, timeout, printUpdates, this.getClass().getClassLoader());
        }
        finally {
            if (!this.useSingleActorSystem()) {
                this.shutdownJobClientActorSystem(clientActorSystem);
            }
        }
    }

    public JobSubmissionResult submitJobDetached(JobGraph jobGraph) throws JobExecutionException {
        ActorGateway jobManagerGateway;
        try {
            jobManagerGateway = this.getLeaderGateway(this.timeout());
        }
        catch (Throwable throwable) {
            throw new JobExecutionException(jobGraph.getJobID(), "Could not retrieve JobManager ActorRef.", throwable);
        }
        JobClient.submitJobDetached(jobManagerGateway, jobGraph, this.timeout(), this.getClass().getClassLoader());
        return new JobSubmissionResult(jobGraph.getJobID());
    }

    public void shutdownJobClientActorSystem(ActorSystem actorSystem) {
        if (!this.useSingleActorSystem()) {
            actorSystem.shutdown();
        }
    }

    public LeaderRetrievalService createLeaderRetrievalService() {
        Tuple2 tuple2 = new Tuple2(this.jobManagerActorSystems(), this.jobManagerActors());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq jmActorSystems = (Seq)some.x();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Seq jmActors = (Seq)some2.x();
                    RecoveryMode recoveryMode = this.recoveryMode();
                    RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
                    LeaderRetrievalService leaderRetrievalService = !(recoveryMode != null ? !((Object)((Object)recoveryMode)).equals((Object)recoveryMode2) : recoveryMode2 != null) ? new StandaloneLeaderRetrievalService(AkkaUtils$.MODULE$.getAkkaURL((ActorSystem)jmActorSystems.apply(0), (ActorRef)jmActors.apply(0))) : ZooKeeperUtils.createLeaderRetrievalService(this.configuration());
                    return leaderRetrievalService;
                }
            }
        }
        throw new Exception("The FlinkMiniCluster has not been started properly.");
    }

    public void clearLeader() {
        Object object = this.futureLock();
        synchronized (object) {
            this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.apply());
            this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.apply());
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void notifyLeaderAddress(String address, UUID leaderSessionID) {
        if (address == null || address.equals("")) ** GOTO lbl38
        var3_3 = new Tuple2(this.jobManagerActorSystems(), this.jobManagerActors());
        if (var3_3 == null) ** GOTO lbl-1000
        var4_4 = (Option)var3_3._1();
        var5_5 = (Option)var3_3._2();
        if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
        var6_6 = (Some)var4_4;
        systems = (Seq)var6_6.x();
        if (var5_5 instanceof Some) {
            var8_8 = (Some)var5_5;
            actors = (Seq)var8_8.x();
            actorPaths = (Seq)((TraversableLike)((IterableLike)systems.zip((GenIterable)actors, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple3<String, ActorRef, Object> apply(Tuple2<Tuple2<ActorSystem, ActorRef>, Object> x0$1) {
                    Tuple2<Tuple2<ActorSystem, ActorRef>, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        if (tuple22 != null) {
                            ActorSystem system = (ActorSystem)tuple22._1();
                            ActorRef actor = (ActorRef)tuple22._2();
                            Tuple3 tuple3 = new Tuple3((Object)AkkaUtils$.MODULE$.getAkkaURL(system, actor), (Object)actor, (Object)BoxesRunTime.boxToInteger((int)index));
                            return tuple3;
                        }
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            var11_11 = actorPaths.find((Function1)new Serializable(this, address){
                public static final long serialVersionUID = 0L;
                private final String address$1;

                public final boolean apply(Tuple3<String, ActorRef, Object> x0$2) {
                    Tuple3<String, ActorRef, Object> tuple3 = x0$2;
                    if (tuple3 != null) {
                        String path = (String)tuple3._1();
                        boolean bl = path.equals(this.address$1);
                        return bl;
                    }
                    throw new MatchError(tuple3);
                }
                {
                    this.address$1 = address$1;
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<ActorRef, Object> apply(Tuple3<String, ActorRef, Object> x) {
                    return new Tuple2(x._2(), x._3());
                }
            });
        } else lbl-1000:
        // 3 sources

        {
            var11_11 = None$.MODULE$;
        }
        selectedLeader = var11_11;
        var13_13 = this.futureLock();
        synchronized (var13_13) {
            block11: {
                block10: {
                    block9: {
                        if (this.leaderGateway().isCompleted()) {
                            this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.apply());
                            this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.apply());
                        }
                        if (!((var14_14 = selectedLeader) instanceof Some) || (var16_16 = (Tuple2)(var15_15 = (Some)var14_14).x()) == null) break block9;
                        leader = (ActorRef)var16_16._1();
                        index = var16_16._2$mcI$sp();
                        this.leaderGateway().success((Object)new AkkaActorGateway(leader, leaderSessionID));
                        var19_19 = this.leaderIndex().success((Object)BoxesRunTime.boxToInteger((int)index));
                        break block10;
                    }
                    v0 = None$.MODULE$;
                    var20_20 = var14_14;
                    if (v0 != null ? v0.equals(var20_20) == false : var20_20 != null) break block11;
                    this.leaderGateway().failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find job manager with address ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address}))));
                    var19_19 = this.leaderIndex().failure((Throwable)new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find job manager index with address ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address}))));
                }
                return;
            }
            throw new MatchError((Object)var14_14);
        }
    }

    @Override
    public void handleError(Exception exception) {
        Object object = this.futureLock();
        synchronized (object) {
            Promise promise;
            if (this.leaderGateway().isCompleted()) {
                this.leaderGateway_$eq((Promise<ActorGateway>)Promise$.MODULE$.failed((Throwable)exception));
                this.leaderIndex_$eq((Promise<Object>)Promise$.MODULE$.failed((Throwable)exception));
                promise = BoxedUnit.UNIT;
            } else {
                this.leaderGateway().failure((Throwable)exception);
                promise = this.leaderIndex().failure((Throwable)exception);
            }
            return;
        }
    }

    private final ActorSystem singleActorSystem$lzycompute$1(ObjectRef singleActorSystem$lzy$1, VolatileByteRef bitmap$0$1) {
        FlinkMiniCluster flinkMiniCluster = this;
        synchronized (flinkMiniCluster) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                singleActorSystem$lzy$1.elem = this.startJobManagerActorSystem(0);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (ActorSystem)singleActorSystem$lzy$1.elem;
        }
    }

    public final ActorSystem org$apache$flink$runtime$minicluster$FlinkMiniCluster$$singleActorSystem$1(ObjectRef singleActorSystem$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.singleActorSystem$lzycompute$1(singleActorSystem$lzy$1, bitmap$0$1) : (ActorSystem)singleActorSystem$lzy$1.elem;
    }

    public FlinkMiniCluster(Configuration userConfiguration, boolean useSingleActorSystem, StreamingMode streamingMode) {
        this.userConfiguration = userConfiguration;
        this.useSingleActorSystem = useSingleActorSystem;
        this.streamingMode = streamingMode;
        this.LOG = LoggerFactory.getLogger(FlinkMiniCluster.class);
        this.hostname = userConfiguration.getString("jobmanager.rpc.address", InetAddress.getByName("localhost").getHostAddress());
        this.configuration = this.generateConfiguration(userConfiguration);
        this.leaderGateway = Promise$.MODULE$.apply();
        this.leaderIndex = Promise$.MODULE$.apply();
        this.futureLock = new Object();
        this.executionContext = ExecutionContext$.MODULE$.global();
        this.timeout = AkkaUtils$.MODULE$.getTimeout(userConfiguration);
        this.recoveryMode = RecoveryMode.fromConfig(this.configuration());
        this.numJobManagers = this.getNumberOfJobManagers();
        this.numTaskManagers = this.configuration().getInteger("local.number-taskmanager", 1);
        this.jobManagerActorSystems = None$.MODULE$;
        this.jobManagerActors = None$.MODULE$;
        this.webMonitor = None$.MODULE$;
        this.taskManagerActorSystems = None$.MODULE$;
        this.taskManagerActors = None$.MODULE$;
        this.leaderRetrievalService = None$.MODULE$;
        this.isRunning = false;
    }

    public FlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem) {
        this(userConfiguration, singleActorSystem, StreamingMode.BATCH_ONLY);
    }
}

