/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Props;
import akka.actor.Props$;
import com.typesafe.config.Config;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.ZooKeeperCheckpointRecoveryFactory;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.instance.InstanceManager;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManagerCliOptions;
import org.apache.flink.runtime.jobmanager.JobManagerMode;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.jobmanager.RecoveryMode;
import org.apache.flink.runtime.jobmanager.StandaloneSubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.webmonitor.WebMonitor;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.NetUtils;
import org.jboss.netty.channel.ChannelException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple11;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scopt.OptionParser;
import scopt.Read$;

public final class JobManager$ {
    public static final JobManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;
    private final String JOB_MANAGER_NAME;
    private final String ARCHIVE_NAME;

    static {
        new JobManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    public String JOB_MANAGER_NAME() {
        return this.JOB_MANAGER_NAME;
    }

    public String ARCHIVE_NAME() {
        return this.ARCHIVE_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        Tuple5 tuple5;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "JobManager", args);
        EnvironmentInformation.checkJavaVersion();
        Tuple5 tuple52 = this.liftedTree2$1(args);
        if (tuple52 == null) throw new MatchError((Object)tuple52);
        Configuration configuration = (Configuration)tuple52._1();
        JobManagerMode executionMode = (JobManagerMode)((Object)tuple52._2());
        StreamingMode streamingMode = (StreamingMode)((Object)tuple52._3());
        String listeningHost = (String)tuple52._4();
        int listeningPort = BoxesRunTime.unboxToInt((Object)tuple52._5());
        if (configuration == null) throw new MatchError((Object)tuple52);
        Configuration configuration2 = configuration;
        if (executionMode == null) throw new MatchError((Object)tuple52);
        JobManagerMode jobManagerMode = executionMode;
        if (streamingMode == null) throw new MatchError((Object)tuple52);
        StreamingMode streamingMode2 = streamingMode;
        if (listeningHost == null) throw new MatchError((Object)tuple52);
        String string = listeningHost;
        int n = listeningPort;
        Tuple5 tuple53 = tuple5 = new Tuple5((Object)configuration2, (Object)jobManagerMode, (Object)streamingMode2, (Object)string, (Object)BoxesRunTime.boxToInteger((int)n));
        Configuration configuration3 = (Configuration)tuple53._1();
        JobManagerMode executionMode2 = (JobManagerMode)((Object)tuple53._2());
        StreamingMode streamingMode3 = (StreamingMode)((Object)tuple53._3());
        String listeningHost2 = (String)tuple53._4();
        int listeningPort2 = BoxesRunTime.unboxToInt((Object)tuple53._5());
        if (listeningHost2 == null) {
            String message = "Config parameter 'jobmanager.rpc.address' is missing (hostname/address to bind JobManager to).";
            this.LOG().error((Function0)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
        if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration3)) {
            if (listeningPort2 != 0) {
                String message = "Config parameter 'jobmanager.rpc.port' is invalid, it must be equal to 0.";
                this.LOG().error((Function0)new Serializable(message){
                    public static final long serialVersionUID = 0L;
                    private final String message$2;

                    public final String apply() {
                        return this.message$2;
                    }
                    {
                        this.message$2 = message$2;
                    }
                });
                System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            }
        } else if (listeningPort2 <= 0 || listeningPort2 >= 65536) {
            String message = "Config parameter 'jobmanager.rpc.port' is invalid, it must be greater than 0 and less than 65536.";
            this.LOG().error((Function0)new Serializable(message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
        try {
            if (SecurityUtils.isSecurityEnabled()) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is enabled. Starting secure JobManager.";
                    }
                });
                SecurityUtils.runSecured(new SecurityUtils.FlinkSecuredRunner<BoxedUnit>(configuration3, executionMode2, streamingMode3, listeningHost2, listeningPort2){
                    private final Configuration configuration$1;
                    private final JobManagerMode executionMode$1;
                    private final StreamingMode streamingMode$1;
                    private final String listeningHost$1;
                    private final int listeningPort$1;

                    public void run() {
                        JobManager$.MODULE$.runJobManager(this.configuration$1, this.executionMode$1, this.streamingMode$1, this.listeningHost$1, this.listeningPort$1);
                    }
                    {
                        this.configuration$1 = configuration$1;
                        this.executionMode$1 = executionMode$1;
                        this.streamingMode$1 = streamingMode$1;
                        this.listeningHost$1 = listeningHost$1;
                        this.listeningPort$1 = listeningPort$1;
                    }
                });
                return;
            } else {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Security is not enabled. Starting non-authenticated JobManager.";
                    }
                });
                this.runJobManager(configuration3, executionMode2, streamingMode3, listeningHost2, listeningPort2);
            }
            return;
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run JobManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$10;

                public final Throwable apply() {
                    return this.t$10;
                }
                {
                    this.t$10 = t$10;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    public void runJobManager(Configuration configuration, JobManagerMode executionMode, StreamingMode streamingMode, String listeningAddress, int listeningPort) {
        Tuple4<ActorSystem, ActorRef, ActorRef, Option<WebMonitor>> tuple4 = this.startActorSystemAndJobManagerActors(configuration, executionMode, streamingMode, listeningAddress, listeningPort, JobManager.class, MemoryArchivist.class);
        if (tuple4 != null) {
            ActorSystem jobManagerSystem;
            ActorSystem actorSystem;
            ActorSystem jobManagerSystem2 = actorSystem = (jobManagerSystem = (ActorSystem)tuple4._1());
            jobManagerSystem2.awaitTermination();
            return;
        }
        throw new MatchError(tuple4);
    }

    public Tuple4<ActorSystem, ActorRef, ActorRef, Option<WebMonitor>> startActorSystemAndJobManagerActors(Configuration configuration, JobManagerMode executionMode, StreamingMode streamingMode, String listeningAddress, int listeningPort, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass) {
        None$ none$;
        Address address;
        ActorSystem jobManagerSystem;
        this.LOG().info((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting JobManager";
            }
        });
        String hostPortUrl = NetUtils.hostAndPortToUrlString((String)listeningAddress, (int)listeningPort);
        this.LOG().info((Function0)new Serializable(hostPortUrl){
            public static final long serialVersionUID = 0L;
            private final String hostPortUrl$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting JobManager actor system at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostPortUrl$1}));
            }
            {
                this.hostPortUrl$1 = hostPortUrl$1;
            }
        });
        try {
            Config akkaConfig = AkkaUtils$.MODULE$.getAkkaConfig(configuration, (Option<Tuple2<String, Object>>)new Some((Object)new Tuple2((Object)listeningAddress, (Object)BoxesRunTime.boxToInteger((int)listeningPort))));
            if (this.LOG().isDebugEnabled()) {
                this.LOG().debug((Function0)new Serializable(akkaConfig){
                    public static final long serialVersionUID = 0L;
                    private final Config akkaConfig$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Using akka configuration\n ").append((Object)this.akkaConfig$1).toString();
                    }
                    {
                        this.akkaConfig$1 = akkaConfig$1;
                    }
                });
            }
            jobManagerSystem = AkkaUtils$.MODULE$.createActorSystem(akkaConfig);
            address = AkkaUtils$.MODULE$.getAddress(jobManagerSystem);
        }
        catch (Throwable throwable) {
            Throwable cause;
            if (throwable instanceof ChannelException && (cause = throwable.getCause()) != null && throwable.getCause() instanceof BindException) {
                String address2 = new StringBuilder().append((Object)listeningAddress).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)listeningPort)).toString();
                throw new Exception(new StringBuilder().append((Object)"Unable to create JobManager at address ").append((Object)address2).append((Object)" - ").append((Object)cause.getMessage()).toString(), throwable);
            }
            throw new Exception("Could not create JobManager actor system", throwable);
        }
        configuration.setString("jobmanager.rpc.address", (String)address.host().get());
        configuration.setInteger("jobmanager.rpc.port", BoxesRunTime.unboxToInt((Object)address.port().get()));
        if (configuration.getInteger("jobmanager.web.port", 0) >= 0) {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManger web frontend";
                }
            });
            LeaderRetrievalService leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService(configuration);
            WebMonitor webServer = WebMonitorUtils.startWebRuntimeMonitor(configuration, leaderRetrievalService, jobManagerSystem);
            none$ = Option$.MODULE$.apply((Object)webServer);
        } else {
            none$ = None$.MODULE$;
        }
        None$ webMonitor = none$;
        webMonitor.foreach((Function1)new Serializable(configuration){
            public static final long serialVersionUID = 0L;
            private final Configuration configuration$2;

            public final void apply(WebMonitor monitor) {
                this.configuration$2.setInteger("jobmanager.web.port", monitor.getServerPort());
            }
            {
                this.configuration$2 = configuration$2;
            }
        });
        try {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManager actor";
                }
            });
            Tuple2<ActorRef, ActorRef> tuple2 = this.startJobManagerActors(configuration, jobManagerSystem, streamingMode, jobManagerClass, archiveClass);
            if (tuple2 != null) {
                BoxedUnit boxedUnit;
                Tuple2 tuple22;
                ActorRef jobManager = (ActorRef)tuple2._1();
                ActorRef archive = (ActorRef)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)jobManager, (Object)archive);
                ActorRef jobManager2 = (ActorRef)tuple23._1();
                ActorRef archive2 = (ActorRef)tuple23._2();
                this.LOG().debug((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting JobManager process reaper";
                    }
                });
                jobManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobManager2, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "JobManager_Process_Reaper");
                JobManagerMode jobManagerMode = executionMode;
                JobManagerMode jobManagerMode2 = JobManagerMode.LOCAL;
                if (!(jobManagerMode != null ? !((Object)((Object)jobManagerMode)).equals((Object)jobManagerMode2) : jobManagerMode2 != null)) {
                    this.LOG().info((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Starting embedded TaskManager for JobManager's LOCAL execution mode";
                        }
                    });
                    ActorRef taskManagerActor = TaskManager$.MODULE$.startTaskManagerComponentsAndActor(configuration, jobManagerSystem, listeningAddress, (Option<String>)new Some((Object)TaskManager$.MODULE$.TASK_MANAGER_NAME()), (Option<LeaderRetrievalService>)None$.MODULE$, true, streamingMode, TaskManager.class);
                    this.LOG().debug((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Starting TaskManager process reaper";
                        }
                    });
                    boxedUnit = jobManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerActor, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                webMonitor.foreach((Function1)new Serializable(configuration){
                    public static final long serialVersionUID = 0L;
                    private final Configuration configuration$2;

                    public final void apply(WebMonitor monitor) {
                        String jobManagerAkkaUrl = JobManager$.MODULE$.getRemoteJobManagerAkkaURL(this.configuration$2);
                        monitor.start(jobManagerAkkaUrl);
                    }
                    {
                        this.configuration$2 = configuration$2;
                    }
                });
                return new Tuple4((Object)jobManagerSystem, (Object)jobManager2, (Object)archive2, (Object)webMonitor);
            }
            throw new MatchError(tuple2);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while starting up JobManager";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final Throwable apply() {
                    return this.t$11;
                }
                {
                    this.t$11 = t$11;
                }
            });
            try {
                jobManagerSystem.shutdown();
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not cleanly shut down actor system";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable tt$2;

                    public final Throwable apply() {
                        return this.tt$2;
                    }
                    {
                        this.tt$2 = tt$2;
                    }
                });
            }
            throw throwable;
        }
    }

    public Tuple5<Configuration, JobManagerMode, StreamingMode, String, Object> parseArgs(String[] args) {
        int n;
        OptionParser<JobManagerCliOptions> parser = new OptionParser<JobManagerCliOptions>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink JobManager"}));
                this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                        conf.setConfigDir(arg);
                        return conf;
                    }
                }).text("The configuration directory.");
                this.opt("executionMode", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                        conf.setJobManagerMode(arg);
                        return conf;
                    }
                }).text("The execution mode of the JobManager (CLUSTER / LOCAL)");
                this.opt("streamingMode", Read$.MODULE$.stringRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                        conf.setStreamingMode(arg);
                        return conf;
                    }
                }).text("The streaming mode of the JobManager (STREAMING / BATCH)");
                this.opt("host", Read$.MODULE$.stringRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JobManagerCliOptions apply(String arg, JobManagerCliOptions conf) {
                        conf.setHost(arg);
                        return conf;
                    }
                }).text("Network address for communication with the job manager");
                this.opt("webui-port", Read$.MODULE$.intRead()).optional().action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JobManagerCliOptions apply(int arg, JobManagerCliOptions conf) {
                        conf.setWebUIPort(arg);
                        return conf;
                    }
                }).text("Port for the UI web server");
            }
        };
        JobManagerCliOptions config = (JobManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new JobManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
            public static final long serialVersionUID = 0L;
            private final String[] args$2;
            private final OptionParser parser$1;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line agruments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$2).mkString(" "), this.parser$1.usage()})));
            }
            {
                this.args$2 = args$2;
                this.parser$1 = parser$1;
            }
        });
        String configDir = config.getConfigDir();
        if (configDir == null) {
            throw new Exception("Missing parameter '--configDir'");
        }
        if (config.getJobManagerMode() == null) {
            throw new Exception("Missing parameter '--executionMode'");
        }
        this.LOG().info((Function0)new Serializable(configDir){
            public static final long serialVersionUID = 0L;
            private final String configDir$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.configDir$1).toString();
            }
            {
                this.configDir$1 = configDir$1;
            }
        });
        GlobalConfiguration.loadConfiguration((String)configDir);
        Configuration configuration = GlobalConfiguration.getConfiguration();
        if (new File(configDir).isDirectory()) {
            configuration.setString("flink.base.dir.path", new StringBuilder().append((Object)configDir).append((Object)"/..").toString());
        }
        if (config.getWebUIPort() >= 0) {
            configuration.setInteger("jobmanager.web.port", config.getWebUIPort());
        }
        if (config.getHost() != null) {
            configuration.setString("jobmanager.rpc.address", config.getHost());
        }
        String host = configuration.getString("jobmanager.rpc.address", null);
        if (ZooKeeperUtils.isZooKeeperRecoveryMode(configuration)) {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting JobManager in High-Availability Mode";
                }
            });
            configuration.setInteger("jobmanager.rpc.port", 0);
            n = 0;
        } else {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Staring JobManager without high-availability";
                }
            });
            n = configuration.getInteger("jobmanager.rpc.port", 6123);
        }
        int port = n;
        JobManagerMode executionMode = config.getJobManagerMode();
        StreamingMode streamingMode = config.getStreamingMode();
        String hostPortUrl = NetUtils.hostAndPortToUrlString((String)host, (int)port);
        this.LOG().info((Function0)new Serializable(executionMode, streamingMode, hostPortUrl){
            public static final long serialVersionUID = 0L;
            private final JobManagerMode executionMode$2;
            private final StreamingMode streamingMode$2;
            private final String hostPortUrl$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting JobManager on ", " with execution mode ", " and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostPortUrl$2, this.executionMode$2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"streaming mode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.streamingMode$2}))).toString();
            }
            {
                this.executionMode$2 = executionMode$2;
                this.streamingMode$2 = streamingMode$2;
                this.hostPortUrl$2 = hostPortUrl$2;
            }
        });
        return new Tuple5((Object)configuration, (Object)executionMode, (Object)streamingMode, (Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
    }

    /*
     * WARNING - void declaration
     */
    public Tuple11<ExecutionContext, InstanceManager, Scheduler, BlobLibraryCacheManager, Object, Object, FiniteDuration, Object, LeaderElectionService, SubmittedJobGraphStore, CheckpointRecoveryFactory> createJobManagerComponents(Configuration configuration, Option<LeaderElectionService> leaderElectionServiceOption) {
        RecoveryMode recoveryMode;
        block17: {
            Option<LeaderElectionService> option;
            block20: {
                Tuple3 tuple3;
                BlobLibraryCacheManager libraryCacheManager;
                Scheduler scheduler;
                InstanceManager instanceManager;
                ExecutionContextExecutor executionContext;
                long delayBetweenRetries;
                int archiveCount;
                int executionRetries;
                FiniteDuration timeout;
                block16: {
                    LeaderElectionService leaderElectionService;
                    CuratorFramework client;
                    block19: {
                        block18: {
                            LeaderElectionService les;
                            block12: {
                                Option<LeaderElectionService> option2;
                                block15: {
                                    LeaderElectionService leaderElectionService2;
                                    block14: {
                                        block13: {
                                            LeaderElectionService les2;
                                            timeout = AkkaUtils$.MODULE$.getTimeout(configuration);
                                            long cleanupInterval = configuration.getLong("library-cache-manager.cleanup.interval", 3600L) * 1000L;
                                            executionRetries = configuration.getInteger("execution-retries.default", 0);
                                            archiveCount = configuration.getInteger("jobmanager.web.history", 5);
                                            String pauseString = configuration.getString("akka.watch.heartbeat.pause", ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT);
                                            String delayString = configuration.getString("execution-retries.delay", pauseString);
                                            try {
                                                delayBetweenRetries = Duration$.MODULE$.apply(delayString).toMillis();
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                void var8_7;
                                                throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"execution-retries.delay"}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Value must be a valid duration (such as 100 milli or 1 min)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var8_7}))).toString());
                                            }
                                            executionContext = ExecutionContext$.MODULE$.fromExecutor((Executor)new ForkJoinPool());
                                            BlobServer blobServer = null;
                                            instanceManager = null;
                                            scheduler = null;
                                            libraryCacheManager = null;
                                            try {
                                                blobServer = new BlobServer(configuration);
                                                instanceManager = new InstanceManager();
                                                scheduler = new Scheduler((ExecutionContext)executionContext);
                                                libraryCacheManager = new BlobLibraryCacheManager(blobServer, cleanupInterval);
                                                instanceManager.addInstanceListener(scheduler);
                                            }
                                            catch (Throwable throwable) {
                                                void var13_11;
                                                void var14_12;
                                                void var15_13;
                                                void var16_14;
                                                if (var16_14 != null) {
                                                    var16_14.shutdown();
                                                }
                                                if (var15_13 != null) {
                                                    var15_13.shutdown();
                                                }
                                                if (var14_12 != null) {
                                                    var14_12.shutdown();
                                                }
                                                if (var13_11 != null) {
                                                    var13_11.shutdown();
                                                }
                                                throw throwable;
                                            }
                                            recoveryMode = RecoveryMode.fromConfig(configuration);
                                            RecoveryMode recoveryMode2 = RecoveryMode.STANDALONE;
                                            RecoveryMode recoveryMode3 = recoveryMode;
                                            if (recoveryMode2 != null ? !((Object)((Object)recoveryMode2)).equals((Object)recoveryMode3) : recoveryMode3 != null) break block12;
                                            option2 = leaderElectionServiceOption;
                                            if (!(option2 instanceof Some)) break block13;
                                            Some some = (Some)option2;
                                            leaderElectionService2 = les2 = (LeaderElectionService)some.x();
                                            break block14;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option<LeaderElectionService> option3 = option2;
                                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block15;
                                        leaderElectionService2 = new StandaloneLeaderElectionService();
                                    }
                                    LeaderElectionService leaderElectionService3 = leaderElectionService2;
                                    tuple3 = new Tuple3((Object)leaderElectionService3, (Object)new StandaloneSubmittedJobGraphStore(), (Object)new StandaloneCheckpointRecoveryFactory());
                                    break block16;
                                }
                                throw new MatchError(option2);
                            }
                            RecoveryMode recoveryMode4 = RecoveryMode.ZOOKEEPER;
                            RecoveryMode recoveryMode5 = recoveryMode;
                            if (recoveryMode4 != null ? !((Object)((Object)recoveryMode4)).equals((Object)recoveryMode5) : recoveryMode5 != null) break block17;
                            client = ZooKeeperUtils.startCuratorFramework(configuration);
                            option = leaderElectionServiceOption;
                            if (!(option instanceof Some)) break block18;
                            Some some = (Some)option;
                            leaderElectionService = les = (LeaderElectionService)some.x();
                            break block19;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<LeaderElectionService> option4 = option;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block20;
                        leaderElectionService = ZooKeeperUtils.createLeaderElectionService(client, configuration);
                    }
                    LeaderElectionService leaderElectionService4 = leaderElectionService;
                    tuple3 = new Tuple3((Object)leaderElectionService4, (Object)ZooKeeperUtils.createSubmittedJobGraphs(client, configuration), (Object)new ZooKeeperCheckpointRecoveryFactory(client, configuration));
                }
                Tuple3 tuple32 = tuple3;
                if (tuple32 != null) {
                    Tuple3 tuple33;
                    LeaderElectionService leaderElectionService = (LeaderElectionService)tuple32._1();
                    SubmittedJobGraphStore submittedJobGraphs = (SubmittedJobGraphStore)tuple32._2();
                    CheckpointRecoveryFactory checkpointRecoveryFactory = (CheckpointRecoveryFactory)tuple32._3();
                    Tuple3 tuple34 = tuple33 = new Tuple3((Object)leaderElectionService, (Object)submittedJobGraphs, (Object)checkpointRecoveryFactory);
                    LeaderElectionService leaderElectionService5 = (LeaderElectionService)tuple34._1();
                    SubmittedJobGraphStore submittedJobGraphs2 = (SubmittedJobGraphStore)tuple34._2();
                    CheckpointRecoveryFactory checkpointRecoveryFactory2 = (CheckpointRecoveryFactory)tuple34._3();
                    return new Tuple11((Object)executionContext, (Object)instanceManager, (Object)scheduler, (Object)libraryCacheManager, (Object)BoxesRunTime.boxToInteger((int)executionRetries), (Object)BoxesRunTime.boxToLong((long)delayBetweenRetries), (Object)timeout, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)leaderElectionService5, (Object)submittedJobGraphs2, (Object)checkpointRecoveryFactory2);
                }
                throw new MatchError((Object)tuple32);
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)recoveryMode);
    }

    public Tuple2<ActorRef, ActorRef> startJobManagerActors(Configuration configuration, ActorSystem actorSystem, StreamingMode streamingMode, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass) {
        return this.startJobManagerActors(configuration, actorSystem, (Option<String>)new Some((Object)this.JOB_MANAGER_NAME()), (Option<String>)new Some((Object)this.ARCHIVE_NAME()), streamingMode, jobManagerClass, archiveClass);
    }

    public Tuple2<ActorRef, ActorRef> startJobManagerActors(Configuration configuration, ActorSystem actorSystem, Option<String> jobMangerActorName, Option<String> archiveActorName, StreamingMode streamingMode, Class<? extends JobManager> jobManagerClass, Class<? extends MemoryArchivist> archiveClass) {
        Tuple11<ExecutionContext, InstanceManager, Scheduler, BlobLibraryCacheManager, Object, Object, FiniteDuration, Object, LeaderElectionService, SubmittedJobGraphStore, CheckpointRecoveryFactory> tuple11;
        block2: {
            Option<String> option;
            block5: {
                Option<String> option2;
                block8: {
                    ActorRef actorRef;
                    ActorRef archive;
                    block7: {
                        Props jobManagerProps;
                        block6: {
                            ActorRef actorRef2;
                            CheckpointRecoveryFactory checkpointRecoveryFactory;
                            SubmittedJobGraphStore submittedJobGraphs;
                            LeaderElectionService leaderElectionService;
                            FiniteDuration timeout;
                            long delayBetweenRetries;
                            int executionRetries;
                            BlobLibraryCacheManager libraryCacheManager;
                            Scheduler scheduler;
                            InstanceManager instanceManager;
                            ExecutionContext executionContext;
                            block4: {
                                Props archiveProps;
                                block3: {
                                    Tuple11 tuple112;
                                    tuple11 = this.createJobManagerComponents(configuration, (Option<LeaderElectionService>)None$.MODULE$);
                                    if (tuple11 == null) break block2;
                                    ExecutionContext executionContext2 = (ExecutionContext)tuple11._1();
                                    InstanceManager instanceManager2 = (InstanceManager)tuple11._2();
                                    Scheduler scheduler2 = (Scheduler)tuple11._3();
                                    BlobLibraryCacheManager libraryCacheManager2 = (BlobLibraryCacheManager)tuple11._4();
                                    int executionRetries2 = BoxesRunTime.unboxToInt((Object)tuple11._5());
                                    long delayBetweenRetries2 = BoxesRunTime.unboxToLong((Object)tuple11._6());
                                    FiniteDuration timeout2 = (FiniteDuration)tuple11._7();
                                    int archiveCount = BoxesRunTime.unboxToInt((Object)tuple11._8());
                                    LeaderElectionService leaderElectionService2 = (LeaderElectionService)tuple11._9();
                                    SubmittedJobGraphStore submittedJobGraphs2 = (SubmittedJobGraphStore)tuple11._10();
                                    CheckpointRecoveryFactory checkpointRecoveryFactory2 = (CheckpointRecoveryFactory)tuple11._11();
                                    Tuple11 tuple113 = tuple112 = new Tuple11((Object)executionContext2, (Object)instanceManager2, (Object)scheduler2, (Object)libraryCacheManager2, (Object)BoxesRunTime.boxToInteger((int)executionRetries2), (Object)BoxesRunTime.boxToLong((long)delayBetweenRetries2), (Object)timeout2, (Object)BoxesRunTime.boxToInteger((int)archiveCount), (Object)leaderElectionService2, (Object)submittedJobGraphs2, (Object)checkpointRecoveryFactory2);
                                    executionContext = (ExecutionContext)tuple113._1();
                                    instanceManager = (InstanceManager)tuple113._2();
                                    scheduler = (Scheduler)tuple113._3();
                                    libraryCacheManager = (BlobLibraryCacheManager)tuple113._4();
                                    executionRetries = BoxesRunTime.unboxToInt((Object)tuple113._5());
                                    delayBetweenRetries = BoxesRunTime.unboxToLong((Object)tuple113._6());
                                    timeout = (FiniteDuration)tuple113._7();
                                    int archiveCount2 = BoxesRunTime.unboxToInt((Object)tuple113._8());
                                    leaderElectionService = (LeaderElectionService)tuple113._9();
                                    submittedJobGraphs = (SubmittedJobGraphStore)tuple113._10();
                                    checkpointRecoveryFactory = (CheckpointRecoveryFactory)tuple113._11();
                                    archiveProps = Props$.MODULE$.apply(archiveClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archiveCount2)}));
                                    option = archiveActorName;
                                    if (!(option instanceof Some)) break block3;
                                    Some some = (Some)option;
                                    String actorName = (String)some.x();
                                    actorRef2 = actorSystem.actorOf(archiveProps, actorName);
                                    break block4;
                                }
                                None$ none$ = None$.MODULE$;
                                Option<String> option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                                actorRef2 = actorSystem.actorOf(archiveProps);
                            }
                            archive = actorRef2;
                            jobManagerProps = Props$.MODULE$.apply(jobManagerClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configuration, executionContext, instanceManager, scheduler, libraryCacheManager, archive, BoxesRunTime.boxToInteger((int)executionRetries), BoxesRunTime.boxToLong((long)delayBetweenRetries), timeout, streamingMode, leaderElectionService, submittedJobGraphs, checkpointRecoveryFactory}));
                            option2 = jobMangerActorName;
                            if (!(option2 instanceof Some)) break block6;
                            Some some = (Some)option2;
                            String actorName = (String)some.x();
                            actorRef = actorSystem.actorOf(jobManagerProps, actorName);
                            break block7;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<String> option4 = option2;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block8;
                        actorRef = actorSystem.actorOf(jobManagerProps);
                    }
                    ActorRef jobManager = actorRef;
                    return new Tuple2((Object)jobManager, (Object)archive);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        throw new MatchError(tuple11);
    }

    public ActorRef startActor(Props props, ActorSystem actorSystem) {
        return actorSystem.actorOf(props, this.JOB_MANAGER_NAME());
    }

    public String getRemoteJobManagerAkkaURL(InetSocketAddress address, Option<String> name) {
        String hostPort = NetUtils.socketAddressToUrlString((InetSocketAddress)address);
        return this.getJobManagerAkkaURLHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.tcp://flink@", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostPort})), name);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getRemoteJobManagerAkkaURL(Configuration config) {
        Tuple2 tuple22;
        Tuple2<String, Object> tuple2 = TaskManager$.MODULE$.getAndCheckJobManagerAddress(config);
        if (tuple2 == null) throw new MatchError(tuple2);
        String hostname = (String)tuple2._1();
        int port = tuple2._2$mcI$sp();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)hostname, (Object)BoxesRunTime.boxToInteger((int)port));
        String hostname2 = (String)tuple23._1();
        int port2 = tuple23._2$mcI$sp();
        InetSocketAddress hostPort = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname2);
            hostPort = new InetSocketAddress(inetAddress, port2);
            return this.getRemoteJobManagerAkkaURL(hostPort, (Option<String>)Option$.MODULE$.empty());
        }
        catch (UnknownHostException unknownHostException) {
            void var7_7;
            throw new UnknownHostException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot resolve the JobManager hostname '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"specified in the configuration"})).s((Seq)Nil$.MODULE$)).toString());
        }
    }

    public Option<String> getRemoteJobManagerAkkaURL$default$2() {
        return None$.MODULE$;
    }

    public String getLocalJobManagerAkkaURL(Option<String> name) {
        return this.getJobManagerAkkaURLHelper("akka://flink", name);
    }

    public Option<String> getLocalJobManagerAkkaURL$default$1() {
        return None$.MODULE$;
    }

    public String getJobManagerAkkaURL(ActorSystem system, Option<String> name) {
        return this.getJobManagerAkkaURLHelper(AkkaUtils$.MODULE$.getAddress(system).toString(), name);
    }

    public Option<String> getJobManagerAkkaURL$default$2() {
        return None$.MODULE$;
    }

    private String getJobManagerAkkaURLHelper(String address, Option<String> name) {
        return new StringBuilder().append((Object)address).append((Object)"/user/").append(name.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return JobManager$.MODULE$.JOB_MANAGER_NAME();
            }
        })).toString();
    }

    public Future<ActorRef> getJobManagerActorRefFuture(InetSocketAddress address, ActorSystem system, FiniteDuration timeout) {
        return AkkaUtils$.MODULE$.getActorRefFuture(this.getRemoteJobManagerAkkaURL(address, this.getRemoteJobManagerAkkaURL$default$2()), system, timeout);
    }

    public ActorRef getJobManagerActorRef(String jobManagerUrl, ActorSystem system, FiniteDuration timeout) throws IOException {
        return AkkaUtils$.MODULE$.getActorRef(jobManagerUrl, system, timeout);
    }

    public ActorRef getJobManagerActorRef(InetSocketAddress address, ActorSystem system, FiniteDuration timeout) throws IOException {
        String jmAddress = this.getRemoteJobManagerAkkaURL(address, this.getRemoteJobManagerAkkaURL$default$2());
        return this.getJobManagerActorRef(jmAddress, system, timeout);
    }

    public ActorRef getJobManagerActorRef(InetSocketAddress address, ActorSystem system, Configuration config) throws IOException {
        FiniteDuration timeout = AkkaUtils$.MODULE$.getLookupTimeout(config);
        return this.getJobManagerActorRef(address, system, timeout);
    }

    private final Tuple5 liftedTree2$1(String[] args$1) {
        Tuple5<Configuration, JobManagerMode, StreamingMode, String, Object> tuple5;
        try {
            tuple5 = this.parseArgs(args$1);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$9;

                public final String apply() {
                    return this.t$9.getMessage();
                }
                {
                    this.t$9 = t$9;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$9;

                public final Throwable apply() {
                    return this.t$9;
                }
                {
                    this.t$9 = t$9;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            tuple5 = null;
        }
        return tuple5;
    }

    private JobManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(JobManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
        this.JOB_MANAGER_NAME = "jobmanager";
        this.ARCHIVE_NAME = "archive";
    }
}

