/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class ResultPartitionDeploymentDescriptor
implements Serializable {
    private final IntermediateDataSetID resultId;
    private final IntermediateResultPartitionID partitionId;
    private final ResultPartitionType partitionType;
    private final int numberOfSubpartitions;

    public ResultPartitionDeploymentDescriptor(IntermediateDataSetID resultId, IntermediateResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions) {
        this.resultId = Preconditions.checkNotNull(resultId);
        this.partitionId = Preconditions.checkNotNull(partitionId);
        this.partitionType = Preconditions.checkNotNull(partitionType);
        Preconditions.checkArgument(numberOfSubpartitions >= 1);
        this.numberOfSubpartitions = numberOfSubpartitions;
    }

    public IntermediateDataSetID getResultId() {
        return this.resultId;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    public int getNumberOfSubpartitions() {
        return this.numberOfSubpartitions;
    }

    public String toString() {
        return String.format("ResultPartitionDeploymentDescriptor [result id: %s, partition id: %s, partition type: %s]", new Object[]{this.resultId, this.partitionId, this.partitionType});
    }

    public static ResultPartitionDeploymentDescriptor from(IntermediateResultPartition partition) {
        IntermediateDataSetID resultId = partition.getIntermediateResult().getId();
        IntermediateResultPartitionID partitionId = partition.getPartitionId();
        ResultPartitionType partitionType = partition.getIntermediateResult().getResultType();
        int numberOfSubpartitions = 1;
        if (!partition.getConsumers().isEmpty() && !partition.getConsumers().get(0).isEmpty()) {
            if (partition.getConsumers().size() > 1) {
                new IllegalStateException("Currently, only a single consumer group per partition is supported.");
            }
            numberOfSubpartitions = partition.getConsumers().get(0).size();
        }
        return new ResultPartitionDeploymentDescriptor(resultId, partitionId, partitionType, numberOfSubpartitions);
    }
}

