/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.junit.Assert;
import org.junit.Test;

public class DelegatingConfigurationTest {
    @Test
    public void testIfDelegatesImplementAllMethods() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Comparator<Method> methodComparator = new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                String o1Str = o1.getName() + this.typeParamToString(o1.getParameterTypes());
                String o2Str = o2.getName() + this.typeParamToString(o2.getParameterTypes());
                return o1Str.compareTo(o2Str);
            }

            private String typeParamToString(Class<?>[] classes) {
                String str = "";
                for (Class<?> t : classes) {
                    str = str + ((Object)t).toString();
                }
                return str;
            }
        };
        Method[] confMethods = Configuration.class.getDeclaredMethods();
        Method[] delegateMethods = TaskConfig.DelegatingConfiguration.class.getDeclaredMethods();
        Arrays.sort(confMethods, methodComparator);
        Arrays.sort(delegateMethods, methodComparator);
        block0: for (Method configurationMethod : confMethods) {
            boolean hasMethod = false;
            if (!Modifier.isPublic(configurationMethod.getModifiers())) continue;
            block1: for (Method wrapperMethod : delegateMethods) {
                Class<?>[] configMethodParams;
                if (!configurationMethod.getName().equals(wrapperMethod.getName())) continue;
                Class<?>[] wrapperMethodParams = wrapperMethod.getParameterTypes();
                if (wrapperMethodParams.length != (configMethodParams = configurationMethod.getParameterTypes()).length) {
                    System.err.println("Length");
                    break;
                }
                for (int i = 0; i < wrapperMethodParams.length; ++i) {
                    if (wrapperMethodParams[i] != configMethodParams[i]) break block1;
                }
                hasMethod = true;
                break block0;
            }
            Assert.assertTrue((String)("Foo method '" + configurationMethod.getName() + "' has not been wrapped correctly in DelegatingConfiguration wrapper"), (boolean)hasMethod);
        }
    }
}

