/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.InputViewDataInputStreamWrapper;
import org.apache.flink.core.memory.OutputViewDataOutputStreamWrapper;
import org.junit.Assert;

public final class ManagementTestUtils {
    private static final String USER_DIR_KEY = "user.dir";
    private static final String ECLIPSE_PATH_EXTENSION = "/src/test/resources";

    private ManagementTestUtils() {
    }

    public static IOReadableWritable createCopy(IOReadableWritable original) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            original.write((DataOutputView)new OutputViewDataOutputStreamWrapper(dos));
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
        }
        String className = original.getClass().getName();
        if (className == null) {
            Assert.fail((String)"Class name is null");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        if (clazz == null) {
            Assert.fail((String)("Cannot find class with name " + className));
        }
        IOReadableWritable copy = null;
        try {
            copy = (IOReadableWritable)clazz.newInstance();
        }
        catch (InstantiationException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)e.getMessage());
        }
        if (copy == null) {
            Assert.fail((String)("Copy of object of type " + className + " is null"));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        try {
            copy.read((DataInputView)new InputViewDataInputStreamWrapper(dis));
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        return copy;
    }

    public static File locateResource(String resourceName) {
        File file = new File(System.getProperty(USER_DIR_KEY) + File.separator + resourceName);
        if (file.exists()) {
            return file;
        }
        file = new File(System.getProperty(USER_DIR_KEY) + ECLIPSE_PATH_EXTENSION + File.separator + resourceName);
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

