/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testingUtils;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Kill$;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.StreamingMode;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.messages.TaskManagerMessages;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.testingUtils.TestingCluster;
import org.apache.flink.runtime.testingUtils.TestingTaskManager;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.shaded.com.google.common.util.concurrent.MoreExecutors;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;

public final class TestingUtils$ {
    public static final TestingUtils$ MODULE$;
    private final Config testConfig;
    private final FiniteDuration TESTING_DURATION;
    private final String DEFAULT_AKKA_ASK_TIMEOUT;

    static {
        new TestingUtils$();
    }

    public Config testConfig() {
        return this.testConfig;
    }

    public FiniteDuration TESTING_DURATION() {
        return this.TESTING_DURATION;
    }

    public String DEFAULT_AKKA_ASK_TIMEOUT() {
        return this.DEFAULT_AKKA_ASK_TIMEOUT;
    }

    public String getDefaultTestingActorSystemConfigString() {
        String logLevel = AkkaUtils$.MODULE$.getLogLevel();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.daemonic = on\n      |akka.test.timefactor = 10\n      |akka.loggers = [\"akka.event.slf4j.Slf4jLogger\"]\n      |akka.loglevel = ", "\n      |akka.stdout-loglevel = OFF\n      |akka.jvm-exit-on-fatal-error = off\n      |akka.log-config-on-start = off\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logLevel})))).stripMargin();
    }

    public Config getDefaultTestingActorSystemConfig() {
        return this.testConfig();
    }

    public TestingCluster startTestingCluster(int numSlots, int numTMs, String timeout) {
        Configuration config = new Configuration();
        config.setInteger("taskmanager.numberOfTaskSlots", numSlots);
        config.setInteger("local.number-taskmanager", numTMs);
        config.setString("akka.ask.timeout", timeout);
        TestingCluster cluster = new TestingCluster(config);
        cluster.start();
        return cluster;
    }

    public int startTestingCluster$default$2() {
        return 1;
    }

    public String startTestingCluster$default$3() {
        return this.DEFAULT_AKKA_ASK_TIMEOUT();
    }

    public ExecutionContextExecutor defaultExecutionContext() {
        return ExecutionContext$.MODULE$.global();
    }

    public ExecutionContextExecutor directExecutionContext() {
        return ExecutionContext$.MODULE$.fromExecutor(MoreExecutors.directExecutor());
    }

    public TestingUtils.QueuedActionExecutionContext queuedActionExecutionContext() {
        return new TestingUtils.QueuedActionExecutionContext(new TestingUtils.ActionQueue());
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, ActorRef jobManager, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration) {
        String jobManagerURL = AkkaUtils$.MODULE$.getAkkaURL(actorSystem, jobManager);
        return this.createTaskManager(actorSystem, jobManagerURL, configuration, useLocalCommunication, waitForRegistration);
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, ActorGateway jobManager, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration) {
        String jobManagerURL = AkkaUtils$.MODULE$.getAkkaURL(actorSystem, jobManager.actor());
        return this.createTaskManager(actorSystem, jobManagerURL, configuration, useLocalCommunication, waitForRegistration);
    }

    public ActorGateway createTaskManager(ActorSystem actorSystem, String jobManagerURL, Configuration configuration, boolean useLocalCommunication, boolean waitForRegistration) {
        BoxedUnit boxedUnit;
        Configuration resultingConfiguration = new Configuration();
        resultingConfiguration.setInteger("taskmanager.memory.size", 10);
        resultingConfiguration.addAll(configuration);
        Option leaderRetrievalService = Option$.MODULE$.apply((Object)new StandaloneLeaderRetrievalService(jobManagerURL));
        ActorRef taskManager = TaskManager$.MODULE$.startTaskManagerComponentsAndActor(resultingConfiguration, actorSystem, "localhost", (Option)None$.MODULE$, leaderRetrievalService, useLocalCommunication, StreamingMode.BATCH_ONLY, TestingTaskManager.class);
        if (waitForRegistration) {
            Future notificationResult = AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(taskManager), (Object)TaskManagerMessages.NotifyWhenRegisteredAtAnyJobManager$.MODULE$, Timeout$.MODULE$.durationToTimeout(this.TESTING_DURATION()));
            boxedUnit = Await$.MODULE$.ready((Awaitable)notificationResult, (Duration)this.TESTING_DURATION());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new AkkaActorGateway(taskManager, null);
    }

    public void stopActor(ActorRef actor) {
        if (actor != null) {
            ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(actor);
            Kill$ x$1 = Kill$.MODULE$;
            ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
            qual$1.$bang((Object)x$1, x$2);
        }
    }

    public void stopActor(ActorGateway actorGateway) {
        if (actorGateway != null) {
            this.stopActor(actorGateway.actor());
        }
    }

    public ActorGateway createJobManager(ActorSystem actorSystem, Configuration configuration) {
        configuration.setString("recovery.mode", ConfigConstants.DEFAULT_RECOVERY_MODE);
        Tuple2 tuple2 = JobManager$.MODULE$.startJobManagerActors(configuration, actorSystem, (Option)new Some((Object)JobManager$.MODULE$.JOB_MANAGER_NAME()), (Option)new Some((Object)JobManager$.MODULE$.ARCHIVE_NAME()), StreamingMode.BATCH_ONLY, JobManager.class, MemoryArchivist.class);
        if (tuple2 != null) {
            ActorRef actor;
            ActorRef actorRef;
            ActorRef actor2 = actorRef = (actor = (ActorRef)tuple2._1());
            return new AkkaActorGateway(actor2, null);
        }
        throw new MatchError((Object)tuple2);
    }

    public ActorGateway createForwardingJobManager(ActorSystem actorSystem, ActorRef forwardingTarget, Option<String> jobManagerName) {
        Option<String> option;
        block4: {
            ActorRef actorRef;
            block3: {
                block2: {
                    option = jobManagerName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String name = (String)some.x();
                    actorRef = actorSystem.actorOf(Props$.MODULE$.apply(TestingUtils.ForwardingActor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{forwardingTarget, None$.MODULE$})), name);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<String> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                actorRef = actorSystem.actorOf(Props$.MODULE$.apply(TestingUtils.ForwardingActor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{forwardingTarget, None$.MODULE$})));
            }
            ActorRef actor = actorRef;
            return new AkkaActorGateway(actor, null);
        }
        throw new MatchError(option);
    }

    public Option<String> createForwardingJobManager$default$3() {
        return None$.MODULE$;
    }

    private TestingUtils$() {
        MODULE$ = this;
        this.testConfig = ConfigFactory.parseString((String)this.getDefaultTestingActorSystemConfigString());
        this.TESTING_DURATION = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minute();
        this.DEFAULT_AKKA_ASK_TIMEOUT = "200 s";
    }
}

