/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.IntValueSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.ValueSerializer;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.MemHeapKvState;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class MemoryStateBackendTest {
    @Test
    public void testSerializableState() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend();
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            StateHandle handle = backend.checkpointStateSerializable(state, 12L, 459L);
            Assert.assertNotNull((Object)handle);
            HashMap restored = (HashMap)handle.getState(this.getClass().getClassLoader());
            Assert.assertEquals(state, (Object)restored);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOversizedState() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend(10);
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            try {
                backend.checkpointStateSerializable(state, 12L, 459L);
                Assert.fail((String)"this should cause an exception");
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStateStream() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend();
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            StateBackend.CheckpointStateOutputStream os = backend.createCheckpointStateOutputStream(1L, 2L);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)os);
            oos.writeObject(state);
            oos.flush();
            StreamStateHandle handle = os.closeAndGetHandle();
            Assert.assertNotNull((Object)handle);
            ObjectInputStream ois = new ObjectInputStream((InputStream)handle.getState(this.getClass().getClassLoader()));
            Assert.assertEquals(state, (Object)ois.readObject());
            Assert.assertTrue((ois.available() <= 0 ? 1 : 0) != 0);
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOversizedStateStream() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend(10);
            HashMap<String, Integer> state = new HashMap<String, Integer>();
            state.put("hey there", 2);
            state.put("the crazy brown fox stumbles over a sentence that does not contain every letter", 77);
            StateBackend.CheckpointStateOutputStream os = backend.createCheckpointStateOutputStream(1L, 2L);
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)os);
            try {
                oos.writeObject(state);
                oos.flush();
                os.closeAndGetHandle();
                Assert.fail((String)"this should cause an exception");
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testKeyValueState() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend();
            MemHeapKvState kv = backend.createKvState((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, null);
            Assert.assertEquals((long)0L, (long)kv.size());
            kv.setCurrentKey((Object)1);
            Assert.assertNull((Object)kv.value());
            kv.update((Object)"1");
            Assert.assertEquals((long)1L, (long)kv.size());
            kv.setCurrentKey((Object)2);
            Assert.assertNull((Object)kv.value());
            kv.update((Object)"2");
            Assert.assertEquals((long)2L, (long)kv.size());
            kv.setCurrentKey((Object)1);
            Assert.assertEquals((Object)"1", (Object)kv.value());
            Assert.assertEquals((long)2L, (long)kv.size());
            KvStateSnapshot snapshot1 = kv.shapshot(682375462378L, System.currentTimeMillis());
            kv.setCurrentKey((Object)1);
            kv.update((Object)"u1");
            kv.setCurrentKey((Object)2);
            kv.update((Object)"u2");
            kv.setCurrentKey((Object)3);
            kv.update((Object)"u3");
            KvStateSnapshot snapshot2 = kv.shapshot(682375462379L, System.currentTimeMillis());
            Assert.assertEquals((long)3L, (long)kv.size());
            kv.setCurrentKey((Object)1);
            Assert.assertEquals((Object)"u1", (Object)kv.value());
            kv.setCurrentKey((Object)2);
            Assert.assertEquals((Object)"u2", (Object)kv.value());
            kv.setCurrentKey((Object)3);
            Assert.assertEquals((Object)"u3", (Object)kv.value());
            KvState restored1 = snapshot1.restoreState((StateBackend)backend, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, null, this.getClass().getClassLoader());
            Assert.assertEquals((long)2L, (long)restored1.size());
            restored1.setCurrentKey((Object)1);
            Assert.assertEquals((Object)"1", (Object)restored1.value());
            restored1.setCurrentKey((Object)2);
            Assert.assertEquals((Object)"2", (Object)restored1.value());
            KvState restored2 = snapshot2.restoreState((StateBackend)backend, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, null, this.getClass().getClassLoader());
            Assert.assertEquals((long)3L, (long)restored2.size());
            restored2.setCurrentKey((Object)1);
            Assert.assertEquals((Object)"u1", (Object)restored2.value());
            restored2.setCurrentKey((Object)2);
            Assert.assertEquals((Object)"u2", (Object)restored2.value());
            restored2.setCurrentKey((Object)3);
            Assert.assertEquals((Object)"u3", (Object)restored2.value());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRestoreWithWrongSerializers() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend();
            MemHeapKvState kv = backend.createKvState((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, null);
            kv.setCurrentKey((Object)1);
            kv.update((Object)"1");
            kv.setCurrentKey((Object)2);
            kv.update((Object)"2");
            KvStateSnapshot snapshot = kv.shapshot(682375462378L, System.currentTimeMillis());
            FloatSerializer fakeIntSerializer = FloatSerializer.INSTANCE;
            ValueSerializer fakeStringSerializer = new ValueSerializer(StringValue.class);
            try {
                snapshot.restoreState((StateBackend)backend, (TypeSerializer)fakeIntSerializer, (TypeSerializer)StringSerializer.INSTANCE, null, this.getClass().getClassLoader());
                Assert.fail((String)"should recognize wrong serializers");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception");
            }
            try {
                snapshot.restoreState((StateBackend)backend, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)fakeStringSerializer, null, this.getClass().getClassLoader());
                Assert.fail((String)"should recognize wrong serializers");
            }
            catch (IllegalArgumentException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception");
            }
            try {
                snapshot.restoreState((StateBackend)backend, (TypeSerializer)fakeIntSerializer, (TypeSerializer)fakeStringSerializer, null, this.getClass().getClassLoader());
                Assert.fail((String)"should recognize wrong serializers");
            }
            catch (IllegalArgumentException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCopyDefaultValue() {
        try {
            MemoryStateBackend backend = new MemoryStateBackend();
            MemHeapKvState kv = backend.createKvState((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntValueSerializer.INSTANCE, (Object)new IntValue(-1));
            kv.setCurrentKey((Object)1);
            IntValue default1 = (IntValue)kv.value();
            kv.setCurrentKey((Object)2);
            IntValue default2 = (IntValue)kv.value();
            Assert.assertNotNull((Object)default1);
            Assert.assertNotNull((Object)default2);
            Assert.assertEquals((Object)default1, (Object)default2);
            Assert.assertFalse((default1 == default2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

