/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.IntValueSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.ValueSerializer;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FsHeapKvState;
import org.apache.flink.runtime.state.filesystem.FsStateBackend;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class FileStateBackendTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetupAndSerialization() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            String backendDir = FileStateBackendTest.localFileUri(tempDir);
            FsStateBackend originalBackend = new FsStateBackend(backendDir);
            Assert.assertFalse((boolean)originalBackend.isInitialized());
            Assert.assertEquals((Object)new URI(backendDir), (Object)originalBackend.getBasePath().toUri());
            Assert.assertNull((Object)originalBackend.getCheckpointDirectory());
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)originalBackend);
            Assert.assertFalse((boolean)backend.isInitialized());
            Assert.assertEquals((Object)new URI(backendDir), (Object)backend.getBasePath().toUri());
            Assert.assertNull((Object)backend.getCheckpointDirectory());
            try {
                backend.checkpointStateSerializable((Serializable)((Object)"exception train rolling in"), 2L, System.currentTimeMillis());
                Assert.fail((String)"should fail with an exception");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            backend.initializeForJob(new JobID());
            Assert.assertNotNull((Object)backend.getCheckpointDirectory());
            File checkpointDir = new File(backend.getCheckpointDirectory().toUri().getPath());
            Assert.assertTrue((boolean)checkpointDir.exists());
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            backend.disposeAllStateForCurrentJob();
            Assert.assertNull((Object)backend.getCheckpointDirectory());
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(tempDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerializableState() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)new FsStateBackend(FileStateBackendTest.localFileUri(tempDir)));
            backend.initializeForJob(new JobID());
            File checkpointDir = new File(backend.getCheckpointDirectory().toUri().getPath());
            String state1 = "dummy state";
            String state2 = "row row row your boat";
            Integer state3 = 42;
            StateHandle handle1 = backend.checkpointStateSerializable((Serializable)((Object)state1), 439568923746L, System.currentTimeMillis());
            StateHandle handle2 = backend.checkpointStateSerializable((Serializable)((Object)state2), 439568923746L, System.currentTimeMillis());
            StateHandle handle3 = backend.checkpointStateSerializable((Serializable)state3, 439568923746L, System.currentTimeMillis());
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            Assert.assertEquals((Object)state1, (Object)handle1.getState(this.getClass().getClassLoader()));
            handle1.discardState();
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            Assert.assertEquals((Object)state2, (Object)handle2.getState(this.getClass().getClassLoader()));
            handle2.discardState();
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            Assert.assertEquals((Object)state3, (Object)handle3.getState(this.getClass().getClassLoader()));
            handle3.discardState();
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStateOutputStream() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            StreamStateHandle handle4;
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)new FsStateBackend(FileStateBackendTest.localFileUri(tempDir)));
            backend.initializeForJob(new JobID());
            File checkpointDir = new File(backend.getCheckpointDirectory().toUri().getPath());
            byte[] state1 = new byte[0x137331];
            byte[] state2 = new byte[1];
            byte[] state3 = new byte[]{};
            byte[] state4 = new byte[177];
            Random rnd = new Random();
            rnd.nextBytes(state1);
            rnd.nextBytes(state2);
            rnd.nextBytes(state3);
            rnd.nextBytes(state4);
            long checkpointId = 97231523452L;
            FsStateBackend.FsCheckpointStateOutputStream stream1 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            FsStateBackend.FsCheckpointStateOutputStream stream2 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            FsStateBackend.FsCheckpointStateOutputStream stream3 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            stream1.write(state1);
            stream2.write(state2);
            stream3.write(state3);
            FileStreamStateHandle handle1 = stream1.closeAndGetHandle();
            FileStreamStateHandle handle2 = stream2.closeAndGetHandle();
            FileStreamStateHandle handle3 = stream3.closeAndGetHandle();
            try (FsStateBackend.FsCheckpointStateOutputStream stream4 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());){
                stream4.write(state4);
                handle4 = stream4.closeAndGetHandle();
            }
            FsStateBackend.FsCheckpointStateOutputStream stream5 = backend.createCheckpointStateOutputStream(checkpointId, System.currentTimeMillis());
            stream5.write(state4);
            stream5.close();
            try {
                stream5.closeAndGetHandle();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            FileStateBackendTest.validateBytesInStream(handle1.getState(this.getClass().getClassLoader()), state1);
            handle1.discardState();
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            FileStateBackendTest.ensureLocalFileDeleted(handle1.getFilePath());
            FileStateBackendTest.validateBytesInStream(handle2.getState(this.getClass().getClassLoader()), state2);
            handle2.discardState();
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            FileStateBackendTest.ensureLocalFileDeleted(handle2.getFilePath());
            FileStateBackendTest.validateBytesInStream(handle3.getState(this.getClass().getClassLoader()), state3);
            handle3.discardState();
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            FileStateBackendTest.ensureLocalFileDeleted(handle3.getFilePath());
            FileStateBackendTest.validateBytesInStream((InputStream)handle4.getState(this.getClass().getClassLoader()), state4);
            handle4.discardState();
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeyValueState() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)new FsStateBackend(FileStateBackendTest.localFileUri(tempDir)));
            backend.initializeForJob(new JobID());
            File checkpointDir = new File(backend.getCheckpointDirectory().toUri().getPath());
            FsHeapKvState kv = backend.createKvState((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, null);
            Assert.assertEquals((long)0L, (long)kv.size());
            kv.setCurrentKey((Object)1);
            Assert.assertNull((Object)kv.value());
            kv.update((Object)"1");
            Assert.assertEquals((long)1L, (long)kv.size());
            kv.setCurrentKey((Object)2);
            Assert.assertNull((Object)kv.value());
            kv.update((Object)"2");
            Assert.assertEquals((long)2L, (long)kv.size());
            kv.setCurrentKey((Object)1);
            Assert.assertEquals((Object)"1", (Object)kv.value());
            Assert.assertEquals((long)2L, (long)kv.size());
            KvStateSnapshot snapshot1 = kv.shapshot(682375462378L, System.currentTimeMillis());
            kv.setCurrentKey((Object)1);
            kv.update((Object)"u1");
            kv.setCurrentKey((Object)2);
            kv.update((Object)"u2");
            kv.setCurrentKey((Object)3);
            kv.update((Object)"u3");
            KvStateSnapshot snapshot2 = kv.shapshot(682375462379L, System.currentTimeMillis());
            Assert.assertEquals((long)3L, (long)kv.size());
            kv.setCurrentKey((Object)1);
            Assert.assertEquals((Object)"u1", (Object)kv.value());
            kv.setCurrentKey((Object)2);
            Assert.assertEquals((Object)"u2", (Object)kv.value());
            kv.setCurrentKey((Object)3);
            Assert.assertEquals((Object)"u3", (Object)kv.value());
            KvState restored1 = snapshot1.restoreState((StateBackend)backend, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, null, this.getClass().getClassLoader());
            Assert.assertEquals((long)2L, (long)restored1.size());
            restored1.setCurrentKey((Object)1);
            Assert.assertEquals((Object)"1", (Object)restored1.value());
            restored1.setCurrentKey((Object)2);
            Assert.assertEquals((Object)"2", (Object)restored1.value());
            KvState restored2 = snapshot2.restoreState((StateBackend)backend, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, null, this.getClass().getClassLoader());
            Assert.assertEquals((long)3L, (long)restored2.size());
            restored2.setCurrentKey((Object)1);
            Assert.assertEquals((Object)"u1", (Object)restored2.value());
            restored2.setCurrentKey((Object)2);
            Assert.assertEquals((Object)"u2", (Object)restored2.value());
            restored2.setCurrentKey((Object)3);
            Assert.assertEquals((Object)"u3", (Object)restored2.value());
            snapshot1.discardState();
            Assert.assertFalse((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
            snapshot2.discardState();
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoreWithWrongSerializers() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)new FsStateBackend(FileStateBackendTest.localFileUri(tempDir)));
            backend.initializeForJob(new JobID());
            File checkpointDir = new File(backend.getCheckpointDirectory().toUri().getPath());
            FsHeapKvState kv = backend.createKvState((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE, null);
            kv.setCurrentKey((Object)1);
            kv.update((Object)"1");
            kv.setCurrentKey((Object)2);
            kv.update((Object)"2");
            KvStateSnapshot snapshot = kv.shapshot(682375462378L, System.currentTimeMillis());
            FloatSerializer fakeIntSerializer = FloatSerializer.INSTANCE;
            ValueSerializer fakeStringSerializer = new ValueSerializer(StringValue.class);
            try {
                snapshot.restoreState((StateBackend)backend, (TypeSerializer)fakeIntSerializer, (TypeSerializer)StringSerializer.INSTANCE, null, this.getClass().getClassLoader());
                Assert.fail((String)"should recognize wrong serializers");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception");
            }
            try {
                snapshot.restoreState((StateBackend)backend, (TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)fakeStringSerializer, null, this.getClass().getClassLoader());
                Assert.fail((String)"should recognize wrong serializers");
            }
            catch (IllegalArgumentException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception");
            }
            try {
                snapshot.restoreState((StateBackend)backend, (TypeSerializer)fakeIntSerializer, (TypeSerializer)fakeStringSerializer, null, this.getClass().getClassLoader());
                Assert.fail((String)"should recognize wrong serializers");
            }
            catch (IllegalArgumentException e) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception");
            }
            snapshot.discardState();
            Assert.assertTrue((boolean)FileStateBackendTest.isDirectoryEmpty(checkpointDir));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyDefaultValue() {
        File tempDir = new File(ConfigConstants.DEFAULT_TASK_MANAGER_TMP_PATH, UUID.randomUUID().toString());
        try {
            FsStateBackend backend = (FsStateBackend)CommonTestUtils.createCopySerializable((Serializable)new FsStateBackend(FileStateBackendTest.localFileUri(tempDir)));
            backend.initializeForJob(new JobID());
            FsHeapKvState kv = backend.createKvState((TypeSerializer)IntSerializer.INSTANCE, (TypeSerializer)IntValueSerializer.INSTANCE, (Object)new IntValue(-1));
            kv.setCurrentKey((Object)1);
            IntValue default1 = (IntValue)kv.value();
            kv.setCurrentKey((Object)2);
            IntValue default2 = (IntValue)kv.value();
            Assert.assertNotNull((Object)default1);
            Assert.assertNotNull((Object)default2);
            Assert.assertEquals((Object)default1, (Object)default2);
            Assert.assertFalse((default1 == default2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            FileStateBackendTest.deleteDirectorySilently(tempDir);
        }
    }

    private static void ensureLocalFileDeleted(Path path) {
        URI uri = path.toUri();
        if (!"file".equals(uri.getScheme())) {
            throw new IllegalArgumentException("not a local path");
        }
        File file = new File(uri.getPath());
        Assert.assertFalse((String)"file not properly deleted", (boolean)file.exists());
    }

    private static void deleteDirectorySilently(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isDirectoryEmpty(File directory) {
        String[] nested = directory.list();
        return nested == null || nested.length == 0;
    }

    private static String localFileUri(File path) {
        return path.toURI().toString();
    }

    private static void validateBytesInStream(InputStream is, byte[] data) throws IOException {
        byte[] holder = new byte[data.length];
        Assert.assertEquals((String)"not enough data", (long)holder.length, (long)is.read(holder));
        Assert.assertEquals((String)"too much data", (long)-1L, (long)is.read());
        Assert.assertArrayEquals((String)"wrong data", (byte[])data, (byte[])holder);
    }
}

