/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.util.List;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.api.common.typeutils.record.RecordSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.IteratorWrappingTestSingleInputGate;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.types.Record;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;

public abstract class TaskTestBase
extends TestLogger {
    protected long memorySize = 0L;
    protected MockInputSplitProvider inputSplitProvider;
    protected MockEnvironment mockEnv;

    public void initEnvironment(long memorySize, int bufferSize) {
        this.memorySize = memorySize;
        this.inputSplitProvider = new MockInputSplitProvider();
        this.mockEnv = new MockEnvironment("mock task", this.memorySize, this.inputSplitProvider, bufferSize);
    }

    public IteratorWrappingTestSingleInputGate<Record> addInput(MutableObjectIterator<Record> input, int groupId) {
        return this.addInput(input, groupId, true);
    }

    public IteratorWrappingTestSingleInputGate<Record> addInput(MutableObjectIterator<Record> input, int groupId, boolean read) {
        IteratorWrappingTestSingleInputGate<Record> reader = this.mockEnv.addInput(input);
        TaskConfig conf = new TaskConfig(this.mockEnv.getTaskConfiguration());
        conf.addInputToGroup(groupId);
        conf.setInputSerializer((TypeSerializerFactory)RecordSerializerFactory.get(), groupId);
        if (read) {
            reader.read();
        }
        return reader;
    }

    public void addOutput(List<Record> output) {
        this.mockEnv.addOutput(output);
        TaskConfig conf = new TaskConfig(this.mockEnv.getTaskConfiguration());
        conf.addOutputShipStrategy(ShipStrategyType.FORWARD);
        conf.setOutputSerializer((TypeSerializerFactory)RecordSerializerFactory.get());
    }

    public TaskConfig getTaskConfig() {
        return new TaskConfig(this.mockEnv.getTaskConfiguration());
    }

    public Configuration getConfiguration() {
        return this.mockEnv.getTaskConfiguration();
    }

    public void registerTask(AbstractInvokable task, Class<? extends Driver> driver, Class<? extends RichFunction> stubClass) {
        TaskConfig config = new TaskConfig(this.mockEnv.getTaskConfiguration());
        config.setDriver(driver);
        config.setStubWrapper((UserCodeWrapper)new UserCodeClassWrapper(stubClass));
        task.setEnvironment((Environment)this.mockEnv);
        try {
            task.registerInputOutput();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void registerTask(AbstractInvokable task) {
        task.setEnvironment((Environment)this.mockEnv);
        try {
            task.registerInputOutput();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void registerFileOutputTask(AbstractInvokable outTask, Class<? extends FileOutputFormat<Record>> stubClass, String outPath) {
        this.registerFileOutputTask(outTask, (FileOutputFormat<Record>)((FileOutputFormat)InstantiationUtil.instantiate(stubClass, FileOutputFormat.class)), outPath);
    }

    public void registerFileOutputTask(AbstractInvokable outTask, FileOutputFormat<Record> outputFormat, String outPath) {
        TaskConfig dsConfig = new TaskConfig(this.mockEnv.getTaskConfiguration());
        outputFormat.setOutputFilePath(new Path(outPath));
        outputFormat.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dsConfig.setStubWrapper((UserCodeWrapper)new UserCodeObjectWrapper(outputFormat));
        outTask.setEnvironment((Environment)this.mockEnv);
        try {
            outTask.registerInputOutput();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void registerFileInputTask(AbstractInvokable inTask, Class<? extends DelimitedInputFormat<Record>> stubClass, String inPath, String delimiter) {
        DelimitedInputFormat<Record> format;
        try {
            format = stubClass.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not instantiate test input format.", t);
        }
        format.setFilePath(inPath);
        format.setDelimiter(delimiter);
        TaskConfig dsConfig = new TaskConfig(this.mockEnv.getTaskConfiguration());
        dsConfig.setStubWrapper((UserCodeWrapper)new UserCodeObjectWrapper(format));
        this.inputSplitProvider.addInputSplits(inPath, 5);
        inTask.setEnvironment((Environment)this.mockEnv);
        try {
            inTask.registerInputOutput();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public MemoryManager getMemoryManager() {
        return this.mockEnv.getMemoryManager();
    }

    @After
    public void shutdownIOManager() throws Exception {
        this.mockEnv.getIOManager().shutdown();
        Assert.assertTrue((String)"IO Manager has not properly shut down.", (boolean)this.mockEnv.getIOManager().isProperlyShutDown());
    }

    @After
    public void shutdownMemoryManager() throws Exception {
        MemoryManager memMan;
        if (this.memorySize > 0L && (memMan = this.getMemoryManager()) != null) {
            Assert.assertTrue((String)"Memory Manager managed memory was not completely freed.", (boolean)memMan.verifyEmpty());
            memMan.shutdown();
        }
    }
}

