/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.api.serialization.AdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.IteratorWrappingTestSingleInputGate;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.types.Record;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockEnvironment
implements Environment {
    private final String taskName;
    private final MemoryManager memManager;
    private final IOManager ioManager;
    private final InputSplitProvider inputSplitProvider;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final List<InputGate> inputs;
    private final List<ResultPartitionWriter> outputs;
    private final JobID jobID = new JobID();
    private final BroadcastVariableManager bcVarManager = new BroadcastVariableManager();
    private final AccumulatorRegistry accumulatorRegistry;
    private final int bufferSize;

    public MockEnvironment(String taskName, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize) {
        this.taskName = taskName;
        this.jobConfiguration = new Configuration();
        this.taskConfiguration = new Configuration();
        this.inputs = new LinkedList<InputGate>();
        this.outputs = new LinkedList<ResultPartitionWriter>();
        this.memManager = new MemoryManager(memorySize, 1);
        this.ioManager = new IOManagerAsync();
        this.inputSplitProvider = inputSplitProvider;
        this.bufferSize = bufferSize;
        this.accumulatorRegistry = new AccumulatorRegistry(this.jobID, this.getExecutionId());
    }

    public IteratorWrappingTestSingleInputGate<Record> addInput(MutableObjectIterator<Record> inputIterator) {
        try {
            IteratorWrappingTestSingleInputGate<Record> reader = new IteratorWrappingTestSingleInputGate<Record>(this.bufferSize, Record.class, inputIterator);
            this.inputs.add((InputGate)reader.getInputGate());
            return reader;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error setting up mock readers: " + t.getMessage(), t);
        }
    }

    public void addOutput(List<Record> outputList) {
        try {
            BufferProvider mockBufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
            Mockito.when((Object)mockBufferProvider.requestBufferBlocking()).thenAnswer((Answer)new Answer<Buffer>(){

                public Buffer answer(InvocationOnMock invocationOnMock) throws Throwable {
                    return new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)MockEnvironment.this.bufferSize), (BufferRecycler)Mockito.mock(BufferRecycler.class));
                }
            });
            ResultPartitionWriter mockWriter = (ResultPartitionWriter)Mockito.mock(ResultPartitionWriter.class);
            Mockito.when((Object)mockWriter.getNumberOfOutputChannels()).thenReturn((Object)1);
            Mockito.when((Object)mockWriter.getBufferProvider()).thenReturn((Object)mockBufferProvider);
            Record record = new Record();
            AdaptiveSpanningRecordDeserializer deserializer = new AdaptiveSpanningRecordDeserializer();
            ((ResultPartitionWriter)Mockito.doAnswer((Answer)new Answer<Void>((RecordDeserializer)deserializer, record, outputList){
                final /* synthetic */ RecordDeserializer val$deserializer;
                final /* synthetic */ Record val$record;
                final /* synthetic */ List val$outputList;
                {
                    this.val$deserializer = recordDeserializer;
                    this.val$record = record;
                    this.val$outputList = list;
                }

                public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                    Buffer buffer = (Buffer)invocationOnMock.getArguments()[0];
                    this.val$deserializer.setNextBuffer(buffer);
                    while (this.val$deserializer.hasUnfinishedData()) {
                        RecordDeserializer.DeserializationResult result = this.val$deserializer.getNextRecord((IOReadableWritable)this.val$record);
                        if (result.isFullRecord()) {
                            this.val$outputList.add(this.val$record.createCopy());
                        }
                        if (result != RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER && result != RecordDeserializer.DeserializationResult.PARTIAL_RECORD) continue;
                        break;
                    }
                    return null;
                }
            }).when((Object)mockWriter)).writeBuffer((Buffer)Matchers.any(Buffer.class), Matchers.anyInt());
            this.outputs.add(mockWriter);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return new TaskManagerRuntimeInfo("localhost", (Configuration)new UnmodifiableConfiguration(new Configuration()));
    }

    public int getNumberOfSubtasks() {
        return 1;
    }

    public int getIndexInSubtaskGroup() {
        return 0;
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.inputSplitProvider;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskNameWithSubtasks() {
        return this.taskName + "(0/1)";
    }

    public ClassLoader getUserClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public ResultPartitionWriter getWriter(int index) {
        return this.outputs.get(index);
    }

    public ResultPartitionWriter[] getAllWriters() {
        return this.outputs.toArray(new ResultPartitionWriter[this.outputs.size()]);
    }

    public InputGate getInputGate(int index) {
        return this.inputs.get(index);
    }

    public InputGate[] getAllInputGates() {
        InputGate[] gates = new InputGate[this.inputs.size()];
        this.inputs.toArray(gates);
        return gates;
    }

    public JobVertexID getJobVertexId() {
        return new JobVertexID(new byte[16]);
    }

    public ExecutionAttemptID getExecutionId() {
        return new ExecutionAttemptID(0L, 0L);
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public void acknowledgeCheckpoint(long checkpointId) {
        throw new UnsupportedOperationException();
    }

    public void acknowledgeCheckpoint(long checkpointId, StateHandle<?> state) {
        throw new UnsupportedOperationException();
    }
}

