/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.operators.testutils.UniformStringPairGenerator;
import org.apache.flink.runtime.operators.testutils.types.IntList;
import org.apache.flink.runtime.operators.testutils.types.IntListComparator;
import org.apache.flink.runtime.operators.testutils.types.IntListPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntListSerializer;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.runtime.operators.testutils.types.IntPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairListPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairSerializer;
import org.apache.flink.runtime.operators.testutils.types.StringPair;
import org.apache.flink.runtime.operators.testutils.types.StringPairComparator;
import org.apache.flink.runtime.operators.testutils.types.StringPairPairComparator;
import org.apache.flink.runtime.operators.testutils.types.StringPairSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

public class MemoryHashTableTest {
    private static final long RANDOM_SEED = 76518743207143L;
    private static final int KEY_VALUE_DIFF = 1021;
    private static final int PAGE_SIZE = 16384;
    private final Random rnd = new Random(76518743207143L);
    private final TypeSerializer<IntPair> serializer = new IntPairSerializer();
    private final TypeComparator<IntPair> comparator = new IntPairComparator();
    private final TypePairComparator<IntPair, IntPair> pairComparator = new IntPairPairComparator();
    private static final int MAX_LIST_SIZE = 8;
    private final TypeSerializer<IntList> serializerV = new IntListSerializer();
    private final TypeComparator<IntList> comparatorV = new IntListComparator();
    private final TypePairComparator<IntList, IntList> pairComparatorV = new IntListPairComparator();
    private final TypePairComparator<IntPair, IntList> pairComparatorPL = new IntPairListPairComparator();
    private final int SIZE = 75;
    private final int NUM_PAIRS = 100000;
    private final int NUM_LISTS = 100000;
    private final int ADDITIONAL_MEM = 100;
    private final int NUM_REWRITES = 10;
    private final TypeSerializer<StringPair> serializerS = new StringPairSerializer();
    private final TypeComparator<StringPair> comparatorS = new StringPairComparator();
    private final TypePairComparator<StringPair, StringPair> pairComparatorS = new StringPairPairComparator();

    @Test
    public void testDifferentProbers() {
        AbstractHashTableProber prober2;
        int NUM_MEM_PAGES = 195;
        CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, MemoryHashTableTest.getMemory(195, 16384));
        AbstractHashTableProber prober1 = table.getProber(this.comparator, this.pairComparator);
        Assert.assertFalse((prober1 == (prober2 = table.getProber(this.comparator, this.pairComparator)) ? 1 : 0) != 0);
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)195L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testBuildAndRetrieve() {
        try {
            int NUM_MEM_PAGES = 195;
            IntPair[] pairs = MemoryHashTableTest.getRandomizedIntPairs(100000, this.rnd);
            CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, MemoryHashTableTest.getMemory(195, 16384));
            table.open();
            for (int i = 0; i < 100000; ++i) {
                table.insert((Object)pairs[i]);
            }
            AbstractHashTableProber prober = table.getProber(this.comparator, this.pairComparator);
            IntPair target = new IntPair();
            for (int i = 0; i < 100000; ++i) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)195L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testEntryIterator() {
        try {
            int NUM_MEM_PAGES = 457;
            IntList[] lists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, MemoryHashTableTest.getMemory(457, 16384));
            table.open();
            int result = 0;
            for (int i = 0; i < 100000; ++i) {
                table.insert((Object)lists[i]);
                result += lists[i].getKey();
            }
            MutableObjectIterator iter = table.getEntryIterator();
            IntList target = new IntList();
            int sum = 0;
            while ((target = (IntList)iter.next((Object)target)) != null) {
                sum += target.getKey();
            }
            table.close();
            Assert.assertTrue((sum == result ? 1 : 0) != 0);
            Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testMultipleProbers() {
        try {
            int NUM_MEM_PAGES = 457;
            IntList[] lists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            IntPair[] pairs = MemoryHashTableTest.getRandomizedIntPairs(100000, this.rnd);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, MemoryHashTableTest.getMemory(457, 16384));
            table.open();
            for (int i = 0; i < 100000; ++i) {
                table.insert((Object)lists[i]);
            }
            AbstractHashTableProber listProber = table.getProber(this.comparatorV, this.pairComparatorV);
            AbstractHashTableProber pairProber = table.getProber(this.comparator, this.pairComparatorPL);
            IntList target = new IntList();
            for (int i = 0; i < 100000; ++i) {
                Assert.assertNotNull((Object)pairProber.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertNotNull((Object)listProber.getMatchFor((Object)lists[i], (Object)target));
                Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testVariableLengthBuildAndRetrieve() {
        try {
            int i;
            int NUM_MEM_PAGES = 457;
            IntList[] lists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, MemoryHashTableTest.getMemory(457, 16384));
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)lists[i2]);
                continue;
            }
            AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
            IntList target = new IntList();
            for (int i3 = 0; i3 < 100000; ++i3) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i3], (Object)target));
                Assert.assertArrayEquals((int[])lists[i3].getValue(), (int[])target.getValue());
            }
            IntList[] overwriteLists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            for (i = 0; i < 100000; ++i) {
                table.insertOrReplaceRecord((Object)overwriteLists[i]);
            }
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)overwriteLists[i], (Object)target));
                Assert.assertArrayEquals((int[])overwriteLists[i].getValue(), (int[])target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testVariableLengthBuildAndRetrieveMajorityUpdated() {
        try {
            int i;
            int NUM_MEM_PAGES = 457;
            IntList[] lists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, MemoryHashTableTest.getMemory(457, 16384));
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)lists[i2]);
            }
            AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
            IntList target = new IntList();
            for (int i3 = 0; i3 < 100000; ++i3) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i3], (Object)target));
                Assert.assertArrayEquals((int[])lists[i3].getValue(), (int[])target.getValue());
            }
            IntList[] overwriteLists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            for (i = 0; i < 100000; ++i) {
                if (i % 100 == 0) continue;
                table.insertOrReplaceRecord((Object)overwriteLists[i]);
                lists[i] = overwriteLists[i];
            }
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)lists[i], (Object)target));
                Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testVariableLengthBuildAndRetrieveMinorityUpdated() {
        try {
            int i;
            int NUM_LISTS = 20000;
            int NUM_MEM_PAGES = 91;
            int STEP_SIZE = 100;
            IntList[] lists = MemoryHashTableTest.getRandomizedIntLists(20000, this.rnd);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, MemoryHashTableTest.getMemory(91, 16384));
            table.open();
            for (int i2 = 0; i2 < 20000; ++i2) {
                table.insert((Object)lists[i2]);
            }
            AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
            IntList target = new IntList();
            for (int i3 = 0; i3 < 20000; ++i3) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i3], (Object)target));
                Assert.assertArrayEquals((int[])lists[i3].getValue(), (int[])target.getValue());
            }
            IntList[] overwriteLists = MemoryHashTableTest.getRandomizedIntLists(200, this.rnd);
            for (i = 0; i < 20000; i += 100) {
                overwriteLists[i / 100].setKey(overwriteLists[i / 100].getKey() * 100);
                table.insertOrReplaceRecord((Object)overwriteLists[i / 100]);
                lists[i] = overwriteLists[i / 100];
            }
            for (i = 0; i < 20000; ++i) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i], (Object)target));
                Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)91L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testRepeatedBuildAndRetrieve() {
        try {
            int NUM_MEM_PAGES = 457;
            IntList[] lists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, MemoryHashTableTest.getMemory(457, 16384));
            table.open();
            for (int i = 0; i < 100000; ++i) {
                table.insert((Object)lists[i]);
                continue;
            }
            AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
            IntList target = new IntList();
            for (int i = 0; i < 100000; ++i) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i], (Object)target));
                Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
            }
            for (int k = 0; k < 10; ++k) {
                int i;
                IntList[] overwriteLists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
                for (i = 0; i < 100000; ++i) {
                    table.insertOrReplaceRecord((Object)overwriteLists[i]);
                }
                for (i = 0; i < 100000; ++i) {
                    Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)overwriteLists[i], (Object)target));
                    Assert.assertArrayEquals((int[])overwriteLists[i].getValue(), (int[])target.getValue());
                }
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testProberUpdate() {
        try {
            int i;
            int NUM_MEM_PAGES = 457;
            IntList[] lists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, MemoryHashTableTest.getMemory(457, 16384));
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)lists[i2]);
            }
            IntList[] overwriteLists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
            IntList target = new IntList();
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)lists[i], (Object)target));
                Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
                prober.updateMatch((Object)overwriteLists[i]);
            }
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)overwriteLists[i], (Object)target));
                Assert.assertArrayEquals((int[])overwriteLists[i].getValue(), (int[])target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testResize() {
        try {
            int NUM_MEM_PAGES = 183;
            IntPair[] pairs = MemoryHashTableTest.getRandomizedIntPairs(100000, this.rnd);
            List<MemorySegment> memory = MemoryHashTableTest.getMemory(183, 16384);
            CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, memory);
            table.open();
            for (int i = 0; i < 100000; ++i) {
                table.insert((Object)pairs[i]);
            }
            CompactingHashTable.HashTableProber prober = table.getProber(this.comparator, this.pairComparator);
            IntPair target = new IntPair();
            for (int i = 0; i < 100000; ++i) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
            }
            memory.addAll(MemoryHashTableTest.getMemory(100, 16384));
            Boolean b = (Boolean)Whitebox.invokeMethod((Object)table, (String)"resizeHashTable", (Object[])new Object[0]);
            Assert.assertTrue((boolean)b);
            for (int i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)(pairs[i].getKey() + " " + pairs[i].getValue()), (Object)prober.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)283L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testDoubleResize() {
        try {
            int i;
            int NUM_MEM_PAGES = 183;
            IntPair[] pairs = MemoryHashTableTest.getRandomizedIntPairs(100000, this.rnd);
            List<MemorySegment> memory = MemoryHashTableTest.getMemory(183, 16384);
            CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, memory);
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)pairs[i2]);
            }
            CompactingHashTable.HashTableProber prober = table.getProber(this.comparator, this.pairComparator);
            IntPair target = new IntPair();
            for (int i3 = 0; i3 < 100000; ++i3) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)pairs[i3], (Object)target));
                Assert.assertEquals((long)pairs[i3].getValue(), (long)target.getValue());
            }
            memory.addAll(MemoryHashTableTest.getMemory(100, 16384));
            Boolean b = (Boolean)Whitebox.invokeMethod((Object)table, (String)"resizeHashTable", (Object[])new Object[0]);
            Assert.assertTrue((boolean)b);
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)(pairs[i].getKey() + " " + pairs[i].getValue()), (Object)prober.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
            }
            memory.addAll(MemoryHashTableTest.getMemory(100, 16384));
            b = (Boolean)Whitebox.invokeMethod((Object)table, (String)"resizeHashTable", (Object[])new Object[0]);
            Assert.assertTrue((boolean)b);
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)(pairs[i].getKey() + " " + pairs[i].getValue()), (Object)prober.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)383L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testTripleResize() {
        try {
            int i;
            int NUM_MEM_PAGES = 183;
            IntPair[] pairs = MemoryHashTableTest.getRandomizedIntPairs(100000, this.rnd);
            List<MemorySegment> memory = MemoryHashTableTest.getMemory(183, 16384);
            CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, memory);
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)pairs[i2]);
            }
            CompactingHashTable.HashTableProber prober = table.getProber(this.comparator, this.pairComparator);
            IntPair target = new IntPair();
            for (int i3 = 0; i3 < 100000; ++i3) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)pairs[i3], (Object)target));
                Assert.assertEquals((long)pairs[i3].getValue(), (long)target.getValue());
            }
            memory.addAll(MemoryHashTableTest.getMemory(100, 16384));
            Boolean b = (Boolean)Whitebox.invokeMethod((Object)table, (String)"resizeHashTable", (Object[])new Object[0]);
            Assert.assertTrue((boolean)b);
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)(pairs[i].getKey() + " " + pairs[i].getValue()), (Object)prober.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
            }
            memory.addAll(MemoryHashTableTest.getMemory(100, 16384));
            b = (Boolean)Whitebox.invokeMethod((Object)table, (String)"resizeHashTable", (Object[])new Object[0]);
            Assert.assertTrue((boolean)b);
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)(pairs[i].getKey() + " " + pairs[i].getValue()), (Object)prober.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
            }
            memory.addAll(MemoryHashTableTest.getMemory(200, 16384));
            b = (Boolean)Whitebox.invokeMethod((Object)table, (String)"resizeHashTable", (Object[])new Object[0]);
            Assert.assertTrue((boolean)b);
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)(pairs[i].getKey() + " " + pairs[i].getValue()), (Object)prober.getMatchFor((Object)pairs[i], (Object)target));
                Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)583L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testResizeWithCompaction() {
        try {
            int i;
            int NUM_MEM_PAGES = 457;
            IntList[] lists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            List<MemorySegment> memory = MemoryHashTableTest.getMemory(457, 16384);
            CompactingHashTable table = new CompactingHashTable(this.serializerV, this.comparatorV, memory);
            table.open();
            for (int i2 = 0; i2 < 100000; ++i2) {
                table.insert((Object)lists[i2]);
                continue;
            }
            CompactingHashTable.HashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
            IntList target = new IntList();
            for (int i3 = 0; i3 < 100000; ++i3) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i3], (Object)target));
                Assert.assertArrayEquals((int[])lists[i3].getValue(), (int[])target.getValue());
            }
            memory.addAll(MemoryHashTableTest.getMemory(100, 16384));
            Boolean b = (Boolean)Whitebox.invokeMethod((Object)table, (String)"resizeHashTable", (Object[])new Object[0]);
            Assert.assertTrue((boolean)b);
            for (int i4 = 0; i4 < 100000; ++i4) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i4], (Object)target));
                Assert.assertArrayEquals((int[])lists[i4].getValue(), (int[])target.getValue());
            }
            IntList[] overwriteLists = MemoryHashTableTest.getRandomizedIntLists(100000, this.rnd);
            for (int i5 = 0; i5 < 100000; ++i5) {
                table.insertOrReplaceRecord((Object)overwriteLists[i5]);
            }
            Field list = Whitebox.getField(CompactingHashTable.class, (String)"partitions");
            ArrayList partitions = (ArrayList)list.get(table);
            int numPartitions = partitions.size();
            for (i = 0; i < numPartitions; ++i) {
                Whitebox.invokeMethod((Object)table, (String)"compactPartition", (Object[])new Object[]{i});
            }
            memory.addAll(MemoryHashTableTest.getMemory(200, 16384));
            b = (Boolean)Whitebox.invokeMethod((Object)table, (String)"resizeHashTable", (Object[])new Object[0]);
            Assert.assertTrue((boolean)b);
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)overwriteLists[i], (Object)target));
                Assert.assertArrayEquals((int[])overwriteLists[i].getValue(), (int[])target.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)757L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    @Test
    public void testVariableLengthStringBuildAndRetrieve() {
        try {
            int NUM_MEM_PAGES = 244;
            UniformStringPairGenerator buildInput = new UniformStringPairGenerator(100000, 1, false);
            UniformStringPairGenerator probeTester = new UniformStringPairGenerator(100000, 1, false);
            UniformStringPairGenerator updater = new UniformStringPairGenerator(100000, 1, false);
            UniformStringPairGenerator updateTester = new UniformStringPairGenerator(100000, 1, false);
            CompactingHashTable table = new CompactingHashTable(this.serializerS, this.comparatorS, MemoryHashTableTest.getMemory(244, 16384));
            table.open();
            StringPair target = new StringPair();
            while (buildInput.next(target) != null) {
                table.insert((Object)target);
            }
            AbstractHashTableProber prober = table.getProber(this.comparatorS, this.pairComparatorS);
            StringPair temp = new StringPair();
            while (probeTester.next(target) != null) {
                Assert.assertNotNull((String)("" + target.getKey()), (Object)prober.getMatchFor((Object)target, (Object)temp));
                Assert.assertEquals((Object)temp.getValue(), (Object)target.getValue());
            }
            while (updater.next(target) != null) {
                target.setValue(target.getValue());
                table.insertOrReplaceRecord((Object)target);
            }
            while (updateTester.next(target) != null) {
                Assert.assertNotNull((Object)prober.getMatchFor((Object)target, (Object)temp));
                Assert.assertEquals((Object)target.getValue(), (Object)temp.getValue());
            }
            table.close();
            Assert.assertEquals((String)"Memory lost", (long)244L, (long)table.getFreeMemory().size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error: " + e.getMessage()));
        }
    }

    private static IntPair[] getRandomizedIntPairs(int num, Random rnd) {
        int i;
        IntPair[] pairs = new IntPair[num];
        for (i = 0; i < num; ++i) {
            pairs[i] = new IntPair(i, i + 1021);
        }
        for (i = 0; i < 2 * num; ++i) {
            int pos1 = rnd.nextInt(num);
            int pos2 = rnd.nextInt(num);
            IntPair tmp = pairs[pos1];
            pairs[pos1] = pairs[pos2];
            pairs[pos2] = tmp;
        }
        return pairs;
    }

    private static IntList[] getRandomizedIntLists(int num, Random rnd) {
        IntList[] lists = new IntList[num];
        for (int i = 0; i < num; ++i) {
            int[] value = new int[rnd.nextInt(8) + 1];
            for (int j = 0; j < value.length; ++j) {
                value[j] = -rnd.nextInt(Integer.MAX_VALUE);
            }
            lists[i] = new IntList(i, value);
        }
        return lists;
    }

    private static List<MemorySegment> getMemory(int numPages, int pageSize) {
        ArrayList<MemorySegment> memory = new ArrayList<MemorySegment>();
        for (int i = 0; i < numPages; ++i) {
            memory.add(MemorySegmentFactory.allocateUnpooledSegment((int)pageSize));
        }
        return memory;
    }
}

