/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;

public class CompactingHashTableTest {
    private final TypeSerializer<Tuple2<Long, String>> serializer;
    private final TypeComparator<Tuple2<Long, String>> comparator;
    private final TypeComparator<Long> probeComparator;
    private final TypePairComparator<Long, Tuple2<Long, String>> pairComparator;

    public CompactingHashTableTest() {
        TypeSerializer[] fieldSerializers = new TypeSerializer[]{LongSerializer.INSTANCE, StringSerializer.INSTANCE};
        Class<Tuple2> clazz = Tuple2.class;
        this.serializer = new TupleSerializer(clazz, fieldSerializers);
        TypeComparator[] comparators = new TypeComparator[]{new LongComparator(true)};
        TypeSerializer[] comparatorSerializers = new TypeSerializer[]{LongSerializer.INSTANCE};
        this.comparator = new TupleComparator(new int[]{0}, comparators, comparatorSerializers);
        this.probeComparator = new LongComparator(true);
        this.pairComparator = new TypePairComparator<Long, Tuple2<Long, String>>(){
            private long ref;

            public void setReference(Long reference) {
                this.ref = reference;
            }

            public boolean equalToReference(Tuple2<Long, String> candidate) {
                return (Long)candidate.f0 == this.ref;
            }

            public int compareToReference(Tuple2<Long, String> candidate) {
                long x = this.ref;
                long y = (Long)candidate.f0;
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        };
    }

    @Test
    public void testHashTableGrowthWithInsert() {
        try {
            Tuple2 next;
            int numElements = 1000000;
            List<MemorySegment> memory = CompactingHashTableTest.getMemory(10000, 32768);
            CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, memory, 10000);
            table.open();
            for (long i = 0L; i < 1000000L; ++i) {
                table.insert((Object)new Tuple2((Object)i, (Object)String.valueOf(i)));
            }
            BitSet bitSet = new BitSet(1000000);
            MutableObjectIterator iter = table.getEntryIterator();
            while ((next = (Tuple2)iter.next()) != null) {
                Assert.assertNotNull((Object)next.f0);
                Assert.assertNotNull((Object)next.f1);
                Assert.assertEquals((long)((Long)next.f0), (long)Long.parseLong((String)next.f1));
                bitSet.set(((Long)next.f0).intValue());
            }
            Assert.assertEquals((long)1000000L, (long)bitSet.cardinality());
            CompactingHashTable.HashTableProber proper = table.getProber(this.probeComparator, this.pairComparator);
            for (long i = 0L; i < 1000000L; ++i) {
                Assert.assertNotNull((Object)proper.getMatchFor((Object)i));
                Assert.assertNull((Object)proper.getMatchFor((Object)(i + 1000000L)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testHashTableGrowthWithInsertOrReplace() {
        try {
            Tuple2 next;
            int numElements = 1000000;
            List<MemorySegment> memory = CompactingHashTableTest.getMemory(10000, 32768);
            CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, memory, 10000);
            table.open();
            for (long i = 0L; i < 1000000L; ++i) {
                table.insertOrReplaceRecord((Object)new Tuple2((Object)i, (Object)String.valueOf(i)));
            }
            BitSet bitSet = new BitSet(1000000);
            MutableObjectIterator iter = table.getEntryIterator();
            while ((next = (Tuple2)iter.next()) != null) {
                Assert.assertNotNull((Object)next.f0);
                Assert.assertNotNull((Object)next.f1);
                Assert.assertEquals((long)((Long)next.f0), (long)Long.parseLong((String)next.f1));
                bitSet.set(((Long)next.f0).intValue());
            }
            Assert.assertEquals((long)1000000L, (long)bitSet.cardinality());
            CompactingHashTable.HashTableProber proper = table.getProber(this.probeComparator, this.pairComparator);
            for (long i = 0L; i < 1000000L; ++i) {
                Assert.assertNotNull((Object)proper.getMatchFor((Object)i));
                Assert.assertNull((Object)proper.getMatchFor((Object)(i + 1000000L)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInsertsWithInsertOrReplace() {
        try {
            long i;
            int numElements = 1000;
            String longString = CompactingHashTableTest.getLongString(10000);
            List<MemorySegment> memory = CompactingHashTableTest.getMemory(1000, 32768);
            CompactingHashTable table = new CompactingHashTable(this.serializer, this.comparator, memory, 100);
            table.open();
            for (i = 0L; i < 1000L; ++i) {
                table.insertOrReplaceRecord((Object)new Tuple2((Object)i, (Object)longString));
            }
            for (i = 0L; i < 1000L; ++i) {
                table.insertOrReplaceRecord((Object)new Tuple2((Object)i, (Object)longString));
            }
            for (i = 0L; i < 1000L; ++i) {
                table.insertOrReplaceRecord((Object)new Tuple2((Object)(i + 1000L), (Object)longString));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static List<MemorySegment> getMemory(int numSegments, int segmentSize) {
        ArrayList<MemorySegment> list = new ArrayList<MemorySegment>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            list.add(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize));
        }
        return list;
    }

    private static String getLongString(int length) {
        StringBuilder bld = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            bld.append('a');
        }
        return bld.toString();
    }
}

