/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.messages.checkpoint.NotifyCheckpointComplete;
import org.apache.flink.runtime.messages.checkpoint.TriggerCheckpoint;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointMessagesTest {
    @Test
    public void testTriggerAndConfirmCheckpoint() {
        try {
            NotifyCheckpointComplete cc = new NotifyCheckpointComplete(new JobID(), new ExecutionAttemptID(), 45287698767345L, 467L);
            CheckpointMessagesTest.testSerializabilityEqualsHashCode((Serializable)cc);
            TriggerCheckpoint tc = new TriggerCheckpoint(new JobID(), new ExecutionAttemptID(), 347652734L, 7576752L);
            CheckpointMessagesTest.testSerializabilityEqualsHashCode((Serializable)tc);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConfirmTaskCheckpointed() {
        try {
            AcknowledgeCheckpoint noState = new AcknowledgeCheckpoint(new JobID(), new ExecutionAttemptID(), 569345L);
            AcknowledgeCheckpoint withState = new AcknowledgeCheckpoint(new JobID(), new ExecutionAttemptID(), 87658976143L, new SerializedValue((Object)new MyHandle()));
            CheckpointMessagesTest.testSerializabilityEqualsHashCode((Serializable)noState);
            CheckpointMessagesTest.testSerializabilityEqualsHashCode((Serializable)withState);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void testSerializabilityEqualsHashCode(Serializable o) throws IOException {
        Serializable copy = CommonTestUtils.createCopySerializable((Serializable)o);
        Assert.assertEquals((Object)o, (Object)copy);
        Assert.assertEquals((long)o.hashCode(), (long)copy.hashCode());
        Assert.assertNotNull((Object)o.toString());
        Assert.assertNotNull((Object)copy.toString());
    }

    public static class MyHandle
    implements StateHandle<Serializable> {
        private static final long serialVersionUID = 8128146204128728332L;

        public Serializable getState(ClassLoader userCodeClassLoader) {
            return null;
        }

        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public void discardState() throws Exception {
        }
    }
}

