/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingContender;
import org.apache.flink.runtime.leaderelection.ZooKeeperLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.org.apache.curator.test.TestingServer;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;

public class ZooKeeperLeaderRetrievalTest
extends TestLogger {
    private TestingServer testingServer;

    @Before
    public void before() {
        try {
            this.testingServer = new TestingServer();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start ZooKeeper testing cluster.", e);
        }
    }

    @After
    public void after() {
        if (this.testingServer != null) {
            try {
                this.testingServer.stop();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not stop ZooKeeper testing cluster.", e);
            }
            this.testingServer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testConnectingAddressRetrievalWithDelayedLeaderElection() throws Exception {
        block20: {
            FiniteDuration timeout = new FiniteDuration(1L, TimeUnit.MINUTES);
            Configuration config = new Configuration();
            long sleepingTime = 1000L;
            config.setString("recovery.mode", "zookeeper");
            config.setString("recovery.zookeeper.quorum", this.testingServer.getConnectString());
            ZooKeeperLeaderElectionService leaderElectionService = null;
            CuratorFramework[] client = new CuratorFramework[2];
            try {
                ServerSocket serverSocket;
                InetAddress localHost;
                client[0] = ZooKeeperUtils.startCuratorFramework((Configuration)config);
                client[1] = ZooKeeperUtils.startCuratorFramework((Configuration)config);
                InetSocketAddress wrongInetSocketAddress = new InetSocketAddress(InetAddress.getByName("1.1.1.1"), 1234);
                String wrongAddress = JobManager.getRemoteJobManagerAkkaURL((InetSocketAddress)wrongInetSocketAddress, (Option)Option.empty());
                try {
                    localHost = InetAddress.getLocalHost();
                    serverSocket = new ServerSocket(0, 50, localHost);
                }
                catch (UnknownHostException e) {
                    System.err.println("Skipping 'testNetworkInterfaceSelection' test.");
                    if (leaderElectionService != null) {
                        leaderElectionService.stop();
                    }
                    if (client[0] != null) {
                        client[0].close();
                    }
                    if (client[1] != null) {
                        client[1].close();
                    }
                    return;
                }
                catch (IOException e) {
                    block19: {
                        System.err.println("Skipping 'testNetworkInterfaceSelection' test.");
                        if (leaderElectionService == null) break block19;
                        leaderElectionService.stop();
                    }
                    if (client[0] != null) {
                        client[0].close();
                    }
                    if (client[1] != null) {
                        client[1].close();
                    }
                    return;
                }
                InetSocketAddress correctInetSocketAddress = new InetSocketAddress(localHost, serverSocket.getLocalPort());
                String correctAddress = JobManager.getRemoteJobManagerAkkaURL((InetSocketAddress)correctInetSocketAddress, (Option)Option.empty());
                ZooKeeperLeaderElectionService faultyLeaderElectionService = ZooKeeperUtils.createLeaderElectionService((CuratorFramework)client[0], (Configuration)config);
                TestingContender wrongLeaderAddressContender = new TestingContender(wrongAddress, (LeaderElectionService)faultyLeaderElectionService);
                faultyLeaderElectionService.start((LeaderContender)wrongLeaderAddressContender);
                FindConnectingAddress findConnectingAddress = new FindConnectingAddress(config, timeout);
                Thread thread = new Thread(findConnectingAddress);
                thread.start();
                leaderElectionService = ZooKeeperUtils.createLeaderElectionService((CuratorFramework)client[1], (Configuration)config);
                TestingContender correctLeaderAddressContender = new TestingContender(correctAddress, (LeaderElectionService)leaderElectionService);
                Thread.sleep(sleepingTime);
                faultyLeaderElectionService.stop();
                leaderElectionService.start((LeaderContender)correctLeaderAddressContender);
                thread.join();
                InetAddress result = findConnectingAddress.getInetAddress();
                try (Socket socket = new Socket();){
                    InetSocketAddress bindP = new InetSocketAddress(result, 0);
                    socket.bind(bindP);
                    socket.connect(correctInetSocketAddress, 1000);
                    break block20;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (leaderElectionService != null) {
                    leaderElectionService.stop();
                }
                if (client[0] != null) {
                    client[0].close();
                }
                if (client[1] != null) {
                    client[1].close();
                }
            }
        }
    }

    @Test
    public void testTimeoutOfFindConnectingAddress() throws Exception {
        Configuration config = new Configuration();
        config.setString("recovery.mode", "zookeeper");
        config.setString("recovery.zookeeper.quorum", this.testingServer.getConnectString());
        FiniteDuration timeout = new FiniteDuration(10L, TimeUnit.SECONDS);
        LeaderRetrievalService leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService((Configuration)config);
        InetAddress result = LeaderRetrievalUtils.findConnectingAddress((LeaderRetrievalService)leaderRetrievalService, (FiniteDuration)timeout);
        Assert.assertEquals((Object)InetAddress.getLocalHost(), (Object)result);
    }

    class FindConnectingAddress
    implements Runnable {
        private final Configuration config;
        private final FiniteDuration timeout;
        private InetAddress result;
        private Exception exception;

        public FindConnectingAddress(Configuration config, FiniteDuration timeout) {
            this.config = config;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                LeaderRetrievalService leaderRetrievalService = LeaderRetrievalUtils.createLeaderRetrievalService((Configuration)this.config);
                this.result = LeaderRetrievalUtils.findConnectingAddress((LeaderRetrievalService)leaderRetrievalService, (FiniteDuration)this.timeout);
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public InetAddress getInetAddress() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }
}

