/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestUtils;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.AbstractID;
import org.junit.Assert;
import org.junit.Test;
import scala.concurrent.ExecutionContext;

public class ScheduleWithCoLocationHintTest {
    @Test
    public void scheduleAllSharedAndCoLocated() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(2));
            Assert.assertEquals((long)6L, (long)scheduler.getNumberOfAvailableSlots());
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            CoLocationGroup ccg = new CoLocationGroup();
            CoLocationConstraint c1 = new CoLocationConstraint(ccg);
            CoLocationConstraint c2 = new CoLocationConstraint(ccg);
            CoLocationConstraint c3 = new CoLocationConstraint(ccg);
            CoLocationConstraint c4 = new CoLocationConstraint(ccg);
            CoLocationConstraint c5 = new CoLocationConstraint(ccg);
            CoLocationConstraint c6 = new CoLocationConstraint(ccg);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 6), sharingGroup, c1));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 6), sharingGroup, c2));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 6), sharingGroup, c3));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 6), sharingGroup, c4));
            SimpleSlot s5 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 6), sharingGroup, c1));
            SimpleSlot s6 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 6), sharingGroup, c2));
            SimpleSlot s7 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 6), sharingGroup, c3));
            SimpleSlot s8 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 4, 6), sharingGroup, c5));
            SimpleSlot s9 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 5, 6), sharingGroup, c6));
            SimpleSlot s10 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 6), sharingGroup, c4));
            SimpleSlot s11 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 4, 6), sharingGroup, c5));
            SimpleSlot s12 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 5, 6), sharingGroup, c6));
            Assert.assertNotNull((Object)s1);
            Assert.assertNotNull((Object)s2);
            Assert.assertNotNull((Object)s3);
            Assert.assertNotNull((Object)s4);
            Assert.assertNotNull((Object)s5);
            Assert.assertNotNull((Object)s6);
            Assert.assertNotNull((Object)s7);
            Assert.assertNotNull((Object)s8);
            Assert.assertNotNull((Object)s9);
            Assert.assertNotNull((Object)s10);
            Assert.assertNotNull((Object)s11);
            Assert.assertNotNull((Object)s12);
            Assert.assertEquals((long)2L, (long)s1.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s2.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s3.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s4.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s5.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s6.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s7.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s8.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s9.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s10.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s11.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s12.getRoot().getNumberLeaves());
            Assert.assertEquals((Object)s1.getInstance(), (Object)s5.getInstance());
            Assert.assertEquals((Object)s2.getInstance(), (Object)s6.getInstance());
            Assert.assertEquals((Object)s3.getInstance(), (Object)s7.getInstance());
            Assert.assertEquals((Object)s4.getInstance(), (Object)s10.getInstance());
            Assert.assertEquals((Object)s8.getInstance(), (Object)s11.getInstance());
            Assert.assertEquals((Object)s9.getInstance(), (Object)s12.getInstance());
            Assert.assertEquals((Object)c1.getLocation(), (Object)s1.getInstance());
            Assert.assertEquals((Object)c2.getLocation(), (Object)s2.getInstance());
            Assert.assertEquals((Object)c3.getLocation(), (Object)s3.getInstance());
            Assert.assertEquals((Object)c4.getLocation(), (Object)s4.getInstance());
            Assert.assertEquals((Object)c5.getLocation(), (Object)s8.getInstance());
            Assert.assertEquals((Object)c6.getLocation(), (Object)s9.getInstance());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)6L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)6L, (long)scheduler.getNumberOfUnconstrainedAssignments());
            s1.releaseSlot();
            s2.releaseSlot();
            s3.releaseSlot();
            s4.releaseSlot();
            s7.releaseSlot();
            s10.releaseSlot();
            s11.releaseSlot();
            s12.releaseSlot();
            Assert.assertTrue((scheduler.getNumberOfAvailableSlots() >= 1 ? 1 : 0) != 0);
            SimpleSlot single = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(new JobVertexID(), 0, 1)));
            Assert.assertNotNull((Object)single);
            s1.releaseSlot();
            s2.releaseSlot();
            s3.releaseSlot();
            s5.releaseSlot();
            s6.releaseSlot();
            s7.releaseSlot();
            s8.releaseSlot();
            s9.releaseSlot();
            s11.releaseSlot();
            s12.releaseSlot();
            Assert.assertEquals((long)5L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)6L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)7L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleWithIntermediateRelease() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            JobVertexID jid4 = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(1);
            Instance i2 = SchedulerTestUtils.getRandomInstance(1);
            scheduler.newInstanceAvailable(i1);
            scheduler.newInstanceAvailable(i2);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            CoLocationConstraint c1 = new CoLocationConstraint(new CoLocationGroup());
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 1), sharingGroup, c1));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 1), sharingGroup, c1));
            SimpleSlot sSolo = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 0, 1)));
            Instance loc = s1.getInstance();
            s1.releaseSlot();
            s2.releaseSlot();
            sSolo.releaseSlot();
            SimpleSlot sNew = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 1), sharingGroup, c1));
            Assert.assertEquals((Object)loc, (Object)sNew.getInstance());
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleWithReleaseNoResource() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(1);
            Instance i2 = SchedulerTestUtils.getRandomInstance(1);
            scheduler.newInstanceAvailable(i1);
            scheduler.newInstanceAvailable(i2);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            CoLocationConstraint c1 = new CoLocationConstraint(new CoLocationGroup());
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 1), sharingGroup, c1));
            s1.releaseSlot();
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 1)));
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 2)));
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 1), sharingGroup, c1));
                Assert.fail((String)"Scheduled even though no resource was available.");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)3L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void scheduleMixedCoLocationSlotSharing() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            JobVertexID jid4 = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(1));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(1));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(1));
            scheduler.newInstanceAvailable(SchedulerTestUtils.getRandomInstance(1));
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfAvailableSlots());
            CoLocationGroup grp = new CoLocationGroup();
            CoLocationConstraint clc1 = new CoLocationConstraint(grp);
            CoLocationConstraint clc2 = new CoLocationConstraint(grp);
            CoLocationConstraint clc3 = new CoLocationConstraint(grp);
            CoLocationConstraint clc4 = new CoLocationConstraint(grp);
            SlotSharingGroup shareGroup = new SlotSharingGroup();
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 0, 4), shareGroup));
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 2, 4), shareGroup));
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 1, 4), shareGroup));
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid1, 3, 4), shareGroup));
            SimpleSlot s21 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 0, 4), shareGroup, clc1));
            SimpleSlot s22 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 2, 4), shareGroup, clc2));
            SimpleSlot s23 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 1, 4), shareGroup, clc3));
            SimpleSlot s24 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid2, 3, 4), shareGroup, clc4));
            SimpleSlot s31 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 1, 4), shareGroup, clc2));
            SimpleSlot s32 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 2, 4), shareGroup, clc3));
            SimpleSlot s33 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 3, 4), shareGroup, clc4));
            SimpleSlot s34 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid3, 0, 4), shareGroup, clc1));
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 0, 4), shareGroup));
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 1, 4), shareGroup));
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 2, 4), shareGroup));
            scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertex(jid4, 3, 4), shareGroup));
            Assert.assertEquals((Object)s21.getInstance(), (Object)s34.getInstance());
            Assert.assertEquals((Object)s22.getInstance(), (Object)s31.getInstance());
            Assert.assertEquals((Object)s23.getInstance(), (Object)s32.getInstance());
            Assert.assertEquals((Object)s24.getInstance(), (Object)s33.getInstance());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)12L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetsNonLocalFromSharingGroupFirst() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jid3 = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(1);
            Instance i2 = SchedulerTestUtils.getRandomInstance(1);
            scheduler.newInstanceAvailable(i2);
            scheduler.newInstanceAvailable(i1);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            CoLocationGroup ccg = new CoLocationGroup();
            CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
            CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, i1), sharingGroup));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, i2), sharingGroup));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, i1), sharingGroup, cc1));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 2, i1), sharingGroup, cc2));
            SimpleSlot s5 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid3, 0, 2, i2), sharingGroup, cc1));
            SimpleSlot s6 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid3, 1, 2, i1), sharingGroup, cc2));
            Assert.assertEquals((long)3L, (long)s1.getRoot().getNumberLeaves());
            Assert.assertEquals((long)3L, (long)s2.getRoot().getNumberLeaves());
            Assert.assertEquals((Object)s1.getInstance(), (Object)s3.getInstance());
            Assert.assertEquals((Object)s2.getInstance(), (Object)s4.getInstance());
            Assert.assertEquals((Object)s1.getInstance(), (Object)s5.getInstance());
            Assert.assertEquals((Object)s2.getInstance(), (Object)s6.getInstance());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)5L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)1L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfUnconstrainedAssignments());
            s1.releaseSlot();
            s2.releaseSlot();
            s3.releaseSlot();
            s4.releaseSlot();
            s5.releaseSlot();
            s6.releaseSlot();
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSlotReleasedInBetween() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(1);
            Instance i2 = SchedulerTestUtils.getRandomInstance(1);
            scheduler.newInstanceAvailable(i2);
            scheduler.newInstanceAvailable(i1);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            CoLocationGroup ccg = new CoLocationGroup();
            CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
            CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, i1), sharingGroup, cc1));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, i2), sharingGroup, cc2));
            s1.releaseSlot();
            s2.releaseSlot();
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, i2), sharingGroup, cc1));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 2, i1), sharingGroup, cc2));
            Assert.assertEquals((Object)i1, (Object)s3.getInstance());
            Assert.assertEquals((Object)i2, (Object)s4.getInstance());
            s3.releaseSlot();
            s4.releaseSlot();
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)4L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSlotReleasedInBetweenAndNoNewLocal() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            JobVertexID jidx = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(1);
            Instance i2 = SchedulerTestUtils.getRandomInstance(1);
            scheduler.newInstanceAvailable(i2);
            scheduler.newInstanceAvailable(i1);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            CoLocationGroup ccg = new CoLocationGroup();
            CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
            CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, i1), sharingGroup, cc1));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, i2), sharingGroup, cc2));
            s1.releaseSlot();
            s2.releaseSlot();
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            SimpleSlot sa = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jidx, 0, 2, new Instance[0])));
            SimpleSlot sb = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jidx, 1, 2, new Instance[0])));
            try {
                scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, i2), sharingGroup, cc1));
                Assert.fail((String)"should not be able to find a resource");
            }
            catch (NoResourceAvailableException noResourceAvailableException) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception");
            }
            sa.releaseSlot();
            sb.releaseSlot();
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfUnconstrainedAssignments());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testScheduleOutOfOrder() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(1);
            Instance i2 = SchedulerTestUtils.getRandomInstance(1);
            scheduler.newInstanceAvailable(i2);
            scheduler.newInstanceAvailable(i1);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            CoLocationGroup ccg = new CoLocationGroup();
            CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
            CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, i1), sharingGroup, cc1));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, i1), sharingGroup, cc2));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 2, i1), sharingGroup, cc1));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, i1), sharingGroup, cc2));
            Assert.assertEquals((long)2L, (long)s1.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s2.getRoot().getNumberLeaves());
            Assert.assertEquals((Object)s1.getInstance(), (Object)s3.getInstance());
            Assert.assertEquals((Object)s2.getInstance(), (Object)s4.getInstance());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)3L, (long)scheduler.getNumberOfLocalizedAssignments());
            Assert.assertEquals((long)1L, (long)scheduler.getNumberOfNonLocalizedAssignments());
            Assert.assertEquals((long)0L, (long)scheduler.getNumberOfUnconstrainedAssignments());
            s1.releaseSlot();
            s2.releaseSlot();
            s3.releaseSlot();
            s4.releaseSlot();
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void nonColocationFollowsCoLocation() {
        try {
            JobVertexID jid1 = new JobVertexID();
            JobVertexID jid2 = new JobVertexID();
            Scheduler scheduler = new Scheduler((ExecutionContext)TestingUtils.directExecutionContext());
            Instance i1 = SchedulerTestUtils.getRandomInstance(1);
            Instance i2 = SchedulerTestUtils.getRandomInstance(1);
            scheduler.newInstanceAvailable(i2);
            scheduler.newInstanceAvailable(i1);
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            SlotSharingGroup sharingGroup = new SlotSharingGroup();
            CoLocationGroup ccg = new CoLocationGroup();
            CoLocationConstraint cc1 = new CoLocationConstraint(ccg);
            CoLocationConstraint cc2 = new CoLocationConstraint(ccg);
            SimpleSlot s1 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 0, 2, i1), sharingGroup, cc1));
            SimpleSlot s2 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid1, 1, 2, i2), sharingGroup, cc2));
            SimpleSlot s3 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 0, 2, i1), sharingGroup));
            SimpleSlot s4 = scheduler.scheduleImmediately(new ScheduledUnit(SchedulerTestUtils.getTestVertexWithLocation(jid2, 1, 2, i1), sharingGroup));
            Assert.assertEquals((long)2L, (long)s1.getRoot().getNumberLeaves());
            Assert.assertEquals((long)2L, (long)s2.getRoot().getNumberLeaves());
            s1.releaseSlot();
            s2.releaseSlot();
            s3.releaseSlot();
            s4.releaseSlot();
            Assert.assertEquals((long)2L, (long)scheduler.getNumberOfAvailableSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfSlots());
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid1));
            Assert.assertEquals((long)0L, (long)sharingGroup.getTaskAssignment().getNumberOfAvailableSlotsForGroup((AbstractID)jid2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

