/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import java.net.InetAddress;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.akka.ListeningBehaviour;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.AkkaActorGateway;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.Tasks;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.TaskMessages;
import org.apache.flink.runtime.testingUtils.TestingCluster;
import org.apache.flink.runtime.testingUtils.TestingJobManagerMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public class JobManagerTest {
    private static ActorSystem system;

    @BeforeClass
    public static void setup() {
        system = AkkaUtils.createLocalActorSystem((Configuration)new Configuration());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
    }

    @Test
    public void testNullHostnameGoesToLocalhost() {
        try {
            Tuple2 address = new Tuple2(null, (Object)1772);
            Config cfg = AkkaUtils.getAkkaConfig((Configuration)new Configuration(), (Option)new Some((Object)address));
            String hostname = cfg.getString("akka.remote.netty.tcp.hostname");
            Assert.assertTrue((boolean)InetAddress.getByName(hostname).isLoopbackAddress());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRequestPartitionState() throws Exception {
        new JavaTestKit(system){
            {
                TestingCluster cluster = null;
                try {
                    cluster = TestingUtils.startTestingCluster(2, 1, TestingUtils.DEFAULT_AKKA_ASK_TIMEOUT());
                    IntermediateDataSetID rid = new IntermediateDataSetID();
                    JobVertex sender = new JobVertex("Sender");
                    sender.setParallelism(1);
                    sender.setInvokableClass(Tasks.BlockingNoOpInvokable.class);
                    sender.createAndAddResultDataSet(rid, ResultPartitionType.PIPELINED);
                    JobGraph jobGraph = new JobGraph("Blocking test job", new JobVertex[]{sender});
                    JobID jid = jobGraph.getJobID();
                    ActorGateway jobManagerGateway = cluster.getLeaderGateway(TestingUtils.TESTING_DURATION());
                    AkkaActorGateway testActorGateway = new AkkaActorGateway(this.getTestActor(), null);
                    jobManagerGateway.tell((Object)new JobManagerMessages.SubmitJob(jobGraph, ListeningBehaviour.EXECUTION_RESULT), (ActorGateway)testActorGateway);
                    this.expectMsgClass(JobManagerMessages.JobSubmitSuccess.class);
                    jobManagerGateway.tell((Object)new TestingJobManagerMessages.WaitForAllVerticesToBeRunningOrFinished(jobGraph.getJobID()), (ActorGateway)testActorGateway);
                    this.expectMsgClass(TestingJobManagerMessages.AllVerticesRunning.class);
                    ExecutionAttemptID receiver = new ExecutionAttemptID();
                    jobManagerGateway.tell((Object)new TestingJobManagerMessages.RequestExecutionGraph(jid), (ActorGateway)testActorGateway);
                    ExecutionGraph eg = ((TestingJobManagerMessages.ExecutionGraphFound)this.expectMsgClass(TestingJobManagerMessages.ExecutionGraphFound.class)).executionGraph();
                    ExecutionVertex vertex = eg.getJobVertex(sender.getID()).getTaskVertices()[0];
                    IntermediateResultPartition partition = (IntermediateResultPartition)vertex.getProducedPartitions().values().iterator().next();
                    ResultPartitionID partitionId = new ResultPartitionID(partition.getPartitionId(), vertex.getCurrentExecutionAttempt().getAttemptId());
                    JobManagerMessages.RequestPartitionState request = new JobManagerMessages.RequestPartitionState(jid, partitionId, receiver, rid);
                    for (ExecutionState state : ExecutionState.values()) {
                        ExecutionGraphTestUtils.setVertexState(vertex, state);
                        jobManagerGateway.tell((Object)request, (ActorGateway)testActorGateway);
                        JobManagerMessages.LeaderSessionMessage lsm = (JobManagerMessages.LeaderSessionMessage)this.expectMsgClass(JobManagerMessages.LeaderSessionMessage.class);
                        Assert.assertEquals(TaskMessages.PartitionState.class, lsm.message().getClass());
                        TaskMessages.PartitionState resp = (TaskMessages.PartitionState)lsm.message();
                        Assert.assertEquals((Object)request.taskExecutionId(), (Object)resp.taskExecutionId());
                        Assert.assertEquals((Object)request.taskResultId(), (Object)resp.taskResultId());
                        Assert.assertEquals((Object)request.partitionId().getPartitionId(), (Object)resp.partitionId());
                        Assert.assertEquals((Object)state, (Object)resp.state());
                    }
                    request = new JobManagerMessages.RequestPartitionState(jid, new ResultPartitionID(), receiver, rid);
                    jobManagerGateway.tell((Object)request, (ActorGateway)testActorGateway);
                    JobManagerMessages.LeaderSessionMessage lsm = (JobManagerMessages.LeaderSessionMessage)this.expectMsgClass(JobManagerMessages.LeaderSessionMessage.class);
                    Assert.assertEquals(TaskMessages.PartitionState.class, lsm.message().getClass());
                    TaskMessages.PartitionState resp = (TaskMessages.PartitionState)lsm.message();
                    Assert.assertEquals((Object)request.taskExecutionId(), (Object)resp.taskExecutionId());
                    Assert.assertEquals((Object)request.taskResultId(), (Object)resp.taskResultId());
                    Assert.assertEquals((Object)request.partitionId().getPartitionId(), (Object)resp.partitionId());
                    Assert.assertNull((Object)resp.state());
                    request = new JobManagerMessages.RequestPartitionState(new JobID(), new ResultPartitionID(), receiver, rid);
                    jobManagerGateway.tell((Object)request, (ActorGateway)testActorGateway);
                    lsm = (JobManagerMessages.LeaderSessionMessage)this.expectMsgClass(JobManagerMessages.LeaderSessionMessage.class);
                    Assert.assertEquals(TaskMessages.PartitionState.class, lsm.message().getClass());
                    resp = (TaskMessages.PartitionState)lsm.message();
                    Assert.assertEquals((Object)request.taskExecutionId(), (Object)resp.taskExecutionId());
                    Assert.assertEquals((Object)request.taskResultId(), (Object)resp.taskResultId());
                    Assert.assertEquals((Object)request.partitionId().getPartitionId(), (Object)resp.partitionId());
                    Assert.assertNull((Object)resp.state());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
                finally {
                    if (cluster != null) {
                        cluster.shutdown();
                    }
                }
            }
        };
    }
}

