/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewAsyncIO;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewTest;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.runtime.io.network.util.TestInfiniteBufferProvider;
import org.apache.flink.runtime.io.network.util.TestPooledBufferProvider;
import org.apache.flink.runtime.io.network.util.TestSubpartitionConsumer;
import org.junit.AfterClass;
import org.junit.Test;
import org.mockito.Mockito;

public class SpilledSubpartitionViewAsyncIOTest {
    private static final IOManager ioManager = new IOManagerAsync();

    @AfterClass
    public static void shutdown() {
        ioManager.shutdown();
    }

    @Test
    public void testWriteConsume() throws Exception {
        int numberOfBuffersToWrite = 1024;
        BufferFileWriter writer = SpilledSubpartitionViewTest.createWriterAndWriteBuffers(ioManager, new TestInfiniteBufferProvider(), 1024);
        writer.close();
        TestPooledBufferProvider viewBufferPool = new TestPooledBufferProvider(1);
        SpilledSubpartitionViewAsyncIO view = new SpilledSubpartitionViewAsyncIO((ResultSubpartition)Mockito.mock(ResultSubpartition.class), (BufferProvider)viewBufferPool, ioManager, writer.getChannelID(), 0L);
        TestSubpartitionConsumer consumer = new TestSubpartitionConsumer((ResultSubpartitionView)view, false, new TestConsumerCallback.RecyclingCallback());
        consumer.call();
    }
}

