/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.netty.NettyClient;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyServer;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.NetUtils;
import scala.Tuple2;

public class NettyTestUtil {
    static int DEFAULT_SEGMENT_SIZE = 1024;

    static NettyServer initServer(NettyConfig config, NettyProtocol protocol) throws Exception {
        NettyServer server = new NettyServer(config);
        try {
            server.init(protocol);
        }
        catch (Exception e) {
            server.shutdown();
            throw e;
        }
        return server;
    }

    static NettyClient initClient(NettyConfig config, NettyProtocol protocol) throws Exception {
        NettyClient client = new NettyClient(config);
        try {
            client.init(protocol);
        }
        catch (Exception e) {
            client.shutdown();
            throw e;
        }
        return client;
    }

    static NettyServerAndClient initServerAndClient(NettyProtocol protocol) throws Exception {
        return NettyTestUtil.initServerAndClient(protocol, NettyTestUtil.createConfig());
    }

    static NettyServerAndClient initServerAndClient(NettyProtocol protocol, NettyConfig config) throws Exception {
        NettyClient client = NettyTestUtil.initClient(config, protocol);
        NettyServer server = NettyTestUtil.initServer(config, protocol);
        return new NettyServerAndClient(server, client);
    }

    static Channel connect(NettyServerAndClient serverAndClient) throws Exception {
        return NettyTestUtil.connect(serverAndClient.client(), serverAndClient.server());
    }

    static Channel connect(NettyClient client, NettyServer server) throws Exception {
        NettyConfig config = server.getConfig();
        return client.connect((SocketAddress)new InetSocketAddress(config.getServerAddress(), config.getServerPort())).sync().channel();
    }

    static void awaitClose(Channel ch) throws InterruptedException {
        while (ch.isActive()) {
            ch.closeFuture().await(1L, TimeUnit.SECONDS);
        }
    }

    static void shutdown(NettyServerAndClient serverAndClient) {
        if (serverAndClient != null) {
            if (serverAndClient.server() != null) {
                serverAndClient.server().shutdown();
            }
            if (serverAndClient.client() != null) {
                serverAndClient.client().shutdown();
            }
        }
    }

    static NettyConfig createConfig() throws Exception {
        return NettyTestUtil.createConfig(DEFAULT_SEGMENT_SIZE, new Configuration());
    }

    static NettyConfig createConfig(int segmentSize) throws Exception {
        return NettyTestUtil.createConfig(segmentSize, new Configuration());
    }

    static NettyConfig createConfig(Configuration config) throws Exception {
        return NettyTestUtil.createConfig(DEFAULT_SEGMENT_SIZE, config);
    }

    static NettyConfig createConfig(int segmentSize, Configuration config) throws Exception {
        Preconditions.checkArgument((segmentSize > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)config);
        return new NettyConfig(InetAddress.getLocalHost(), NetUtils.getAvailablePort(), segmentSize, config);
    }

    static class NettyServerAndClient
    extends Tuple2<NettyServer, NettyClient> {
        private static final long serialVersionUID = 4440278728496341931L;

        NettyServerAndClient(NettyServer _1, NettyClient _2) {
            super((Object)_1, (Object)_2);
        }

        NettyServer server() {
            return (NettyServer)this._1();
        }

        NettyClient client() {
            return (NettyClient)this._2();
        }

        public boolean canEqual(Object that) {
            return false;
        }

        public boolean equals(Object that) {
            return false;
        }
    }
}

