/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class NettyServerLowAndHighWatermarkTest {
    private static final int PageSize = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLowAndHighWatermarks() throws Throwable {
        final AtomicReference error = new AtomicReference();
        NettyProtocol protocol = new NettyProtocol(){

            public ChannelHandler[] getServerChannelHandlers() {
                return new ChannelHandler[]{new TestLowAndHighWatermarkHandler(error)};
            }

            public ChannelHandler[] getClientChannelHandlers() {
                return new ChannelHandler[0];
            }
        };
        NettyConfig conf = NettyTestUtil.createConfig(1024);
        NettyTestUtil.NettyServerAndClient serverAndClient = NettyTestUtil.initServerAndClient(protocol, conf);
        try {
            Channel ch = NettyTestUtil.connect(serverAndClient);
            NettyTestUtil.awaitClose(ch);
            Throwable t = (Throwable)error.get();
            if (t != null) {
                throw t;
            }
        }
        finally {
            NettyTestUtil.shutdown(serverAndClient);
        }
    }

    private static ByteBuf buffer() {
        return NettyServerLowAndHighWatermarkTest.buffer(1024);
    }

    private static ByteBuf buffer(int size) {
        return Unpooled.buffer((int)size).writerIndex(size);
    }

    private static class TestLowAndHighWatermarkHandler
    extends ChannelInboundHandlerAdapter {
        private final AtomicReference<Throwable> error;
        private boolean hasFlushed;

        public TestLowAndHighWatermarkHandler(AtomicReference<Throwable> error) {
            this.error = error;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            Channel ch = ctx.channel();
            Assert.assertTrue((boolean)ch.isWritable());
            ch.write((Object)NettyServerLowAndHighWatermarkTest.buffer());
            Assert.assertTrue((boolean)ch.isWritable());
            ch.write((Object)NettyServerLowAndHighWatermarkTest.buffer());
            Assert.assertFalse((boolean)ch.isWritable());
            this.hasFlushed = true;
            ch.flush();
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            if (this.hasFlushed) {
                Assert.assertTrue((boolean)ctx.channel().isWritable());
                ctx.close();
            }
            super.channelWritabilityChanged(ctx);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.error.get() == null) {
                this.error.set(cause);
            }
            ctx.close();
            super.exceptionCaught(ctx, cause);
        }
    }
}

