/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;

public class UnsignedByteType
implements SerializationTestType {
    private int value;

    public UnsignedByteType() {
        this.value = 0;
    }

    private UnsignedByteType(int value) {
        this.value = value;
    }

    @Override
    public UnsignedByteType getRandom(Random rnd) {
        return new UnsignedByteType(rnd.nextInt(128) + 128);
    }

    @Override
    public int length() {
        return 1;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeByte(this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readUnsignedByte();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsignedByteType) {
            UnsignedByteType other = (UnsignedByteType)obj;
            return this.value == other.value;
        }
        return false;
    }
}

