/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.util.ArrayDeque;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.api.serialization.AdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestType;
import org.apache.flink.runtime.io.network.api.serialization.types.SerializationTestTypeFactory;
import org.apache.flink.runtime.io.network.api.serialization.types.Util;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SpanningRecordSerializationTest {
    @Test
    public void testIntRecordsSpanningMultipleSegments() {
        boolean SEGMENT_SIZE = true;
        int NUM_VALUES = 10;
        try {
            this.testNonSpillingDeserializer(Util.randomRecords(10, SerializationTestTypeFactory.INT), 1);
            this.testSpillingDeserializer(Util.randomRecords(10, SerializationTestTypeFactory.INT), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testIntRecordsWithAlignedBuffers() {
        int SEGMENT_SIZE = 64;
        int NUM_VALUES = 64;
        try {
            this.testNonSpillingDeserializer(Util.randomRecords(64, SerializationTestTypeFactory.INT), 64);
            this.testSpillingDeserializer(Util.randomRecords(64, SerializationTestTypeFactory.INT), 64);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testIntRecordsWithUnalignedBuffers() {
        int SEGMENT_SIZE = 31;
        int NUM_VALUES = 248;
        try {
            this.testNonSpillingDeserializer(Util.randomRecords(248, SerializationTestTypeFactory.INT), 31);
            this.testSpillingDeserializer(Util.randomRecords(248, SerializationTestTypeFactory.INT), 31);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    @Test
    public void testRandomRecords() {
        int SEGMENT_SIZE = 127;
        int NUM_VALUES = 10000;
        try {
            this.testNonSpillingDeserializer(Util.randomRecords(10000), 127);
            this.testSpillingDeserializer(Util.randomRecords(10000), 127);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test encountered an unexpected exception.");
        }
    }

    private void testNonSpillingDeserializer(Util.MockRecords records, int segmentSize) throws Exception {
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        AdaptiveSpanningRecordDeserializer deserializer = new AdaptiveSpanningRecordDeserializer();
        this.test(records, segmentSize, (RecordSerializer<SerializationTestType>)serializer, (RecordDeserializer<SerializationTestType>)deserializer);
    }

    private void testSpillingDeserializer(Util.MockRecords records, int segmentSize) throws Exception {
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        SpillingAdaptiveSpanningRecordDeserializer deserializer = new SpillingAdaptiveSpanningRecordDeserializer();
        this.test(records, segmentSize, (RecordSerializer<SerializationTestType>)serializer, (RecordDeserializer<SerializationTestType>)deserializer);
    }

    private void test(Util.MockRecords records, int segmentSize, RecordSerializer<SerializationTestType> serializer, RecordDeserializer<SerializationTestType> deserializer) throws Exception {
        int SERIALIZATION_OVERHEAD = 4;
        Buffer buffer = new Buffer(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize), (BufferRecycler)Mockito.mock(BufferRecycler.class));
        ArrayDeque<SerializationTestType> serializedRecords = new ArrayDeque<SerializationTestType>();
        serializer.setNextBuffer(buffer);
        int numBytes = 0;
        int numRecords = 0;
        for (SerializationTestType record : records) {
            serializedRecords.add(record);
            ++numRecords;
            numBytes += record.length() + 4;
            if (!serializer.addRecord((IOReadableWritable)record).isFullBuffer()) continue;
            deserializer.setNextMemorySegment(serializer.getCurrentBuffer().getMemorySegment(), segmentSize);
            while (!serializedRecords.isEmpty()) {
                SerializationTestType expected = (SerializationTestType)serializedRecords.poll();
                SerializationTestType actual = (SerializationTestType)expected.getClass().newInstance();
                if (deserializer.getNextRecord((IOReadableWritable)actual).isFullRecord()) {
                    Assert.assertEquals((Object)expected, (Object)actual);
                    --numRecords;
                    continue;
                }
                serializedRecords.addFirst(expected);
                break;
            }
            while (serializer.setNextBuffer(buffer).isFullBuffer()) {
                deserializer.setNextMemorySegment(serializer.getCurrentBuffer().getMemorySegment(), segmentSize);
            }
        }
        deserializer.setNextMemorySegment(serializer.getCurrentBuffer().getMemorySegment(), numBytes % segmentSize);
        serializer.clear();
        while (!serializedRecords.isEmpty()) {
            SerializationTestType expected = (SerializationTestType)serializedRecords.poll();
            SerializationTestType actual = (SerializationTestType)expected.getClass().newInstance();
            RecordDeserializer.DeserializationResult result = deserializer.getNextRecord((IOReadableWritable)actual);
            Assert.assertTrue((boolean)result.isFullRecord());
            Assert.assertEquals((Object)expected, (Object)actual);
            --numRecords;
        }
        Assert.assertEquals((long)0L, (long)numRecords);
        Assert.assertFalse((boolean)serializer.hasData());
        Assert.assertFalse((boolean)deserializer.hasUnfinishedData());
    }
}

