/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.reader;

import java.io.IOException;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.reader.BufferReader;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.TestSingleInputGate;
import org.apache.flink.runtime.io.network.util.TestTaskEvent;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.util.event.EventListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Task.class})
public class BufferReaderTest {
    @Test
    public void testGetNextBufferOrEvent() throws IOException, InterruptedException {
        TestSingleInputGate inputGate = new TestSingleInputGate(1).readBuffer().readBuffer().readEvent().readBuffer().readBuffer().readEvent().readBuffer().readEndOfPartitionEvent();
        BufferReader reader = new BufferReader((InputGate)inputGate.getInputGate());
        EventListener listener = (EventListener)Mockito.mock(EventListener.class);
        reader.registerTaskEventListener(listener, TestTaskEvent.class);
        int numReadBuffers = 0;
        while (reader.getNextBuffer() != null) {
            ++numReadBuffers;
        }
        Assert.assertEquals((long)5L, (long)numReadBuffers);
        ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)2))).onEvent(Matchers.any(TaskEvent.class));
    }

    @Test
    public void testIterativeGetNextBufferOrEvent() throws IOException, InterruptedException {
        TestSingleInputGate inputGate = new TestSingleInputGate(1).readBuffer().readBuffer().readEvent().readBuffer().readBuffer().readEvent().readBuffer().readEndOfSuperstepEvent().readBuffer().readBuffer().readEvent().readBuffer().readBuffer().readEvent().readBuffer().readEndOfPartitionEvent();
        BufferReader reader = new BufferReader((InputGate)inputGate.getInputGate());
        reader.setIterativeReader();
        EventListener listener = (EventListener)Mockito.mock(EventListener.class);
        reader.registerTaskEventListener(listener, TestTaskEvent.class);
        int numReadBuffers = 0;
        int numEndOfSuperstepEvents = 0;
        while (true) {
            Buffer buffer;
            if ((buffer = reader.getNextBuffer()) != null) {
                ++numReadBuffers;
                continue;
            }
            if (reader.hasReachedEndOfSuperstep()) {
                reader.startNextSuperstep();
                ++numEndOfSuperstepEvents;
                continue;
            }
            if (reader.isFinished()) break;
        }
        Assert.assertEquals((long)10L, (long)numReadBuffers);
        Assert.assertEquals((long)1L, (long)numEndOfSuperstepEvents);
        ((EventListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.times((int)4))).onEvent(Matchers.any(TaskEvent.class));
    }
}

