/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.NetUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class NetworkEnvironmentTest {
    @Test
    public void testAssociateDisassociate() {
        int port;
        int BUFFER_SIZE = 1024;
        int NUM_BUFFERS = 20;
        try {
            port = NetUtils.getAvailablePort();
        }
        catch (Throwable t) {
            return;
        }
        try {
            NettyConfig nettyConf = new NettyConfig(InetAddress.getLocalHost(), port, 1024, new Configuration());
            NetworkEnvironmentConfiguration config = new NetworkEnvironmentConfiguration(20, 1024, MemoryType.HEAP, IOManager.IOMode.SYNC, (Option)new Some((Object)nettyConf), new Tuple2((Object)0, (Object)0));
            NetworkEnvironment env = new NetworkEnvironment((ExecutionContext)TestingUtils.defaultExecutionContext(), new FiniteDuration(30L, TimeUnit.SECONDS), config);
            Assert.assertFalse((boolean)env.isShutdown());
            Assert.assertFalse((boolean)env.isAssociated());
            Assert.assertNotNull((Object)env.getNetworkBufferPool());
            Assert.assertEquals((long)20L, (long)env.getNetworkBufferPool().getTotalNumberOfMemorySegments());
            Assert.assertNull((Object)env.getConnectionManager());
            Assert.assertNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNull((Object)env.getTaskEventDispatcher());
            Assert.assertNull((Object)env.getPartitionManager());
            env.associateWithTaskManagerAndJobManager((ActorGateway)DummyActorGateway.INSTANCE, (ActorGateway)DummyActorGateway.INSTANCE);
            Assert.assertNotNull((Object)env.getConnectionManager());
            Assert.assertNotNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNotNull((Object)env.getTaskEventDispatcher());
            Assert.assertNotNull((Object)env.getPartitionManager());
            BufferPool localPool = env.getNetworkBufferPool().createBufferPool(10, false);
            Assert.assertNotNull((Object)localPool);
            env.disassociate();
            Assert.assertNull((Object)env.getConnectionManager());
            Assert.assertNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNull((Object)env.getTaskEventDispatcher());
            Assert.assertNull((Object)env.getPartitionManager());
            Assert.assertNotNull((Object)env.getNetworkBufferPool());
            Assert.assertTrue((boolean)localPool.isDestroyed());
            env.associateWithTaskManagerAndJobManager((ActorGateway)DummyActorGateway.INSTANCE, (ActorGateway)DummyActorGateway.INSTANCE);
            Assert.assertNotNull((Object)env.getConnectionManager());
            Assert.assertNotNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNotNull((Object)env.getTaskEventDispatcher());
            Assert.assertNotNull((Object)env.getPartitionManager());
            env.shutdown();
            Assert.assertTrue((boolean)env.isShutdown());
            Assert.assertFalse((boolean)env.isAssociated());
            Assert.assertNull((Object)env.getConnectionManager());
            Assert.assertNull((Object)env.getPartitionConsumableNotifier());
            Assert.assertNull((Object)env.getTaskEventDispatcher());
            Assert.assertNull((Object)env.getPartitionManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

