/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.ListeningBehaviour;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.JobSnapshottingSettings;
import org.apache.flink.runtime.jobmanager.Tasks;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.minicluster.LocalFlinkMiniCluster;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class CoordinatorShutdownTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoordinatorShutsDownOnFailure() {
        LocalFlinkMiniCluster cluster = null;
        try {
            Configuration noTaskManagerConfig = new Configuration();
            noTaskManagerConfig.setInteger("local.number-taskmanager", 0);
            cluster = new LocalFlinkMiniCluster(noTaskManagerConfig, true);
            cluster.start();
            JobVertex vertex = new JobVertex("Test Vertex");
            vertex.setInvokableClass(Tasks.NoOpInvokable.class);
            List<JobVertexID> vertexIdList = Collections.singletonList(vertex.getID());
            JobGraph testGraph = new JobGraph("test job", new JobVertex[]{vertex});
            testGraph.setSnapshotSettings(new JobSnapshottingSettings(vertexIdList, vertexIdList, vertexIdList, 5000L));
            ActorGateway jmGateway = cluster.getLeaderGateway(TestingUtils.TESTING_DURATION());
            FiniteDuration timeout = new FiniteDuration(60L, TimeUnit.SECONDS);
            JobManagerMessages.SubmitJob submitMessage = new JobManagerMessages.SubmitJob(testGraph, ListeningBehaviour.EXECUTION_RESULT);
            Future submitFuture = jmGateway.ask((Object)submitMessage, timeout);
            Await.result((Awaitable)submitFuture, (Duration)timeout);
            Future jobRequestFuture = jmGateway.ask((Object)new JobManagerMessages.RequestJob(testGraph.getJobID()), timeout);
            ExecutionGraph graph = ((JobManagerMessages.JobFound)Await.result((Awaitable)jobRequestFuture, (Duration)timeout)).executionGraph();
            Assert.assertNotNull((Object)graph);
            graph.waitUntilFinished();
            CheckpointCoordinator coord = graph.getCheckpointCoordinator();
            Assert.assertTrue((coord == null || coord.isShutdown() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster.awaitTermination();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoordinatorShutsDownOnSuccess() {
        LocalFlinkMiniCluster cluster = null;
        try {
            cluster = new LocalFlinkMiniCluster(new Configuration(), true);
            cluster.start();
            JobVertex vertex = new JobVertex("Test Vertex");
            vertex.setInvokableClass(Tasks.NoOpInvokable.class);
            List<JobVertexID> vertexIdList = Collections.singletonList(vertex.getID());
            JobGraph testGraph = new JobGraph("test job", new JobVertex[]{vertex});
            testGraph.setSnapshotSettings(new JobSnapshottingSettings(vertexIdList, vertexIdList, vertexIdList, 5000L));
            ActorGateway jmGateway = cluster.getLeaderGateway(TestingUtils.TESTING_DURATION());
            FiniteDuration timeout = new FiniteDuration(60L, TimeUnit.SECONDS);
            JobManagerMessages.SubmitJob submitMessage = new JobManagerMessages.SubmitJob(testGraph, ListeningBehaviour.EXECUTION_RESULT);
            Future submitFuture = jmGateway.ask((Object)submitMessage, timeout);
            Await.result((Awaitable)submitFuture, (Duration)timeout);
            Future jobRequestFuture = jmGateway.ask((Object)new JobManagerMessages.RequestJob(testGraph.getJobID()), timeout);
            ExecutionGraph graph = ((JobManagerMessages.JobFound)Await.result((Awaitable)jobRequestFuture, (Duration)timeout)).executionGraph();
            Assert.assertNotNull((Object)graph);
            graph.waitUntilFinished();
            CheckpointCoordinator coord = graph.getCheckpointCoordinator();
            Assert.assertTrue((coord == null || coord.isShutdown() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster.awaitTermination();
            }
        }
    }
}

