/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StateForTask;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.CheckpointMessagesTest;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public abstract class CompletedCheckpointStoreTest
extends TestLogger {
    private final ClassLoader userClassLoader = ClassLoader.getSystemClassLoader();

    protected abstract CompletedCheckpointStore createCompletedCheckpoints(int var1, ClassLoader var2) throws Exception;

    @Test(expected=Exception.class)
    public void testExceptionOnNoRetainedCheckpoints() throws Exception {
        this.createCompletedCheckpoints(0, this.userClassLoader);
    }

    @Test
    public void testAddAndGetLatestCheckpoint() throws Exception {
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(4, this.userClassLoader);
        Assert.assertEquals((long)0L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        Assert.assertEquals((long)0L, (long)checkpoints.getAllCheckpoints().size());
        TestCheckpoint[] expected = new TestCheckpoint[]{this.createCheckpoint(0), this.createCheckpoint(1)};
        checkpoints.addCheckpoint((CompletedCheckpoint)expected[0]);
        Assert.assertEquals((long)1L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        this.verifyCheckpoint(expected[0], checkpoints.getLatestCheckpoint());
        checkpoints.addCheckpoint((CompletedCheckpoint)expected[1]);
        Assert.assertEquals((long)2L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        this.verifyCheckpoint(expected[1], checkpoints.getLatestCheckpoint());
    }

    @Test
    public void testAddCheckpointMoreThanMaxRetained() throws Exception {
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(1, this.userClassLoader);
        TestCheckpoint[] expected = new TestCheckpoint[]{this.createCheckpoint(0), this.createCheckpoint(1), this.createCheckpoint(2), this.createCheckpoint(3)};
        checkpoints.addCheckpoint((CompletedCheckpoint)expected[0]);
        Assert.assertEquals((long)1L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        for (int i = 1; i < expected.length; ++i) {
            checkpoints.addCheckpoint((CompletedCheckpoint)expected[i]);
            expected[i - 1].awaitDiscard();
            Assert.assertTrue((boolean)expected[i - 1].isDiscarded());
            Assert.assertEquals((Object)this.userClassLoader, (Object)expected[i - 1].getDiscardClassLoader());
            Assert.assertEquals((long)1L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        }
    }

    @Test
    public void testEmptyState() throws Exception {
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(1, this.userClassLoader);
        Assert.assertNull((Object)checkpoints.getLatestCheckpoint());
        Assert.assertEquals((long)0L, (long)checkpoints.getAllCheckpoints().size());
        Assert.assertEquals((long)0L, (long)checkpoints.getNumberOfRetainedCheckpoints());
    }

    @Test
    public void testGetAllCheckpoints() throws Exception {
        TestCheckpoint[] expected;
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(4, this.userClassLoader);
        for (TestCheckpoint checkpoint : expected = new TestCheckpoint[]{this.createCheckpoint(0), this.createCheckpoint(1), this.createCheckpoint(2), this.createCheckpoint(3)}) {
            checkpoints.addCheckpoint((CompletedCheckpoint)checkpoint);
        }
        List actual = checkpoints.getAllCheckpoints();
        Assert.assertEquals((long)expected.length, (long)actual.size());
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)((Object)expected[i]), actual.get(i));
        }
    }

    @Test
    public void testDiscardAllCheckpoints() throws Exception {
        TestCheckpoint[] expected;
        CompletedCheckpointStore checkpoints = this.createCompletedCheckpoints(4, this.userClassLoader);
        for (TestCheckpoint checkpoint : expected = new TestCheckpoint[]{this.createCheckpoint(0), this.createCheckpoint(1), this.createCheckpoint(2), this.createCheckpoint(3)}) {
            checkpoints.addCheckpoint((CompletedCheckpoint)checkpoint);
        }
        checkpoints.discardAllCheckpoints();
        Assert.assertNull((Object)checkpoints.getLatestCheckpoint());
        Assert.assertEquals((long)0L, (long)checkpoints.getAllCheckpoints().size());
        Assert.assertEquals((long)0L, (long)checkpoints.getNumberOfRetainedCheckpoints());
        for (TestCheckpoint checkpoint : expected) {
            checkpoint.awaitDiscard();
            Assert.assertTrue((boolean)checkpoint.isDiscarded());
            Assert.assertEquals((Object)this.userClassLoader, (Object)checkpoint.getDiscardClassLoader());
        }
    }

    protected TestCheckpoint createCheckpoint(int id) throws IOException {
        return this.createCheckpoint(id, 4);
    }

    protected TestCheckpoint createCheckpoint(int id, int numberOfStates) throws IOException {
        JobVertexID jvid = new JobVertexID();
        ArrayList<StateForTask> taskStates = new ArrayList<StateForTask>();
        for (int i = 0; i < numberOfStates; ++i) {
            SerializedValue stateHandle = new SerializedValue((Object)new CheckpointMessagesTest.MyHandle());
            taskStates.add(new StateForTask(stateHandle, jvid, i));
        }
        return new TestCheckpoint(new JobID(), id, 0L, taskStates);
    }

    private void verifyCheckpoint(CompletedCheckpoint expected, CompletedCheckpoint actual) {
        Assert.assertEquals((Object)expected.getJobId(), (Object)actual.getJobId());
        Assert.assertEquals((long)expected.getCheckpointID(), (long)actual.getCheckpointID());
        Assert.assertEquals((long)expected.getTimestamp(), (long)actual.getTimestamp());
        List expectedStates = expected.getStates();
        List actualStates = actual.getStates();
        Assert.assertEquals((long)expectedStates.size(), (long)actualStates.size());
        for (int i = 0; i < expectedStates.size(); ++i) {
            Assert.assertEquals(expectedStates.get(i), actualStates.get(i));
        }
    }

    protected static class TestCheckpoint
    extends CompletedCheckpoint {
        private static final long serialVersionUID = 4211419809665983026L;
        private boolean isDiscarded;
        private final transient CountDownLatch discardLatch = new CountDownLatch(1);
        private transient ClassLoader discardClassLoader;

        public TestCheckpoint(JobID jobId, long checkpointId, long timestamp, ArrayList<StateForTask> states) {
            super(jobId, checkpointId, timestamp, states);
        }

        public void discard(ClassLoader userClassLoader) {
            super.discard(userClassLoader);
            if (!this.isDiscarded) {
                this.discardClassLoader = userClassLoader;
                this.isDiscarded = true;
                if (this.discardLatch != null) {
                    this.discardLatch.countDown();
                }
            }
        }

        public boolean isDiscarded() {
            return this.isDiscarded;
        }

        public void awaitDiscard() throws InterruptedException {
            if (this.discardLatch != null) {
                this.discardLatch.await();
            }
        }

        public ClassLoader getDiscardClassLoader() {
            return this.discardClassLoader;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            TestCheckpoint that = (TestCheckpoint)((Object)o);
            return this.getJobId().equals((Object)that.getJobId()) && this.getCheckpointID() == that.getCheckpointID();
        }

        public int hashCode() {
            return this.getJobId().hashCode() + (int)this.getCheckpointID();
        }
    }
}

