/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public final class BlobKeyTest {
    private static final byte[] KEY_ARRAY_1 = new byte[20];
    private static final byte[] KEY_ARRAY_2 = new byte[20];

    @Test
    public void testSerialization() {
        BlobKey k2;
        BlobKey k1 = new BlobKey(KEY_ARRAY_1);
        try {
            k2 = (BlobKey)CommonTestUtils.createCopySerializable((Serializable)k1);
        }
        catch (IOException ioe) {
            Assert.fail((String)StringUtils.stringifyException((Throwable)ioe));
            return;
        }
        Assert.assertEquals((Object)k1, (Object)k2);
        Assert.assertEquals((long)k1.hashCode(), (long)k2.hashCode());
        Assert.assertEquals((long)0L, (long)k1.compareTo(k2));
    }

    @Test
    public void testEquals() {
        BlobKey k1 = new BlobKey(KEY_ARRAY_1);
        BlobKey k2 = new BlobKey(KEY_ARRAY_1);
        BlobKey k3 = new BlobKey(KEY_ARRAY_2);
        Assert.assertTrue((boolean)k1.equals((Object)k2));
        Assert.assertFalse((boolean)k1.equals((Object)k3));
    }

    @Test
    public void testCompares() {
        BlobKey k1 = new BlobKey(KEY_ARRAY_1);
        BlobKey k2 = new BlobKey(KEY_ARRAY_1);
        BlobKey k3 = new BlobKey(KEY_ARRAY_2);
        Assert.assertTrue((k1.compareTo(k2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((k1.compareTo(k3) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStreams() {
        BlobKey k2;
        BlobKey k1 = new BlobKey(KEY_ARRAY_1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(20);
        try {
            k1.writeToOutputStream((OutputStream)baos);
            baos.close();
        }
        catch (IOException ioe) {
            Assert.fail((String)StringUtils.stringifyException((Throwable)ioe));
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            k2 = BlobKey.readFromInputStream((InputStream)bais);
        }
        catch (IOException ioe) {
            Assert.fail((String)StringUtils.stringifyException((Throwable)ioe));
            return;
        }
        Assert.assertEquals((Object)k1, (Object)k2);
    }

    static {
        for (int i = 0; i < KEY_ARRAY_1.length; ++i) {
            BlobKeyTest.KEY_ARRAY_1[i] = (byte)i;
            BlobKeyTest.KEY_ARRAY_2[i] = (byte)(i + 1);
        }
    }
}

