/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.MessageDigest;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class BlobClientTest {
    private static final int TEST_BUFFER_SIZE = 17000;
    private static BlobServer BLOB_SERVER;

    @BeforeClass
    public static void startServer() {
        try {
            BLOB_SERVER = new BlobServer(new Configuration());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @AfterClass
    public static void stopServer() {
        if (BLOB_SERVER != null) {
            BLOB_SERVER.shutdown();
        }
    }

    private static byte[] createTestBuffer() {
        byte[] buf = new byte[17000];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(i % 128);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlobKey prepareTestFile(File file) throws IOException {
        MessageDigest md = BlobUtils.createMessageDigest();
        byte[] buf = new byte[17000];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)(i % 128);
        }
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            for (int i = 0; i < 20; ++i) {
                fos.write(buf);
                md.update(buf);
            }
        }
        return new BlobKey(md.digest());
    }

    private static void validateGet(InputStream inputStream, byte[] buf) throws IOException {
        int read;
        int bytesReceived = 0;
        do {
            if ((read = inputStream.read(buf, bytesReceived, buf.length - bytesReceived)) >= 0) continue;
            throw new EOFException();
        } while ((bytesReceived += read) != buf.length);
        Assert.assertEquals((long)-1L, (long)inputStream.read());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateGet(InputStream inputStream, File file) throws IOException {
        try (FileInputStream inputStream2 = null;){
            int r1;
            inputStream2 = new FileInputStream(file);
            do {
                r1 = inputStream.read();
                int r2 = ((InputStream)inputStream2).read();
                Assert.assertEquals((long)r2, (long)r1);
            } while (r1 >= 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentAddressableBuffer() {
        BlobClient client = null;
        try {
            byte[] testBuffer = BlobClientTest.createTestBuffer();
            MessageDigest md = BlobUtils.createMessageDigest();
            md.update(testBuffer);
            BlobKey origKey = new BlobKey(md.digest());
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", BLOB_SERVER.getPort());
            client = new BlobClient(serverAddress);
            BlobKey receivedKey = client.put(testBuffer);
            Assert.assertEquals((Object)origKey, (Object)receivedKey);
            InputStream is = client.get(receivedKey);
            BlobClientTest.validateGet(is, testBuffer);
            try {
                client.get(new BlobKey());
                Assert.fail((String)"Expected IOException did not occur");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContentAddressableStream() {
        BlobClient client = null;
        InputStream is = null;
        try {
            File testFile = File.createTempFile("testfile", ".dat");
            testFile.deleteOnExit();
            BlobKey origKey = BlobClientTest.prepareTestFile(testFile);
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", BLOB_SERVER.getPort());
            client = new BlobClient(serverAddress);
            is = new FileInputStream(testFile);
            BlobKey receivedKey = client.put(is);
            Assert.assertEquals((Object)origKey, (Object)receivedKey);
            is.close();
            is = null;
            is = client.get(receivedKey);
            BlobClientTest.validateGet(is, testFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegularBuffer() {
        byte[] testBuffer = BlobClientTest.createTestBuffer();
        JobID jobID = JobID.generate();
        String key = "testkey";
        try (BlobClient client = null;){
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", BLOB_SERVER.getPort());
            client = new BlobClient(serverAddress);
            client.put(jobID, "testkey", testBuffer);
            InputStream is = client.get(jobID, "testkey");
            BlobClientTest.validateGet(is, testBuffer);
            client.delete(jobID, "testkey");
            try {
                client.get(jobID, "testkey");
                Assert.fail((String)"Expected IOException did not occur");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegularStream() {
        JobID jobID = JobID.generate();
        String key = "testkey3";
        try {
            File testFile = File.createTempFile("testfile", ".dat");
            testFile.deleteOnExit();
            BlobClientTest.prepareTestFile(testFile);
            BlobClient client = null;
            InputStream is = null;
            try {
                InetSocketAddress serverAddress = new InetSocketAddress("localhost", BLOB_SERVER.getPort());
                client = new BlobClient(serverAddress);
                is = new FileInputStream(testFile);
                client.put(jobID, "testkey3", is);
                is.close();
                is = null;
                is = client.get(jobID, "testkey3");
                BlobClientTest.validateGet(is, testFile);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (client != null) {
                    client.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

