/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.DoubleLinkedList;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.apache.pekko.util.RecencyList$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005UxA\u0002\u00192\u0011\u0003\u0019\u0014H\u0002\u0004<c!\u00051\u0007\u0010\u0005\u0006\u0007\u0006!\t!\u0012\u0005\u0006\r\u0006!\ta\u0012\u0004\u0005k\u00061a\u000f\u0003\u0005y\t\t\u0015\r\u0011\"\u0001z\u0011!aHA!A!\u0002\u0013Q\b\"B\"\u0005\t\u0003i\b\"CA\u0002\t\u0001\u0007I\u0011AA\u0003\u0011%\ti\u0001\u0002a\u0001\n\u0003\ty\u0001\u0003\u0005\u0002\u001c\u0011\u0001\u000b\u0015BA\u0004\u0011%\ti\u0002\u0002a\u0001\n\u0003\t)\u0001C\u0005\u0002 \u0011\u0001\r\u0011\"\u0001\u0002\"!A\u0011Q\u0005\u0003!B\u0013\t9\u0001C\u0005\u0002(\u0011\u0001\r\u0011\"\u0001\u0002*!I\u00111\u0006\u0003A\u0002\u0013\u0005\u0011Q\u0006\u0005\b\u0003c!\u0001\u0015)\u0003T\r\u001dy\u0015\u0001%A\u0012\u0002ACQ!U\t\u0007\u0002ICQAV\t\u0007\u0002]3a!a9\u0002\u0005\u0005\u0015\bBB\"\u0015\t\u0003\tI\u000fC\u0003R)\u0011\u0005#\u000b\u0003\u0004W)\u0011\u0005\u0013Q\u001e\u0004\u0006wE\u00121G\u0013\u0005\t\u0019b\u0011\t\u0011)A\u0005\u001b\")1\t\u0007C\u0001C\"9q\u000e\u0007b\u0001\n\u0013\u0001\bbBA\u001a1\u0001\u0006I!\u001d\u0005\n\u0003kA\"\u0019!C\u0005\u0003oA\u0001\"!\u0013\u0019A\u0003%\u0011\u0011\b\u0005\b\u0003\u0017BB\u0011AA'\u0011\u001d\t)\u0006\u0007C\u0001\u0003/Bq!a\u0017\u0019\t\u0003\ti\u0006C\u0004\u0002ba!\t!a\u0019\t\u000f\u00055\u0004\u0004\"\u0001\u0002p!9\u00111\u000f\r\u0005\u0002\u0005=\u0004bBA;1\u0011\u0005\u0011q\u000f\u0005\b\u0003#CB\u0011AA<\u0011\u001d\t\u0019\n\u0007C\u0001\u0003+Cq!a%\u0019\t\u0003\t9\u000bC\u0004\u0002\u0014b!\t!a,\t\u000f\u0005E\u0006\u0004\"\u0001\u00024\"9\u0011\u0011\u0017\r\u0005\u0002\u0005]\u0006bBAY1\u0011\u0005\u0011q\u0016\u0005\b\u0003{CB\u0011AA`\u0011\u001d\t\u0019\r\u0007C\u0001\u0003\u000bDq!!3\u0019\t\u0013\tY-A\u0006SK\u000e,gnY=MSN$(B\u0001\u001a4\u0003\u0011)H/\u001b7\u000b\u0005Q*\u0014!\u00029fW.|'B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001e\u0004\"AO\u0001\u000e\u0003E\u00121BU3dK:\u001c\u0017\u0010T5tiN\u0011\u0011!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!O\u0001\u0006K6\u0004H/_\u000b\u0004\u0011\u0006\u0005X#A%\u0011\tiB\u0012q\\\u000b\u0003\u0017\u0016\u001c\"\u0001G\u001f\u0002\u000b\rdwnY6\u0011\u00059\u000bbB\u0001\u001e\u0001\u0005\u0015\u0019En\\2l'\t\tR(A\u0006dkJ\u0014XM\u001c;US6,G#A*\u0011\u0005y\"\u0016BA+@\u0005\u0011auN\\4\u0002\u0017\u0015\f'\u000f\\5feRKW.\u001a\u000b\u0003'bCQ!W\nA\u0002i\u000b\u0001\u0002Z;sCRLwN\u001c\t\u00037~k\u0011\u0001\u0018\u0006\u00033vS!AX \u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002a9\nqa)\u001b8ji\u0016$UO]1uS>tGC\u00012o!\rQ\u0004d\u0019\t\u0003I\u0016d\u0001\u0001B\u0003g1\t\u0007qMA\u0001B#\tA7\u000e\u0005\u0002?S&\u0011!n\u0010\u0002\b\u001d>$\b.\u001b8h!\tqD.\u0003\u0002n\u007f\t\u0019\u0011I\\=\t\u000b1S\u0002\u0019A'\u0002\u000fI,7-\u001a8dsV\t\u0011\u000fE\u0002;eRL!a]\u0019\u0003!\u0011{WO\u00197f\u0019&t7.\u001a3MSN$\bc\u0001(\u0005G\n!aj\u001c3f+\t98p\u0005\u0002\u0005{\u0005)a/\u00197vKV\t!\u0010\u0005\u0002ew\u0012)a\r\u0002b\u0001O\u00061a/\u00197vK\u0002\"2A`A\u0001!\ryHA_\u0007\u0002\u0003!)\u0001p\u0002a\u0001u\u0006QA.Z:t%\u0016\u001cWM\u001c;\u0016\u0005\u0005\u001d\u0001\u0003\u0002\u001e\u0002\nyL1!a\u00032\u0005%y\u0005\u000f^5p]Z\u000bG.\u0001\bmKN\u001c(+Z2f]R|F%Z9\u0015\t\u0005E\u0011q\u0003\t\u0004}\u0005M\u0011bAA\u000b\u007f\t!QK\\5u\u0011%\tI\"CA\u0001\u0002\u0004\t9!A\u0002yIE\n1\u0002\\3tgJ+7-\u001a8uA\u0005QQn\u001c:f%\u0016\u001cWM\u001c;\u0002\u001d5|'/\u001a*fG\u0016tGo\u0018\u0013fcR!\u0011\u0011CA\u0012\u0011%\tI\u0002DA\u0001\u0002\u0004\t9!A\u0006n_J,'+Z2f]R\u0004\u0013!\u0003;j[\u0016\u001cH/Y7q+\u0005\u0019\u0016!\u0004;j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u0005=\u0002\u0002CA\r\u001f\u0005\u0005\t\u0019A*\u0002\u0015QLW.Z:uC6\u0004\b%\u0001\u0005sK\u000e,gnY=!\u0003)awn\\6va:{G-Z\u000b\u0003\u0003s\u0001b!a\u000f\u0002F\r$XBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u000f5,H/\u00192mK*\u0019\u00111I \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005u\"aA'ba\u0006YAn\\8lkBtu\u000eZ3!\u0003\u0011\u0019\u0018N_3\u0016\u0005\u0005=\u0003c\u0001 \u0002R%\u0019\u00111K \u0003\u0007%sG/\u0001\u0004va\u0012\fG/\u001a\u000b\u0004E\u0006e\u0003\"\u0002=!\u0001\u0004\u0019\u0017A\u0002:f[>4X\rF\u0002c\u0003?BQ\u0001_\u0011A\u0002\r\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003K\nY\u0007E\u0002?\u0003OJ1!!\u001b@\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u001f\u0012A\u0002\r\f1\u0002\\3bgR\u0014VmY3oiV\u0011\u0011\u0011\u000f\t\u0005u\u0005%1-\u0001\u0006n_N$(+Z2f]R\f\u0011\u0003\\3bgR$v.T8tiJ+7-\u001a8u+\t\tI\bE\u0003\u0002|\u0005-5M\u0004\u0003\u0002~\u0005\u001de\u0002BA@\u0003\u000bk!!!!\u000b\u0007\u0005\rE)\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u0019\u0011\u0011R \u0002\u000fA\f7m[1hK&!\u0011QRAH\u0005!IE/\u001a:bi>\u0014(bAAE\u007f\u0005\tRn\\:u)>dU-Y:u%\u0016\u001cWM\u001c;\u0002#I,Wn\u001c<f\u0019\u0016\f7\u000f\u001e*fG\u0016tG\u000f\u0006\u0003\u0002\u0018\u0006\r\u0006#BAM\u0003?\u001bWBAAN\u0015\u0011\ti*!\u0011\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BAQ\u00037\u00131aU3r\u0011\u001d\t)k\na\u0001\u0003\u001f\n\u0011A\u001c\u000b\u0007\u0003/\u000bI+a+\t\u000f\u0005\u0015\u0006\u00061\u0001\u0002P!9\u0011Q\u0016\u0015A\u0002\u0005=\u0013\u0001B:lSB$\"!a&\u0002!I,Wn\u001c<f\u001b>\u001cHOU3dK:$H\u0003BAL\u0003kCq!!*+\u0001\u0004\ty\u0005\u0006\u0004\u0002\u0018\u0006e\u00161\u0018\u0005\b\u0003K[\u0003\u0019AA(\u0011\u001d\tik\u000ba\u0001\u0003\u001f\n\u0001D]3n_Z,G*Z1tiJ+7-\u001a8u\u001fV$8/\u001b3f)\u0011\t9*!1\t\u000bek\u0003\u0019\u0001.\u0002-I,Wn\u001c<f\u001b>\u001cHOU3dK:$x+\u001b;iS:$B!a&\u0002H\")\u0011L\fa\u00015\u0006Q!/Z7pm\u0016tu\u000eZ3\u0015\u0007\r\fi\r\u0003\u0004\u0002P>\u0002\r\u0001^\u0001\u0005]>$W\rK\u0002\u0019\u0003'\u0004B!!6\u0002\\6\u0011\u0011q\u001b\u0006\u0004\u00033\u001c\u0014AC1o]>$\u0018\r^5p]&!\u0011Q\\Al\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0011\u0007\u0011\f\t\u000fB\u0003g\u0007\t\u0007qMA\u0005OC:|7\t\\8dWN!A#PAt!\ty\u0018\u0003\u0006\u0002\u0002lB\u0011q\u0010\u0006\u000b\u0004'\u0006=\b\"B-\u0018\u0001\u0004Q\u0006fA\u0001\u0002T\"\u001a\u0001!a5")
@InternalApi
public final class RecencyList<A> {
    private final Clock clock;
    private final DoubleLinkedList<Node<A>> recency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> RecencyList<A> empty() {
        return RecencyList$.MODULE$.empty();
    }

    private DoubleLinkedList<Node<A>> recency() {
        return this.recency;
    }

    private Map<A, Node<A>> lookupNode() {
        return this.lookupNode;
    }

    public int size() {
        return this.lookupNode().size();
    }

    public RecencyList<A> update(A value) {
        Object object;
        if (this.lookupNode().contains(value)) {
            Node node = (Node)this.lookupNode().apply(value);
            node.timestamp_$eq(this.clock.currentTime());
            object = this.recency().moveToBack(node);
        } else {
            Node<A> node = new Node<A>(value);
            node.timestamp_$eq(this.clock.currentTime());
            this.recency().append(node);
            object = this.lookupNode().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(value), node));
        }
        return this;
    }

    public RecencyList<A> remove(A value) {
        BoxedUnit boxedUnit = this.lookupNode().contains(value) ? this.removeNode((Node)this.lookupNode().apply(value)) : BoxedUnit.UNIT;
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode().contains(value);
    }

    public A leastRecent() {
        Node<A> node = this.recency().getFirst();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> first = OptionVal$.MODULE$.get$extension(node2);
            return OptionVal$Some$.MODULE$.apply(first.value());
        }
        return OptionVal$.MODULE$.none();
    }

    public A mostRecent() {
        Node<A> node = this.recency().getLast();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> last = OptionVal$.MODULE$.get$extension(node2);
            return OptionVal$Some$.MODULE$.apply(last.value());
        }
        return OptionVal$.MODULE$.none();
    }

    public Iterator<A> leastToMostRecent() {
        return this.recency().forwardIterator().map((Function1<Node, Object> & Serializable & scala.Serializable)x$3 -> x$3.value());
    }

    public Iterator<A> mostToLeastRecent() {
        return this.recency().backwardIterator().map((Function1<Node, Object> & Serializable & scala.Serializable)x$4 -> x$4.value());
    }

    public scala.collection.immutable.Seq<A> removeLeastRecent(int n) {
        if (n == 1) {
            return this.removeLeastRecent();
        }
        return this.recency().forwardIterator().take(n).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public scala.collection.immutable.Seq<A> removeLeastRecent(int n, int skip) {
        return this.recency().forwardIterator().slice(skip, skip + n).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public scala.collection.immutable.Seq<A> removeLeastRecent() {
        Node<A> node = this.recency().getFirst();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> first = OptionVal$.MODULE$.get$extension(node2);
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Object[]{this.removeNode(first)}));
        }
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<A> removeMostRecent(int n) {
        if (n == 1) {
            return this.removeMostRecent();
        }
        return this.recency().backwardIterator().take(n).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public scala.collection.immutable.Seq<A> removeMostRecent(int n, int skip) {
        return this.recency().backwardIterator().slice(skip, skip + n).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public scala.collection.immutable.Seq<A> removeMostRecent() {
        Node<A> node = this.recency().getLast();
        Node<A> node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node<A> last = OptionVal$.MODULE$.get$extension(node2);
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Object[]{this.removeNode(last)}));
        }
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<A> removeLeastRecentOutside(FiniteDuration duration) {
        long min = this.clock.earlierTime(duration);
        return this.recency().forwardIterator().takeWhile((Function1<Node, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(RecencyList.$anonfun$removeLeastRecentOutside$1(min, x$5))).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public scala.collection.immutable.Seq<A> removeMostRecentWithin(FiniteDuration duration) {
        long max = this.clock.earlierTime(duration);
        return this.recency().backwardIterator().takeWhile((Function1<Node, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(RecencyList.$anonfun$removeMostRecentWithin$1(max, x$6))).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
    }

    private A removeNode(Node<A> node) {
        A value = node.value();
        this.recency().remove(node);
        this.lookupNode().$minus$eq(value);
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$removeLeastRecentOutside$1(long min$1, Node x$5) {
        return x$5.timestamp() < min$1;
    }

    public static final /* synthetic */ boolean $anonfun$removeMostRecentWithin$1(long max$1, Node x$6) {
        return x$6.timestamp() > max$1;
    }

    public RecencyList(Clock clock) {
        this.clock = clock;
        this.recency = new DoubleLinkedList((Function1<Node, Object> & Serializable & scala.Serializable)x$1 -> new OptionVal<Node>(x$1.lessRecent()), (Function1<Node, Object> & Serializable & scala.Serializable)x$2 -> new OptionVal<Node>(x$2.moreRecent()), (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, previous) -> {
            node.lessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, next) -> {
            node.moreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = Map$.MODULE$.empty();
    }

    public static interface Clock {
        public long currentTime();

        public long earlierTime(FiniteDuration var1);
    }

    public static final class NanoClock
    implements Clock {
        @Override
        public long currentTime() {
            return System.nanoTime();
        }

        @Override
        public long earlierTime(FiniteDuration duration) {
            return this.currentTime() - duration.toNanos();
        }
    }

    private static final class Node<A> {
        private final A value;
        private Node<A> lessRecent;
        private Node<A> moreRecent;
        private long timestamp;

        public A value() {
            return this.value;
        }

        public Node<A> lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node<A> x$1) {
            this.lessRecent = x$1;
        }

        public Node<A> moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node<A> x$1) {
            this.moreRecent = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node(A value) {
            this.value = value;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            this.timestamp = 0L;
        }
    }
}

