/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.streamref;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.SinkRef;
import org.apache.pekko.stream.SourceRef;
import org.apache.pekko.stream.StreamRefResolver;
import org.apache.pekko.stream.impl.streamref.SinkRefImpl;
import org.apache.pekko.stream.impl.streamref.SourceRefImpl;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4Qa\u0002\u0005\u0003\u001dQA\u0001b\b\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006O\u0001!\t\u0001\u000b\u0005\u0006Y\u0001!\t!\f\u0005\u0006Y\u0001!\tA\u0013\u0005\u0006%\u0002!\ta\u0015\u0005\u00065\u0002!\ta\u0017\u0002\u0016'R\u0014X-Y7SK\u001a\u0014Vm]8mm\u0016\u0014\u0018*\u001c9m\u0015\tI!\"A\u0005tiJ,\u0017-\u001c:fM*\u00111\u0002D\u0001\u0005S6\u0004HN\u0003\u0002\u000e\u001d\u000511\u000f\u001e:fC6T!a\u0004\t\u0002\u000bA,7n[8\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\n\u0004\u0001UY\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\r\u0005\u0002\u001d;5\tA\"\u0003\u0002\u001f\u0019\t\t2\u000b\u001e:fC6\u0014VM\u001a*fg>dg/\u001a:\u0002\rML8\u000f^3n\u0007\u0001\u0001\"AI\u0013\u000e\u0003\rR!\u0001\n\b\u0002\u000b\u0005\u001cGo\u001c:\n\u0005\u0019\u001a#aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017A\u0002\u001fj]&$h\b\u0006\u0002*WA\u0011!\u0006A\u0007\u0002\u0011!)qD\u0001a\u0001C\u0005)Bo\\*fe&\fG.\u001b>bi&|gNR8s[\u0006$XC\u0001\u0018B)\ty#\b\u0005\u00021o9\u0011\u0011'\u000e\t\u0003e]i\u0011a\r\u0006\u0003i\u0001\na\u0001\u0010:p_Rt\u0014B\u0001\u001c\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y:\u0002\"B\u001e\u0004\u0001\u0004a\u0014a\u0001:fMB\u0019A$P \n\u0005yb!!C*pkJ\u001cWMU3g!\t\u0001\u0015\t\u0004\u0001\u0005\u000b\t\u001b!\u0019A\"\u0003\u0003Q\u000b\"\u0001R$\u0011\u0005Y)\u0015B\u0001$\u0018\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0006%\n\u0005%;\"aA!osV\u00111*\u0015\u000b\u0003_1CQa\u000f\u0003A\u00025\u00032\u0001\b(Q\u0013\tyEBA\u0004TS:\\'+\u001a4\u0011\u0005\u0001\u000bF!\u0002\"\u0005\u0005\u0004\u0019\u0015\u0001\u0005:fg>dg/Z*pkJ\u001cWMU3g+\t!v\u000b\u0006\u0002V1B\u0019A$\u0010,\u0011\u0005\u0001;F!\u0002\"\u0006\u0005\u0004\u0019\u0005\"B-\u0006\u0001\u0004y\u0013aE:fe&\fG.\u001b>fIN{WO]2f%\u00164\u0017A\u0004:fg>dg/Z*j].\u0014VMZ\u000b\u00039~#\"!\u00181\u0011\u0007qqe\f\u0005\u0002A?\u0012)!I\u0002b\u0001\u0007\")\u0011M\u0002a\u0001_\u0005\t2/\u001a:jC2L'0\u001a3TS:\\'+\u001a4)\u0005\u0001\u0019\u0007C\u00013h\u001b\u0005)'B\u00014\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0003Q\u0016\u00141\"\u00138uKJt\u0017\r\\!qS\u0002")
@InternalApi
public final class StreamRefResolverImpl
implements StreamRefResolver {
    private final ExtendedActorSystem system;

    @Override
    public <T> String toSerializationFormat(SourceRef<T> ref) {
        SourceRef<T> sourceRef = ref;
        if (sourceRef instanceof SourceRefImpl) {
            SourceRefImpl sourceRefImpl = (SourceRefImpl)sourceRef;
            ActorRef actorRef2 = sourceRefImpl.initialPartnerRef();
            return actorRef2.path().toSerializationFormatWithAddress(this.system.provider().getDefaultAddress());
        }
        throw new IllegalArgumentException(new StringBuilder(27).append("Unexpected SourceRef impl: ").append(sourceRef.getClass()).toString());
    }

    @Override
    public <T> String toSerializationFormat(SinkRef<T> ref) {
        SinkRef<T> sinkRef = ref;
        if (sinkRef instanceof SinkRefImpl) {
            SinkRefImpl sinkRefImpl = (SinkRefImpl)sinkRef;
            ActorRef actorRef2 = sinkRefImpl.initialPartnerRef();
            return actorRef2.path().toSerializationFormatWithAddress(this.system.provider().getDefaultAddress());
        }
        throw new IllegalArgumentException(new StringBuilder(25).append("Unexpected SinkRef impl: ").append(sinkRef.getClass()).toString());
    }

    @Override
    public <T> SourceRef<T> resolveSourceRef(String serializedSourceRef) {
        return new SourceRefImpl(this.system.provider().resolveActorRef(serializedSourceRef));
    }

    @Override
    public <T> SinkRef<T> resolveSinkRef(String serializedSinkRef) {
        return new SinkRefImpl(this.system.provider().resolveActorRef(serializedSinkRef));
    }

    public StreamRefResolverImpl(ExtendedActorSystem system) {
        this.system = system;
    }
}

