/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LogMarker$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.JavaSerializer;
import org.apache.pekko.serialization.NullSerializer$;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationSetup;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.SerializerDetails;
import org.apache.pekko.serialization.SerializerDetails$;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005w!\u0002/^\u0011\u00031g!\u00025^\u0011\u0003I\u0007\"\u00029\u0002\t\u0003\tX\u0001\u0002:\u0002\u0001MD!\"!\t\u0002\u0005\u0004%\taXA\u0012\u0011!\ty.\u0001Q\u0001\n\u0005\u0015bABAw\u0003\u0001\ty\u000f\u0003\u0006\u0002r\u001a\u0011)\u0019!C\u0001\u0003gD!Ba\u0002\u0007\u0005\u0003\u0005\u000b\u0011BA{\u0011\u0019\u0001h\u0001\"\u0001\u0003\n!I!q\u0002\u0004C\u0002\u0013\u0005!\u0011\u0003\u0005\t\u0005;1\u0001\u0015!\u0003\u0003\u0014!I!q\u0004\u0004C\u0002\u0013\u0005!\u0011\u0003\u0005\t\u0005C1\u0001\u0015!\u0003\u0003\u0014!9!1\u0005\u0004\u0005\u000e\t\u0015\u0002b\u0002B\u0016\u0003\u0011\u0005!Q\u0006\u0004\u0007\u0003k\t!)a\u000e\t\u0015\u0005\u0015\u0003C!f\u0001\n\u0003\t9\u0005\u0003\u0006\u0002VA\u0011\t\u0012)A\u0005\u0003\u0013B!\"a\u0016\u0011\u0005+\u0007I\u0011AA-\u0011)\t\t\u0007\u0005B\tB\u0003%\u00111\f\u0005\u0007aB!\t!a\u0019\t\u0013\u0005%\u0004#!A\u0005\u0002\u0005-\u0004\"CA9!E\u0005I\u0011AA:\u0011%\tI\tEI\u0001\n\u0003\tY\tC\u0005\u0002\u0010B\t\t\u0011\"\u0011\u0002\u0012\"I\u00111\u0015\t\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003[\u0003\u0012\u0011!C\u0001\u0003_C\u0011\"!.\u0011\u0003\u0003%\t%a.\t\u0013\u0005\u0015\u0007#!A\u0005\u0002\u0005\u001d\u0007\"CAi!\u0005\u0005I\u0011IAj\u0011%\t)\u000eEA\u0001\n\u0003\n9\u000eC\u0005\u0002ZB\t\t\u0011\"\u0011\u0002\\\u001eI!\u0011H\u0001\u0002\u0002#\u0005!1\b\u0004\n\u0003k\t\u0011\u0011!E\u0001\u0005{Aa\u0001\u001d\u0012\u0005\u0002\t-\u0003\"CAkE\u0005\u0005IQIAl\u0011%\u0011iEIA\u0001\n\u0003\u0013y\u0005C\u0005\u0003V\t\n\t\u0011\"!\u0003X!I!Q\r\u0012\u0002\u0002\u0013%!q\r\u0005\b\u0005_\nA\u0011\u0001B9\u0011\u001d\u0011y)\u0001C\u0001\u0005#3Q\u0001[/\u0001\u0005'C!\"a\u0016+\u0005\u000b\u0007I\u0011\u0001BN\u0011)\t\tG\u000bB\u0001B\u0003%!\u0011\u0012\u0005\u0007a*\"\tA!(\t\u0013\t\r&F1A\u0005\u0002\t\u0015\u0006\u0002\u0003BVU\u0001\u0006IAa*\t\u0013\t5&F1A\u0005\u0002\t=\u0006\u0002\u0003BYU\u0001\u0006I!!3\t\u0011\tM&\u0006)A\u0005\u0005kC\u0011B!1+\u0005\u0004%\tAa1\t\u0011\t-'\u0006)A\u0005\u0005\u000bD\u0011B!4+\u0005\u0004%IAa4\t\u0011\tm(\u0006)A\u0005\u0005#D\u0001B!@+\t\u0003y&q \u0005\b\u0005_RC\u0011BB\u0003\u0011\u001d\u0019\tB\u000bC\u0001\u0007'Aqaa\u000b+\t\u0003\u0019i\u0003C\u0004\u0004,)\"\ta!\u001d\t\u000f\ru$\u0006\"\u0003\u0004\u0000!91\u0011\u0012\u0016\u0005\u0002\r-\u0005bBB\u0016U\u0011\u00051q\u0017\u0005\b\u0007\u000fTC\u0011ABe\u0011\u001d\u0019iM\u000bC\u0001\u0007\u001fDqaa8+\t\u0003\u0019\t\u000fC\u0004\u0004`*\"Ia!;\t\u0013\rE(F1A\u0005\n\rM\b\u0002\u0003C\u0001U\u0001\u0006Ia!>\t\u0013\u0011\r!F1A\u0005\n\u0011\u0015\u0001\u0002\u0003C\u0005U\u0001\u0006I\u0001b\u0002\t\u0015\u0011-!F1A\u0005\u0002}#i\u0001\u0003\u0005\u0005\u0014)\u0002\u000b\u0011\u0002C\b\u0011\u001d!)B\u000bC\u0005\t/Aq\u0001b\r+\t\u0013!)\u0004C\u0004\u0005H)\"I\u0001\"\u0013\t\u000f\u0011=#\u0006\"\u0003\u0005R!9AQ\u000b\u0016\u0005\n\u0011]\u0003b\u0002C0U\u0011%A\u0011\r\u0005\n\t[R#\u0019!C\u0005\t_B\u0001\u0002b!+A\u0003%A\u0011\u000f\u0005\n\t\u000bS#\u0019!C\u0001\t\u000fC\u0001\u0002b#+A\u0003%A\u0011\u0012\u0005\n\t\u001bS#\u0019!C\u0005\t\u001fC\u0001\u0002b%+A\u0003%A\u0011\u0013\u0005\b\t+SC\u0011\u0002CL\u0011%!iJ\u000bb\u0001\n\u0013\u0011y\u000b\u0003\u0005\u0005 *\u0002\u000b\u0011BAe\u0011%!\tK\u000bb\u0001\n\u0013\u0011y\u000b\u0003\u0005\u0005$*\u0002\u000b\u0011BAe\u0011\u001d!)K\u000bC\u0005\tOC\u0001\u0002b++\t\u0003yFQV\u0001\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005y{\u0016!D:fe&\fG.\u001b>bi&|gN\u0003\u0002aC\u0006)\u0001/Z6l_*\u0011!mY\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\f1a\u001c:h\u0007\u0001\u0001\"aZ\u0001\u000e\u0003u\u0013QbU3sS\u0006d\u0017N_1uS>t7CA\u0001k!\tYg.D\u0001m\u0015\u0005i\u0017!B:dC2\f\u0017BA8m\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u001a\u0002\u0010\u00072\f7o]*fe&\fG.\u001b>feB)1\u000e\u001e<\u0002\u001c%\u0011Q\u000f\u001c\u0002\u0007)V\u0004H.\u001a\u001a1\u0007]\fI\u0001\u0005\u0003y\u007f\u0006\u0015aBA=~!\tQH.D\u0001|\u0015\taX-\u0001\u0004=e>|GOP\u0005\u0003}2\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011Qa\u00117bgNT!A 7\u0011\t\u0005\u001d\u0011\u0011\u0002\u0007\u0001\t-\tYaAA\u0001\u0002\u0003\u0015\t!!\u0004\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0010\u0005U\u0001cA6\u0002\u0012%\u0019\u00111\u00037\u0003\u000f9{G\u000f[5oOB\u00191.a\u0006\n\u0007\u0005eANA\u0002B]f\u00042aZA\u000f\u0013\r\ty\"\u0018\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018aG2veJ,g\u000e\u001e+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g.\u0006\u0002\u0002&A1\u0011qEA\u0017\u0003ci!!!\u000b\u000b\u0007\u0005-B.\u0001\u0003vi&d\u0017\u0002BA\u0018\u0003S\u0011q\u0002R=oC6L7MV1sS\u0006\u0014G.\u001a\t\u0004\u0003g\u0001R\"A\u0001\u0003\u0017%sgm\u001c:nCRLwN\\\n\u0007!)\fI$a\u0010\u0011\u0007-\fY$C\u0002\u0002>1\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002l\u0003\u0003J1!a\u0011m\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\tG\r\u001a:fgN,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014`\u0003\u0015\t7\r^8s\u0013\u0011\t\u0019&!\u0014\u0003\u000f\u0005#GM]3tg\u0006A\u0011\r\u001a3sKN\u001c\b%\u0001\u0004tsN$X-\\\u000b\u0003\u00037\u0002B!a\u0013\u0002^%!\u0011qLA'\u0005-\t5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nAQ1\u0011\u0011GA3\u0003OBq!!\u0012\u0016\u0001\u0004\tI\u0005C\u0004\u0002XU\u0001\r!a\u0017\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003c\ti'a\u001c\t\u0013\u0005\u0015c\u0003%AA\u0002\u0005%\u0003\"CA,-A\u0005\t\u0019AA.\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u001e+\t\u0005%\u0013qO\u0016\u0003\u0003s\u0002B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u00117\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\b\u0006u$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAGU\u0011\tY&a\u001e\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006}UBAAL\u0015\u0011\tI*a'\u0002\t1\fgn\u001a\u0006\u0003\u0003;\u000bAA[1wC&!\u0011\u0011UAL\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0015\t\u0004W\u0006%\u0016bAAVY\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QCAY\u0011%\t\u0019lGA\u0001\u0002\u0004\t9+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003s\u0003b!a/\u0002B\u0006UQBAA_\u0015\r\ty\f\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAb\u0003{\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011ZAh!\rY\u00171Z\u0005\u0004\u0003\u001bd'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003gk\u0012\u0011!a\u0001\u0003+\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\u000ba!Z9vC2\u001cH\u0003BAe\u0003;D\u0011\"a-!\u0003\u0003\u0005\r!!\u0006\u00029\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8oA!\u001aQ!a9\u0011\t\u0005\u0015\u0018\u0011^\u0007\u0003\u0003OT1!a!`\u0013\u0011\tY/a:\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0002\t'\u0016$H/\u001b8hgN\u0011aA[\u0001\u0007G>tg-[4\u0016\u0005\u0005U\b\u0003BA|\u0005\u0007i!!!?\u000b\t\u0005E\u00181 \u0006\u0005\u0003{\fy0\u0001\u0005usB,7/\u00194f\u0015\t\u0011\t!A\u0002d_6LAA!\u0002\u0002z\n11i\u001c8gS\u001e\fqaY8oM&<\u0007\u0005\u0006\u0003\u0003\f\t5\u0001cAA\u001a\r!9\u0011\u0011_\u0005A\u0002\u0005U\u0018aC*fe&\fG.\u001b>feN,\"Aa\u0005\u0011\u000fa\u0014)B!\u0007\u0003\u001a%!!qCA\u0002\u0005\ri\u0015\r\u001d\t\u0004q\nm\u0011\u0002BAQ\u0003\u0007\tAbU3sS\u0006d\u0017N_3sg\u0002\nQcU3sS\u0006d\u0017N_1uS>t')\u001b8eS:<7/\u0001\fTKJL\u0017\r\\5{CRLwN\u001c\"j]\u0012LgnZ:!\u0003-\u0019wN\u001c4jOR{W*\u00199\u0015\t\tM!q\u0005\u0005\b\u0005Sq\u0001\u0019AA{\u0003\r\u0019gmZ\u0001\u0014g\u0016\u0014\u0018.\u00197ju\u0016$\u0017i\u0019;peB\u000bG\u000f\u001b\u000b\u0005\u00053\u0011y\u0003C\u0004\u00032=\u0001\rAa\r\u0002\u0011\u0005\u001cGo\u001c:SK\u001a\u0004B!a\u0013\u00036%!!qGA'\u0005!\t5\r^8s%\u00164\u0017aC%oM>\u0014X.\u0019;j_:\u00042!a\r#'\u0015\u0011#qHA !)\u0011\tEa\u0012\u0002J\u0005m\u0013\u0011G\u0007\u0003\u0005\u0007R1A!\u0012m\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0013\u0003D\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\tm\u0012!B1qa2LHCBA\u0019\u0005#\u0012\u0019\u0006C\u0004\u0002F\u0015\u0002\r!!\u0013\t\u000f\u0005]S\u00051\u0001\u0002\\\u00059QO\\1qa2LH\u0003\u0002B-\u0005C\u0002Ra\u001bB.\u0005?J1A!\u0018m\u0005\u0019y\u0005\u000f^5p]B11\u000e^A%\u00037B\u0011Ba\u0019'\u0003\u0003\u0005\r!!\r\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B5!\u0011\t)Ja\u001b\n\t\t5\u0014q\u0013\u0002\u0007\u001f\nTWm\u0019;\u00021]LG\u000f\u001b+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g.\u0006\u0003\u0003t\teD\u0003\u0002B;\u0005\u000f#BAa\u001e\u0003~A!\u0011q\u0001B=\t\u001d\u0011Y\b\u000bb\u0001\u0003\u001b\u0011\u0011\u0001\u0016\u0005\b\u0005\u007fB\u0003\u0019\u0001BA\u0003\u00051\u0007#B6\u0003\u0004\n]\u0014b\u0001BCY\nIa)\u001e8di&|g\u000e\r\u0005\b\u0003/B\u0003\u0019\u0001BE!\u0011\tYEa#\n\t\t5\u0015Q\n\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\\\u0001\u001fO\u0016$8)\u001e:sK:$HK]1ogB|'\u000f^%oM>\u0014X.\u0019;j_:$\"!!\r\u0014\t)R'Q\u0013\t\u0005\u0003\u0017\u00129*\u0003\u0003\u0003\u001a\u00065#!C#yi\u0016t7/[8o+\t\u0011I\t\u0006\u0003\u0003 \n\u0005\u0006CA4+\u0011\u001d\t9&\fa\u0001\u0005\u0013\u000b\u0001b]3ui&twm]\u000b\u0003\u0005O\u00032A!+\u0007\u001d\t9\u0007!A\u0005tKR$\u0018N\\4tA\u00051\u0012\t\u001c7po*\u000bg/Y*fe&\fG.\u001b>bi&|g.\u0006\u0002\u0002J\u00069\u0012\t\u001c7po*\u000bg/Y*fe&\fG.\u001b>bi&|g\u000eI\u0001\u0005?2|w\r\u0005\u0003\u00038\nuVB\u0001B]\u0015\r\u0011YlX\u0001\u0006KZ,g\u000e^\u0005\u0005\u0005\u007f\u0013IL\u0001\u000bNCJ\\WM\u001d'pO\u001eLgnZ!eCB$XM]\u0001\u0004Y><WC\u0001Bc!\u0011\u00119La2\n\t\t%'\u0011\u0018\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0003\u0011awn\u001a\u0011\u0002\u001b5\fg.\u001b4fgR\u001c\u0015m\u00195f+\t\u0011\t\u000e\u0005\u0004\u0003T\n}'1]\u0007\u0003\u0005+TAAa6\u0003Z\u00061\u0011\r^8nS\u000eTAAa7\u0003^\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005-\u00121T\u0005\u0005\u0005C\u0014)NA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!!\u0011)Oa;\u0003\u001a\t5XB\u0001Bt\u0015\u0011\u0011I/!0\u0002\u0013%lW.\u001e;bE2,\u0017\u0002\u0002B\f\u0005O\u0004Ra\u001bB.\u0005_\u0004DA!=\u0003xB1\u0011Q\u0013Bz\u0005kLA!!\u0001\u0002\u0018B!\u0011q\u0001B|\t-\u0011IPNA\u0001\u0002\u0003\u0015\t!!\u0004\u0003\u0007}##'\u0001\bnC:Lg-Z:u\u0007\u0006\u001c\u0007.\u001a\u0011\u00021M,'/[1mSj\fG/[8o\u0013:4wN]7bi&|g.\u0006\u0002\u0004\u0002A\u0019!\u0011\u0016\t)\u0007]\n\u0019/\u0006\u0003\u0004\b\r-A\u0003BB\u0005\u0007\u001b\u0001B!a\u0002\u0004\f\u00119!1\u0010\u001dC\u0002\u00055\u0001b\u0002B@q\u0001\u00071q\u0002\t\u0006W\n\r5\u0011B\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$Ba!\u0006\u0004(A1\u0011qEB\f\u00077IAa!\u0007\u0002*\t\u0019AK]=\u0011\u000b-\u001cib!\t\n\u0007\r}ANA\u0003BeJ\f\u0017\u0010E\u0002l\u0007GI1a!\nm\u0005\u0011\u0011\u0015\u0010^3\t\r\r%\u0012\b1\u0001k\u0003\u0005y\u0017a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016,Baa\f\u00046QA1\u0011GB\u001c\u0007w\u0019y\u0004\u0005\u0004\u0002(\r]11\u0007\t\u0005\u0003\u000f\u0019)\u0004B\u0004\u0003|i\u0012\r!!\u0004\t\u000f\re\"\b1\u0001\u0004\u001c\u0005)!-\u001f;fg\"91Q\b\u001eA\u0002\u0005\u001d\u0016\u0001D:fe&\fG.\u001b>fe&#\u0007bBB!u\u0001\u000711I\u0001\u0006G2\f'P\u001f\t\u0006W\nm3Q\t\u0019\u0005\u0007\u000f\u001aY\u0005\u0005\u0003y\u007f\u000e%\u0003\u0003BA\u0004\u0007\u0017\"Ab!\u0014\u0004P\u0005\u0005\t\u0011!B\u0001\u0007?\u00121a\u0018\u00135\u0011\u001d\u0019\tE\u000fa\u0001\u0007#\u0002Ra\u001bB.\u0007'\u0002Da!\u0016\u0004ZA!\u0001p`B,!\u0011\t9a!\u0017\u0005\u0019\r53qJA\u0001\u0002\u0003\u0015\taa\u0017\u0012\t\u0005=1Q\f\t\u0005\u0003\u000f\u0019)$\u0005\u0003\u0002\u0010\rM\u0002f\u0002\u001e\u0004d\r%4Q\u000e\t\u0004W\u000e\u0015\u0014bAB4Y\nQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\r-\u0014\u0001P+tK\u0002\"Wm]3sS\u0006d\u0017N_3!i\"\fG\u000fI1dG\u0016\u0004Ho\u001d\u0011uQ\u0016\u0004\u0003-\\1oS\u001a,7\u000f\u001e1!CN\u0004\u0013\rI2mCN\u001c\bE\\1nK:\n#aa\u001c\u0002\u0015\u0005[7.\u0019\u00113]Yr\u0003\u0007\u0006\u0005\u0004t\rU4qOB=!\u0015\t9ca\u0006k\u0011\u001d\u0019Id\u000fa\u0001\u00077Aqa!\u0010<\u0001\u0004\t9\u000bC\u0004\u0004|m\u0002\rA!\u0007\u0002\u00115\fg.\u001b4fgR\fA\u0003Z3tKJL\u0017\r\\5{K\nKH/Z!se\u0006LHc\u00026\u0004\u0002\u000e\r5q\u0011\u0005\b\u0007sa\u0004\u0019AB\u000e\u0011\u001d\u0019)\t\u0010a\u0001\u00037\t!b]3sS\u0006d\u0017N_3s\u0011\u001d\u0019Y\b\u0010a\u0001\u00053\tQ\u0003Z3tKJL\u0017\r\\5{K\nKH/\u001a\"vM\u001a,'\u000fF\u0004k\u0007\u001b\u001bija(\t\u000f\r=U\b1\u0001\u0004\u0012\u0006\u0019!-\u001e4\u0011\t\rM5\u0011T\u0007\u0003\u0007+SAaa&\u0002\u001c\u0006\u0019a.[8\n\t\rm5Q\u0013\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBB\u001f{\u0001\u0007\u0011q\u0015\u0005\b\u0007wj\u0004\u0019\u0001B\rQ\u0015i41UB[!\u0015Y7QUBU\u0013\r\u00199\u000b\u001c\u0002\u0007i\"\u0014xn^:\u0011\t\r-6\u0011W\u0007\u0003\u0007[SAaa,\u0002\u001c\u0006\u0011\u0011n\\\u0005\u0005\u0007g\u001biK\u0001\rO_R\u001cVM]5bY&T\u0018M\u00197f\u000bb\u001cW\r\u001d;j_:\u001c#a!+\u0016\t\re6q\u0018\u000b\u0007\u0007w\u001b\tma1\u0011\r\u0005\u001d2qCB_!\u0011\t9aa0\u0005\u000f\tmdH1\u0001\u0002\u000e!91\u0011\b A\u0002\rm\u0001bBB!}\u0001\u00071Q\u0019\t\u0005q~\u001ci,A\tgS:$7+\u001a:jC2L'0\u001a:G_J$B!a\u0007\u0004L\"11\u0011F A\u0002)\fQb]3sS\u0006d\u0017N_3s\r>\u0014H\u0003BA\u000e\u0007#Dqa!\u0011A\u0001\u0004\u0019\u0019\u000e\r\u0003\u0004V\u000ee\u0007\u0003\u0002=\u0000\u0007/\u0004B!a\u0002\u0004Z\u0012a11\\Bi\u0003\u0003\u0005\tQ!\u0001\u0002\u000e\t\u0019q\f\n\u001d)\u000b\u0001\u001b\u0019k!.\u0002\u0019M,'/[1mSj,'o\u00144\u0015\t\r\r8Q\u001d\t\u0007\u0003O\u00199\"a\u0007\t\u000f\r\u001d\u0018\t1\u0001\u0003\u001a\u0005i1/\u001a:jC2L'0\u001a:G#:#baa9\u0004l\u000e=\bbBBw\u0005\u0002\u0007!\u0011D\u0001\fE&tG-\u001b8h\u001d\u0006lW\rC\u0004\u0004h\n\u0003\rA!\u0007\u0002#M,'/[1mSj,'\u000fR3uC&d7/\u0006\u0002\u0004vB1!Q]B|\u0007wLAa!?\u0003h\n\u00191+Z9\u0011\u0007\u001d\u001ci0C\u0002\u0004\u0000v\u0013\u0011cU3sS\u0006d\u0017N_3s\t\u0016$\u0018-\u001b7t\u0003I\u0019XM]5bY&TXM\u001d#fi\u0006LGn\u001d\u0011\u0002\u0017M,'/[1mSj,'o]\u000b\u0003\t\u000f\u0001r\u0001\u001fB\u000b\u00053\tY\"\u0001\u0007tKJL\u0017\r\\5{KJ\u001c\b%\u0001\u0005cS:$\u0017N\\4t+\t!y\u0001\u0005\u0004\u0003f\u000e]H\u0011\u0003\t\u0004\u0005S\u001b\u0011!\u00032j]\u0012LgnZ:!\u0003q)gn];sK>sG._!mY><X\rZ*fe&\fG.\u001b>feN$B\u0001\"\u0007\u0005 A\u00191\u000eb\u0007\n\u0007\u0011uAN\u0001\u0003V]&$\bb\u0002C\u0011\u0013\u0002\u0007A1E\u0001\u0005SR,'\u000f\u0005\u0004\u0005&\u0011=\u00121\u0004\b\u0005\tO!YCD\u0002{\tSI\u0011!\\\u0005\u0004\t[a\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007$\tDC\u0002\u0005.1\f\u0001e^1s]VsW\r\u001f9fGR,GMT8o!\u0016\\7n\\*fe&\fG.\u001b>feR1\u0011\u0011\u001aC\u001c\t\u0007Bqa!\u0011K\u0001\u0004!I\u0004\r\u0003\u0005<\u0011}\u0002\u0003\u0002=\u0000\t{\u0001B!a\u0002\u0005@\u0011aA\u0011\tC\u001c\u0003\u0003\u0005\tQ!\u0001\u0002\u000e\t!q\fJ\u00191\u0011\u001d!)E\u0013a\u0001\u00037\t1a]3s\u0003M\u0019\u0007.Z2l\u000f>|w\r\\3Qe>$xNY;g)\u0011\tI\rb\u0013\t\u000f\u001153\n1\u0001\u0003\u001a\u0005I1\r\\1tg:\u000bW.Z\u0001\u0013G\",7m\u001b)fW.|\u0007K]8u_\n,h\r\u0006\u0003\u0002J\u0012M\u0003b\u0002C'\u0019\u0002\u0007!\u0011D\u0001\u000bG\",7m[\"mCN\u001cHCBAe\t3\"i\u0006C\u0004\u0005\\5\u0003\rA!\u0007\u0002\rA\u0014XMZ5y\u0011\u001d!i%\u0014a\u0001\u00053\tAa]8siR!Aq\u0002C2\u0011\u001d!)G\u0014a\u0001\tO\n!!\u001b8\u0011\r\u0011\u0015B\u0011\u000eC\t\u0013\u0011!Y\u0007\"\r\u0003\u0011%#XM]1cY\u0016\fQb]3sS\u0006d\u0017N_3s\u001b\u0006\u0004XC\u0001C9!!!\u0019\b\"\u001e\u0005z\u0005mQB\u0001Bm\u0013\u0011!9H!7\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\r\u0003\u0005|\u0011}\u0004\u0003\u0002=\u0000\t{\u0002B!a\u0002\u0005\u0000\u0011YA\u0011\u0011)\u0002\u0002\u0003\u0005)\u0011AA\u0007\u0005\u0011yF%M\u0019\u0002\u001dM,'/[1mSj,'/T1qA\u0005!2/\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif,\"\u0001\"#\u0011\u000fa\u0014)\"a*\u0002\u001c\u0005)2/\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif\u0004\u0013!G9vS\u000e\\7+\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif,\"\u0001\"%\u0011\u000b-\u001ci\"a\u0007\u00025E,\u0018nY6TKJL\u0017\r\\5{KJ\u0014\u00150\u00133f]RLG/\u001f\u0011\u0002#\u001d,GoU3sS\u0006d\u0017N_3s\u0005fLE\r\u0006\u0003\u0002\u001c\u0011e\u0005b\u0002CN+\u0002\u0007\u0011qU\u0001\u0003S\u0012\f\u0011%[:KCZ\f7+\u001a:jC2L'0\u0019;j_:<\u0016M\u001d8j]\u001e,e.\u00192mK\u0012\f!%[:KCZ\f7+\u001a:jC2L'0\u0019;j_:<\u0016M\u001d8j]\u001e,e.\u00192mK\u0012\u0004\u0013\u0001I5t/\u0006\u0014h.\u001b8h\u001f:tuNV3sS\u001aL7-\u0019;j_:,e.\u00192mK\u0012\f\u0011%[:XCJt\u0017N\\4P]:{g+\u001a:jM&\u001c\u0017\r^5p]\u0016s\u0017M\u00197fI\u0002\n!$[:ESN\fG\u000e\\8xK\u0012T\u0015M^1TKJL\u0017\r\\5{KJ$B!!3\u0005*\"91Q\u0011.A\u0002\u0005m\u0011!H:i_VdGmV1s]\u0006\u0013w.\u001e;KCZ\f7+\u001a:jC2L'0\u001a:\u0015\r\u0005%Gq\u0016C_\u0011\u001d!\tl\u0017a\u0001\tg\u000bqb]3sS\u0006d\u0017N_3e\u00072\f7o\u001d\u0019\u0005\tk#I\f\u0005\u0003y\u007f\u0012]\u0006\u0003BA\u0004\ts#A\u0002b/\u00050\u0006\u0005\t\u0011!B\u0001\u0003\u001b\u0011Aa\u0018\u00132g!91QQ.A\u0002\u0005m\u0001fA.\u0002d\u0002")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static Information getCurrentTransportInformation() {
        return Serialization$.MODULE$.getCurrentTransportInformation();
    }

    public static String serializedActorPath(ActorRef actorRef2) {
        return Serialization$.MODULE$.serializedActorPath(actorRef2);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    @InternalApi
    public Information serializationInformation() {
        return this.system().provider().serializationInformation();
    }

    private <T> T withTransportInformation(Function0<T> f) {
        T t;
        Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq(this.serializationInformation());
            }
            t = f.apply();
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
        }
        return t;
    }

    public Try<byte[]> serialize(Object o) {
        return (Try)this.withTransportInformation((Function0<Try> & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0<byte[]> & Serializable & scala.Serializable)() -> this.findSerializerFor(o).toBinary(o)));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(155).append("Cannot find serializer with id [").append(serializerId).append("]").append(clazz.map((Function1<Class, String> & Serializable & scala.Serializable)c -> new StringBuilder(11).append(" (class [").append(c.getName()).append("])").toString()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> "")).append(". ").append("The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.withTransportInformation((Function0<Object> & Serializable & scala.Serializable)() -> serializer2.fromBinary(bytes, clazz));
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringBuilder(169).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in sync between the two systems.").toString());
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        return this.withTransportInformation((Function0<Object> & Serializable & scala.Serializable)() -> {
            Serializer serializer = serializer;
            if (serializer instanceof SerializerWithStringManifest) {
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
                return serializerWithStringManifest.fromBinary(bytes, manifest);
            }
            String string = manifest;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return serializer.fromBinary(bytes, None$.MODULE$);
            }
            Map<String, Option<Class<?>>> cache = this.manifestCache().get();
            Option option = cache.get(manifest);
            if (option instanceof Some) {
                Some some = (Some)option;
                Option cachedClassManifest = (Option)some.value();
                return serializer.fromBinary(bytes, cachedClassManifest);
            }
            if (None$.MODULE$.equals(option)) {
                Try<Class<Object>> try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Class classManifest = (Class)success.value();
                    Some classManifestOption = new Some(classManifest);
                    this.updateCache$1(cache, manifest, classManifestOption);
                    return serializer.fromBinary(bytes, classManifestOption);
                }
                if (try_ instanceof Failure) {
                    throw new NotSerializableException(new StringBuilder(56).append("Cannot find manifest class [").append(manifest).append("] for serializer with id [").append(serializer.identifier()).append("].").toString());
                }
                throw new MatchError(try_);
            }
            throw new MatchError(option);
        });
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        try {
            serializer = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringBuilder(170).append("Cannot find serializer with id [").append(serializerId).append("] (manifest [").append(manifest).append("]). The most probable reason is that the configuration entry ").append("pekko.actor.serializers is not in synch between the two systems.").toString());
        }
        Serializer serializer2 = serializer;
        Information oldInfo = Serialization$.MODULE$.currentTransportInformation().value();
        try {
            Serializer serializer3;
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq(this.serializationInformation());
            }
            if ((serializer3 = serializer2) instanceof ByteBufferSerializer) {
                Serializer serializer4 = serializer3;
                object = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
            } else {
                byte[] bytes = new byte[buf.remaining()];
                buf.get(bytes);
                object = this.deserializeByteArray(bytes, serializer2, manifest);
            }
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq(oldInfo);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return (Try)this.withTransportInformation((Function0<Try> & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0<Object> & Serializable & scala.Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, new Some(clazz))));
    }

    public Serializer findSerializerFor(Object o) {
        if (o == null) {
            return NullSerializer$.MODULE$;
        }
        return this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer = this.serializerMap().get(clazz);
        if (serializer == null) {
            Serializer serializer2;
            Seq seq = (Seq)this.bindings().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializerFor$3(clazz, x0$1)));
            Some<Seq> some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringBuilder(49).append("No configured serialization-bindings for class [").append(clazz.getName()).append("]").toString());
            }
            if (Serialization.unique$1(seq)) {
                serializer2 = (Serializer)((Tuple2)seq.head())._2();
            } else {
                Seq possibilitiesWithoutJavaSerializer = (Seq)seq.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializerFor$4(x0$2)));
                if (possibilitiesWithoutJavaSerializer.isEmpty()) {
                    throw new NotSerializableException(new StringBuilder(52).append("More than one JavaSerializer configured for class [").append(clazz.getName()).append("]").toString());
                }
                if (!Serialization.unique$1(possibilitiesWithoutJavaSerializer)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for [{}], choosing first of: [{}]", (Object)clazz.getName(), (Object)((TraversableOnce)possibilitiesWithoutJavaSerializer.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 != null) {
                            Serializer s = (Serializer)tuple2._2();
                            return s.getClass().getName();
                        }
                        throw new MatchError(tuple2);
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
                }
                serializer2 = (Serializer)((Tuple2)possibilitiesWithoutJavaSerializer.head())._2();
            }
            Serializer ser = serializer2;
            Serializer serializer3 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer3 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'pekko.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                if (!this.warnUnexpectedNonPekkoSerializer(clazz, ser)) {
                    this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                }
                return ser;
            }
            return serializer3;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.serializerOf("", serializerFQN);
    }

    /*
     * Unable to fully structure code
     */
    private Try<Serializer> serializerOf(String bindingName, String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var4_3 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, new $colon$colon<Nothing$>((Nothing$)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), this.system()), Nil$.MODULE$), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith(new scala.Serializable(this, fqn, bindingName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            public final String fqn$1;
            public final String bindingName$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof NoSuchMethodException) {
                    return (B1)this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)).recoverWith(new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$serializerOf$1 $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof NoSuchMethodException) {
                                NoSuchMethodException noSuchMethodException = (NoSuchMethodException)A1;
                                String string = this.$outer.bindingName$1;
                                String string2 = "";
                                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                    throw noSuchMethodException;
                                }
                                return (B1)this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system().dynamicAccess().createInstanceFor(this.$outer.fqn$1, new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), this.$outer.org$apache$pekko$serialization$Serialization$$anonfun$$$outer().system())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), this.$outer.bindingName$1)), Nil$.MODULE$)), ClassTag$.MODULE$.apply(Serializer.class));
                            }
                            return function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            return throwable instanceof NoSuchMethodException;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof NoSuchMethodException;
            }

            public /* synthetic */ Serialization org$apache$pekko$serialization$Serialization$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
                this.bindingName$1 = bindingName$1;
            }
        });
    }

    private Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        if (!this.system().settings().AllowJavaSerialization()) {
            Predef$.MODULE$.require(iter.forall((Function1<Serializer, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$ensureOnlyAllowedSerializers$1(this, x$6))), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Disallowed JavaSerializer binding.");
            return;
        }
    }

    private boolean warnUnexpectedNonPekkoSerializer(Class<?> clazz, Serializer ser) {
        if (clazz.getName().startsWith("org.apache.pekko.") && !ser.getClass().getName().startsWith("org.apache.pekko.")) {
            this.log().warning("Using serializer [{}] for message [{}]. Note that this serializer is not implemented by Apache Pekko. It's not recommended to replace serializers for messages provided by Apache Pekko.", (Object)ser.getClass().getName(), (Object)clazz.getName());
            return true;
        }
        return false;
    }

    private boolean checkGoogleProtobuf(String className) {
        return this.checkClass("com.google.protobuf", className);
    }

    private boolean checkPekkoProtobuf(String className) {
        return this.checkClass("org.apache.pekko.protobuf", className);
    }

    private boolean checkClass(String prefix, String className) {
        return !className.startsWith(prefix) || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        return ((TraversableLike)in.foldLeft(new ArrayBuffer(in.size()), (Function2<ArrayBuffer, Tuple2, ArrayBuffer> & Serializable & scala.Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$sort$2(ca, x$7)));
            switch (n) {
                case -1: {
                    buf.append(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
                default: {
                    buf.insert(n, Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
            }
            return buf;
        })).to(org.apache.pekko.util.ccompat.package$.MODULE$.genericCompanionToCBF(Seq$.MODULE$));
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer = this.quickSerializerByIdentity()[id];
            if (serializer == null) {
                throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(id).toString());
            }
            return serializer;
        }
        return (Serializer)this.serializerByIdentity().apply(BoxesRunTime.boxToInteger(id));
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("org.apache.pekko.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated(key, value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(false))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals(x$2._2(), ((Tuple2)possibilities$1.apply(false))._2());
    }

    private static final boolean unique$1(Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Class c = (Class)tuple2._1();
            return c.isAssignableFrom(clazz$3);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null && tuple2._2() instanceof JavaSerializer) {
            return false;
        }
        return tuple2 == null || !(tuple2._2() instanceof DisabledJavaSerializer);
    }

    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 != null) {
            String className = (String)tuple2._1();
            String alias = (String)tuple2._2();
            if (className != null && alias != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            String className = (String)tuple2._1();
            String alias = (String)tuple2._2();
            if (className != null) {
                String string = className;
                if (alias != null) {
                    String string2;
                    String string3 = string2 = alias;
                    String string4 = "none";
                    return (string3 == null ? string4 != null : !string3.equals(string4)) && $this.checkGoogleProtobuf(string) && $this.checkPekkoProtobuf(string);
                }
            }
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$bindings$7(Serialization $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            Class clazz = (Class)tuple2._1();
            Serializer ser = (Serializer)tuple2._2();
            return $this.warnUnexpectedNonPekkoSerializer(clazz, ser);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$1(Serialization $this, Serializer x$6) {
        return !$this.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$7) {
        return ((Class)x$7._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                return;
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Seq<SerializerDetails> seq;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<GenMap>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            seq = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SerializationSetup setting = (SerializationSetup)some.value();
            seq = setting.createSerializers().apply(system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = seq.collect(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `pekko.actor.allow-java-serialization = off`.");
                    return (B1)SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                }
                return (B1)A12;
            }

            public final boolean isDefinedAt(SerializerDetails x1) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x1;
                if (serializerDetails2 != null && this.$outer.org$apache$pekko$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer())) {
                    return true;
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map fromConfig = this.settings().Serializers().withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k != null) {
                    String string = k;
                    if (v != null) {
                        String string2 = v;
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(string), this.serializerOf(string, string2).get());
                    }
                }
            }
            throw new MatchError(tuple2);
        }, Map$.MODULE$.canBuildFrom());
        Map result = fromConfig.$plus$plus(this.serializerDetails().map((Function1<SerializerDetails, Tuple2> & Serializable & scala.Serializable)d -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(d.alias()), d.serializer()), Seq$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers(result.iterator().map((Function1<Tuple2, Serializer> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Serializer ser = (Serializer)tuple2._2();
                return ser;
            }
            throw new MatchError(tuple2);
        }));
        this.serializers = result;
        scala.collection.immutable.Iterable fromConfig2 = this.settings().SerializationBindings().withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$bindings$2(this, x$4))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 != null) {
                String className = (String)tuple2._1();
                String alias = (String)tuple2._2();
                if (className != null) {
                    String string = className;
                    if (alias != null) {
                        String string2 = alias;
                        return new Tuple2(this.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.serializers().apply(string2));
                    }
                }
            }
            throw new MatchError(tuple2);
        }, Iterable$.MODULE$.canBuildFrom());
        Seq fromSettings = this.serializerDetails().flatMap((Function1<SerializerDetails, Seq> & Serializable & scala.Serializable)detail -> detail.useFor().map((Function1<Class, Tuple2> & Serializable & scala.Serializable)clazz -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(clazz), detail.serializer()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort(fromConfig2.$plus$plus(fromSettings, Iterable$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers(result2.iterator().map((Function1<Tuple2, Serializer> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Serializer ser = (Serializer)tuple2._2();
                return ser;
            }
            throw new MatchError(tuple2);
        }));
        result2.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean(Serialization.$anonfun$bindings$7(this, x0$3)));
        this.bindings = result2;
        this.serializerMap = this.bindings().foldLeft(new ConcurrentHashMap(), (Function2<ConcurrentHashMap, Tuple2, ConcurrentHashMap> & Serializable & scala.Serializable)(x0$4, x1$1) -> {
            Tuple2<ConcurrentHashMap, Tuple2> tuple2 = new Tuple2<ConcurrentHashMap, Tuple2>((ConcurrentHashMap)x0$4, (Tuple2)x1$1);
            if (tuple2 != null) {
                ConcurrentHashMap map = tuple2._1();
                Tuple2 tuple22 = tuple2._2();
                if (tuple22 != null) {
                    Class c = (Class)tuple22._1();
                    Serializer s = (Serializer)tuple22._2();
                    map.put(c, s);
                    return map;
                }
            }
            throw new MatchError(tuple2);
        });
        Map zero = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(NullSerializer$.MODULE$.identifier())), NullSerializer$.MODULE$)}));
        this.serializerByIdentity = this.serializers().foldLeft(zero, (Function2<Map, Tuple2, Map> & Serializable & scala.Serializable)(x0$5, x1$2) -> {
            Tuple2<Map, Tuple2> tuple2 = new Tuple2<Map, Tuple2>((Map)x0$5, (Tuple2)x1$2);
            if (tuple2 != null) {
                Map acc2 = tuple2._1();
                Tuple2 tuple22 = tuple2._2();
                if (tuple22 != null) {
                    Serializer ser = (Serializer)tuple22._2();
                    int id = ser.identifier();
                    Option option = acc2.get(BoxesRunTime.boxToInteger(id));
                    if (option instanceof Some) {
                        Serializer existing;
                        Some some = (Some)option;
                        Serializer serializer = existing = (Serializer)some.value();
                        Serializer serializer2 = ser;
                        if (serializer == null ? serializer2 != null : !serializer.equals(serializer2)) {
                            throw new IllegalArgumentException(new StringBuilder(68).append("Serializer identifier [").append(id).append("] of [").append(ser.getClass().getName()).append("] ").append("is not unique. It is also used by [").append(acc2.apply(BoxesRunTime.boxToInteger(id)).getClass().getName()).append("].").toString());
                        }
                    }
                    return acc2.updated(BoxesRunTime.boxToInteger(id), ser);
                }
            }
            throw new MatchError(tuple2);
        });
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$6 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$6);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("pekko.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("pekko.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    scala.Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        @Override
        public String productPrefix() {
            return "Information";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.address();
                }
                case 1: {
                    return this.system();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$(this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return ((TraversableOnce)package$JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(k), v.toString());
                }
                throw new MatchError(tuple2);
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("pekko.actor.serializers"));
            Config bindings = config.getConfig("pekko.actor.serialization-bindings");
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

