/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.agrona.collections.Object2IntHashMap;
import org.apache.pekko.remote.artery.compress.CompressionTable$;
import org.apache.pekko.remote.artery.compress.DecompressionTable;
import org.apache.pekko.remote.artery.compress.DecompressionTable$;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud!B\r\u001b\u0005y1\u0003\u0002\u0003\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\t\u0011Q\u0002!\u0011!Q\u0001\nEB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005o!A1\b\u0001BC\u0002\u0013%A\b\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003>\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015Y\u0002\u0001\"\u0001i\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015)\b\u0001\"\u0011w\u0011\u00159\b\u0001\"\u0011y\u000f\u0019q(\u0004#\u0001\u001f\u007f\u001a9\u0011D\u0007E\u0001=\u0005\u0005\u0001BB)\u0010\t\u0003\t\u0019\u0001C\u0005\u0002\u0006=\u0011\r\u0011\"\u0002\u0002\b!A\u0011QB\b!\u0002\u001b\tI\u0001C\u0005\u0002\u0010=\u0011\r\u0011\"\u0002\u0002\u0012!A\u0011QG\b!\u0002\u001b\t\u0019\u0002C\u0004\u00028=!\t!!\u000f\t\u000f\u0005\u0015s\u0002\"\u0003\u0002H!9\u0011QK\b\u0005\u0002\u0005]\u0003bBA1\u001f\u0011\u0005\u00111\r\u0002\u0011\u0007>l\u0007O]3tg&|g\u000eV1cY\u0016T!a\u0007\u000f\u0002\u0011\r|W\u000e\u001d:fgNT!!\b\u0010\u0002\r\u0005\u0014H/\u001a:z\u0015\ty\u0002%\u0001\u0004sK6|G/\u001a\u0006\u0003C\t\nQ\u0001]3lW>T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sOV\u0011qeR\n\u0003\u0001!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0017!C8sS\u001eLg.V5e\u0007\u0001)\u0012!\r\t\u0003SIJ!a\r\u0016\u0003\t1{gnZ\u0001\u000b_JLw-\u001b8VS\u0012\u0004\u0013a\u0002<feNLwN\\\u000b\u0002oA\u0011\u0011\u0006O\u0005\u0003s)\u0012AAQ=uK\u0006Aa/\u001a:tS>t\u0007%A\u0006`I&\u001cG/[8oCJLX#A\u001f\u0011\u0007y\u001aU)D\u0001@\u0015\t\u0001\u0015)A\u0006d_2dWm\u0019;j_:\u001c(B\u0001\"%\u0003\u0019\twM]8oC&\u0011Ai\u0010\u0002\u0012\u001f\nTWm\u0019;3\u0013:$\b*Y:i\u001b\u0006\u0004\bC\u0001$H\u0019\u0001!Q\u0001\u0013\u0001C\u0002%\u0013\u0011\u0001V\t\u0003\u00156\u0003\"!K&\n\u00051S#a\u0002(pi\"Lgn\u001a\t\u0003S9K!a\u0014\u0016\u0003\u0007\u0005s\u00170\u0001\u0007`I&\u001cG/[8oCJL\b%\u0001\u0004=S:LGO\u0010\u000b\u0005'V3v\u000bE\u0002U\u0001\u0015k\u0011A\u0007\u0005\u0006]\u001d\u0001\r!\r\u0005\u0006k\u001d\u0001\ra\u000e\u0005\u0006w\u001d\u0001\r!P\u0001\u000bI&\u001cG/[8oCJLX#\u0001.\u0011\tm\u0013W)\u001a\b\u00039\u0002\u0004\"!\u0018\u0016\u000e\u0003yS!aX\u0018\u0002\rq\u0012xn\u001c;?\u0013\t\t'&\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u00141!T1q\u0015\t\t'\u0006\u0005\u0002*M&\u0011qM\u000b\u0002\u0004\u0013:$HCA3j\u0011\u0015Q\u0017\u00021\u0001F\u0003\u00151\u0018\r\\;f\u0003\u0019IgN^3siV\tQ\u000eE\u0002U]\u0016K!a\u001c\u000e\u0003%\u0011+7m\\7qe\u0016\u001c8/[8o)\u0006\u0014G.Z\u0001\ti>\u001cFO]5oOR\t!\u000f\u0005\u0002\\g&\u0011A\u000f\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!Z\u0001\u0007KF,\u0018\r\\:\u0015\u0005ed\bCA\u0015{\u0013\tY(FA\u0004C_>dW-\u00198\t\u000bul\u0001\u0019A'\u0002\u0007=\u0014'.\u0001\tD_6\u0004(/Z:tS>tG+\u00192mKB\u0011AkD\n\u0003\u001f!\"\u0012a`\u0001\u0010\u001d>$8i\\7qe\u0016\u001c8/\u001a3JIV\u0011\u0011\u0011B\b\u0003\u0003\u0017i\u0012a\u0000\u0001\u0011\u001d>$8i\\7qe\u0016\u001c8/\u001a3JI\u0002\n\u0011cQ8na\u0006\u0014XMQ=3]\u00124\u0016\r\\;f+\t\t\u0019\u0002\u0005\u0004\u0002\u0016\u0005}\u00111E\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005!Q\u000f^5m\u0015\t\ti\"\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u0003/\u0011!bQ8na\u0006\u0014\u0018\r^8s!\u0019I\u0013QEA\u0015K&\u0019\u0011q\u0005\u0016\u0003\rQ+\b\u000f\\33!\u0011\tY#!\r\u000e\u0005\u00055\"\u0002BA\u0018\u00037\tA\u0001\\1oO&!\u00111GA\u0017\u0005\u0019y%M[3di\u0006\u00112i\\7qCJ,')\u001f\u001aoIZ\u000bG.^3!\u0003E\u0019w.\u001c9be\u0016\u0014\u0015P\r8e-\u0006dW/Z\u000b\u0005\u0003w\t\u0019%\u0006\u0002\u0002>A1\u0011QCA\u0010\u0003\u007f\u0001b!KA\u0013\u0003\u0003*\u0007c\u0001$\u0002D\u0011)\u0001*\u0006b\u0001\u0013\u0006!b.Z<PE*,7\r\u001e\u001aJ]RD\u0015m\u001d5NCB,B!!\u0013\u0002PQ!\u00111JA)!\u0011q4)!\u0014\u0011\u0007\u0019\u000by\u0005B\u0003I-\t\u0007\u0011\n\u0003\u0004\u0002TY\u0001\r!Z\u0001\u0010S:LG/[1m\u0007\u0006\u0004\u0018mY5us\u0006)Q-\u001c9usV!\u0011\u0011LA0+\t\tY\u0006\u0005\u0003U\u0001\u0005u\u0003c\u0001$\u0002`\u0011)\u0001j\u0006b\u0001\u0013\u0006)\u0011\r\u001d9msV!\u0011QMA6)!\t9'!\u001c\u0002p\u0005E\u0004\u0003\u0002+\u0001\u0003S\u00022ARA6\t\u0015A\u0005D1\u0001J\u0011\u0015q\u0003\u00041\u00012\u0011\u0015)\u0004\u00041\u00018\u0011\u0019A\u0006\u00041\u0001\u0002tA)1LYA5K\u0002")
public final class CompressionTable<T> {
    private final long originUid;
    private final byte version;
    private final Object2IntHashMap<T> _dictionary;

    public static <T> CompressionTable<T> apply(long l, byte by, Map<T, Object> map) {
        return CompressionTable$.MODULE$.apply(l, by, map);
    }

    public static <T> CompressionTable<T> empty() {
        return CompressionTable$.MODULE$.empty();
    }

    public static <T> Comparator<Tuple2<T, Object>> compareBy2ndValue() {
        return CompressionTable$.MODULE$.compareBy2ndValue();
    }

    public static Comparator<Tuple2<Object, Object>> CompareBy2ndValue() {
        return CompressionTable$.MODULE$.CompareBy2ndValue();
    }

    public static int NotCompressedId() {
        return CompressionTable$.MODULE$.NotCompressedId();
    }

    public long originUid() {
        return this.originUid;
    }

    public byte version() {
        return this.version;
    }

    private Object2IntHashMap<T> _dictionary() {
        return this._dictionary;
    }

    public Map<T, Object> dictionary() {
        return package$JavaConverters$.MODULE$.asScalaIteratorConverter(this._dictionary().entrySet().iterator()).asScala().map((Function1<Map.Entry, Tuple2> & Serializable & scala.Serializable)entry -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getKey()), BoxesRunTime.boxToInteger((Integer)entry.getValue()))).toMap(Predef$.MODULE$.$conforms());
    }

    public int compress(T value) {
        return this._dictionary().getValue(value);
    }

    public DecompressionTable<T> invert() {
        int i;
        if (this._dictionary().isEmpty()) {
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            long x$12 = this.originUid();
            byte x$2 = this.version();
            Object x$3 = qual$1.copy$default$3();
            return qual$1.copy(x$12, x$2, x$3);
        }
        Integer expectedGaplessSum = this._dictionary().size() * (this._dictionary().size() + 1) / 2;
        Predef$.MODULE$.require(BoxesRunTime.equals(((TraversableOnce)package$JavaConverters$.MODULE$.asScalaIteratorConverter(this._dictionary().values().iterator()).asScala()).min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), BoxesRunTime.boxToInteger(0)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Compression table should start allocating from 0, yet lowest allocated id was ").append(((TraversableOnce)package$JavaConverters$.MODULE$.asScalaIteratorConverter(this._dictionary().values().iterator()).asScala()).min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).toString());
        Predef$.MODULE$.require(BoxesRunTime.equals(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(package$JavaConverters$.MODULE$.asScalaIteratorConverter(this._dictionary().values().iterator()).asScala().map((Function1<Integer, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1)).sum(Numeric$IntIsIntegral$.MODULE$)) + this._dictionary().size()), expectedGaplessSum), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(149).append("Given compression map does not seem to be gap-less and starting from zero, which makes compressing it into an Array difficult, bailing out! Map was: ").append(this._dictionary()).toString());
        Tuple2[] tups = new Tuple2[this._dictionary().size()];
        Object[] ts = new Object[this._dictionary().size()];
        Object2IntHashMap.EntryIterator mit = this._dictionary().entrySet().iterator();
        for (i = 0; i < tups.length; ++i) {
            Object entry = mit.next();
            tups[i] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getKey()), BoxesRunTime.boxToInteger((Integer)entry.getValue()));
        }
        Arrays.sort((Object[])tups, CompressionTable$.MODULE$.compareBy2ndValue());
        for (i = 0; i < tups.length; ++i) {
            ScalaRunTime$.MODULE$.array_update(ts, i, tups[i]._1());
        }
        return new DecompressionTable(this.originUid(), this.version(), ts);
    }

    public String toString() {
        return new StringBuilder(20).append("CompressionTable(").append(this.originUid()).append(",").append(this.version()).append(",").append(this.dictionary()).append(")").toString();
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.originUid());
        result = HashCode$.MODULE$.hash(result, this.version());
        result = HashCode$.MODULE$.hash(result, this._dictionary());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof CompressionTable)) return false;
        CompressionTable compressionTable = (CompressionTable)object;
        if (this.originUid() != compressionTable.originUid()) return false;
        if (this.version() != compressionTable.version()) return false;
        Object2IntHashMap<T> object2IntHashMap = this._dictionary();
        Object2IntHashMap<T> object2IntHashMap2 = compressionTable._dictionary();
        if (object2IntHashMap != null) {
            if (!((Object)object2IntHashMap).equals(object2IntHashMap2)) return false;
            return true;
        }
        if (object2IntHashMap2 == null) return true;
        return false;
    }

    public CompressionTable(long originUid, byte version, Object2IntHashMap<T> _dictionary) {
        this.originUid = originUid;
        this.version = version;
        this._dictionary = _dictionary;
    }
}

