/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.aeron;

import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteTransportException;
import org.apache.pekko.remote.artery.ArteryTransport;
import org.apache.pekko.remote.artery.ArteryTransport$;
import org.apache.pekko.remote.artery.ArteryTransport$ShuttingDown$;
import org.apache.pekko.remote.artery.Decoder;
import org.apache.pekko.remote.artery.DuplicateFlush;
import org.apache.pekko.remote.artery.DuplicateHandshakeReq;
import org.apache.pekko.remote.artery.EnvelopeBuffer;
import org.apache.pekko.remote.artery.EnvelopeBufferPool;
import org.apache.pekko.remote.artery.FixedSizePartitionHub;
import org.apache.pekko.remote.artery.InboundControlJunction;
import org.apache.pekko.remote.artery.InboundEnvelope;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.aeron.AeronErrorLog;
import org.apache.pekko.remote.artery.aeron.AeronSink;
import org.apache.pekko.remote.artery.aeron.AeronSource;
import org.apache.pekko.remote.artery.aeron.ArteryAeronUdpTransport$;
import org.apache.pekko.remote.artery.aeron.TaskRunner;
import org.apache.pekko.remote.artery.aeron.TaskRunner$;
import org.apache.pekko.remote.artery.compress.NoInboundCompressions$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.KillSwitches$;
import org.apache.pekko.stream.SharedKillSwitch;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.FlowOps;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.RunnableGraph;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcII$sp;
import scala.Tuple3;
import scala.collection.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcV$sp;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh!\u0002\u0011\"\u0001\u0015j\u0003\"\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b;\u0011%q\u0004A!A!\u0002\u0013y4\tC\u0003F\u0001\u0011\u0005a)\u0002\u0003L\u0001\u0001b\u0005BB*\u0001A\u0003%A\u000bC\u0005#\u0001\u0001\u0007\t\u0011)Q\u0005_\"Iq\u000f\u0001a\u0001\u0002\u0003\u0006K\u0001\u001f\u0005\ny\u0002\u0001\r\u0011!Q!\naD\u0011B \u0001A\u0002\u0003\u0005\u000b\u0015B@\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\t\u000f\u0005M\u0001\u0001\"\u0003\u0002\u0016!9\u0011q\u0007\u0001\u0005R\u0005e\u0002bBA!\u0001\u0011%\u0011\u0011\b\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t9\u0005\u0001C\u0005\u0003sAq!!\u0013\u0001\t\u0013\tI\u0004C\u0004\u0002L\u0001!I!!\u000f\t\u000f\u00055\u0003\u0001\"\u0003\u0002:!9\u0011q\n\u0001\u0005\n\u0005e\u0002bBA)\u0001\u0011E\u00131\u000b\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\ty\u000b\u0001C\u0005\u0003cCq!a-\u0001\t#\n)\fC\u0004\u0002>\u0002!\t&a0\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"9\u0011q\u001a\u0001\u0005\n\u0005E\u0007bBAk\u0001\u0011%\u0011q\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\tI\u000f\u0001C)\u0003WDq!!<\u0001\t\u0003\tyOA\fBeR,'/_!fe>tW\u000b\u001a9Ue\u0006t7\u000f]8si*\u0011!eI\u0001\u0006C\u0016\u0014xN\u001c\u0006\u0003I\u0015\na!\u0019:uKJL(B\u0001\u0014(\u0003\u0019\u0011X-\\8uK*\u0011\u0001&K\u0001\u0006a\u0016\\7n\u001c\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0005\u0002\u0001]A\u0011q\u0006M\u0007\u0002G%\u0011\u0011g\t\u0002\u0010\u0003J$XM]=Ue\u0006t7\u000f]8si\u00069ql]=ti\u0016l7\u0001\u0001\t\u0003kaj\u0011A\u000e\u0006\u0003o\u001d\nQ!Y2u_JL!!\u000f\u001c\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\n\u0005mb\u0014AB:zgR,W.\u0003\u0002>K\ty!+Z7pi\u0016$&/\u00198ta>\u0014H/A\u0005`aJ|g/\u001b3feB\u0011\u0001)Q\u0007\u0002K%\u0011!)\n\u0002\u0017%\u0016lw\u000e^3BGR|'OU3g!J|g/\u001b3fe&\u0011A\tP\u0001\taJ|g/\u001b3fe\u00061A(\u001b8jiz\"2aR%K!\tA\u0005!D\u0001\"\u0011\u0015\u00114\u00011\u00015\u0011\u0015q4\u00011\u0001@\u0005%a\u0015NZ3Ds\u000edW\r\u0005\u0002N!:\u0011\u0001JT\u0005\u0003\u001f\u0006\n1\"Q3s_:\u001cv.\u001e:dK&\u0011\u0011K\u0015\u0002\u000f\u0003\u0016\u0014xN\u001c'jM\u0016\u001c\u0017p\u00197f\u0015\ty\u0015%A\u0006nK\u0012L\u0017\r\u0012:jm\u0016\u0014\bcA+_A6\taK\u0003\u0002X1\u00061\u0011\r^8nS\u000eT!!\u0017.\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\\9\u0006!Q\u000f^5m\u0015\u0005i\u0016\u0001\u00026bm\u0006L!a\u0018,\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042!\u00193g\u001b\u0005\u0011'\"A2\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0014'AB(qi&|g\u000e\u0005\u0002h[6\t\u0001N\u0003\u0002jU\u00061AM]5wKJT!AI6\u000b\u00031\f!![8\n\u00059D'aC'fI&\fGI]5wKJ\u0004\"\u0001]9\u000e\u0003)L!A\u001d6\u0003\u000b\u0005+'o\u001c8)\u0005\u0019!\bCA1v\u0013\t1(M\u0001\u0005w_2\fG/\u001b7f\u0003A\tWM]8o\u0007>,h\u000e^3s)\u0006\u001c8\u000e\u0005\u00026s&\u0011!P\u000e\u0002\f\u0007\u0006t7-\u001a7mC\ndW\r\u000b\u0002\bi\u0006\t\u0012-\u001a:p]\u0016\u0013(o\u001c:M_\u001e$\u0016m]6)\u0005!!\u0018!D1fe>tWI\u001d:pe2{w\rE\u0002I\u0003\u0003I1!a\u0001\"\u00055\tUM]8o\u000bJ\u0014xN\u001d'pO\"\u0012\u0011\u0002^\u0001\u000bi\u0006\u001c8NU;o]\u0016\u0014XCAA\u0006!\rA\u0015QB\u0005\u0004\u0003\u001f\t#A\u0003+bg.\u0014VO\u001c8fe\u0006YA/Y:l%Vtg.\u001a:!\u0003=yW\u000f\u001e2pk:$7\t[1o]\u0016dG\u0003BA\f\u0003[\u0001B!!\u0007\u0002(9!\u00111DA\u0012!\r\tiBY\u0007\u0003\u0003?Q1!!\t4\u0003\u0019a$o\\8u}%\u0019\u0011Q\u00052\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)C\u0019\u0005\b\u0003_a\u0001\u0019AA\u0019\u0003\u0005\t\u0007cA\u001b\u00024%\u0019\u0011Q\u0007\u001c\u0003\u000f\u0005#GM]3tg\u0006q1\u000f^1siR\u0013\u0018M\\:q_J$HCAA\u001e!\r\t\u0017QH\u0005\u0004\u0003\u007f\u0011'\u0001B+oSR\f\u0001c\u001d;beRlU\rZ5b\tJLg/\u001a:\u0002\u0011\u0005,'o\u001c8ESJ,\"!a\u0006\u0002\u001fM$x\u000e]'fI&\fGI]5wKJ\f!b\u001d;beR\fUM]8o\u0003]\u0011Gn\\2l+:$\u0018\u000e\\\"iC:tW\r\\!di&4X-\u0001\nti\u0006\u0014H/Q3s_:,%O]8s\u0019><\u0017\u0001F:uCJ$\u0018)\u001a:p]\u000e{WO\u001c;fe2{w-A\u000bpkR\u0014w.\u001e8e)J\fgn\u001d9peR\u001c\u0016N\\6\u0015\u0011\u0005U\u0013QPAD\u0003#\u0003\u0002\"a\u0016\u0002b\u0005\u0015\u00141N\u0007\u0003\u00033RA!a\u0017\u0002^\u0005A1oY1mC\u0012\u001cHNC\u0002\u0002`\u001d\naa\u001d;sK\u0006l\u0017\u0002BA2\u00033\u0012AaU5oWB\u0019q&a\u001a\n\u0007\u0005%4E\u0001\bF]Z,Gn\u001c9f\u0005V4g-\u001a:\u0011\r\u00055\u0014\u0011OA;\u001b\t\tyG\u0003\u0002ZE&!\u00111OA8\u0005\u00191U\u000f^;sKB!\u0011qOA=\u001b\u00059\u0013bAA>O\t!Ai\u001c8f\u0011\u001d\ty(\u0006a\u0001\u0003\u0003\u000bqb\\;uE>,h\u000eZ\"p]R,\u0007\u0010\u001e\t\u0004_\u0005\r\u0015bAACG\tyq*\u001e;c_VtGmQ8oi\u0016DH\u000fC\u0004\u0002\nV\u0001\r!a#\u0002\u0011M$(/Z1n\u0013\u0012\u00042!YAG\u0013\r\tyI\u0019\u0002\u0004\u0013:$\bbBAJ+\u0001\u0007\u0011QS\u0001\u000bEV4g-\u001a:Q_>d\u0007cA\u0018\u0002\u0018&\u0019\u0011\u0011T\u0012\u0003%\u0015sg/\u001a7pa\u0016\u0014UO\u001a4feB{w\u000e\\\u0001\fC\u0016\u0014xN\\*pkJ\u001cW\r\u0006\u0005\u0002 \u0006\u0015\u0016qUAV!\u001d\t9&!)\u0002f1KA!a)\u0002Z\t11k\\;sG\u0016Dq!!#\u0017\u0001\u0004\tY\tC\u0004\u0002*Z\u0001\r!!&\u0002\tA|w\u000e\u001c\u0005\b\u0003[3\u0002\u0019AA\f\u00039IgNY8v]\u0012\u001c\u0005.\u00198oK2\f1$Y3s_:\u001cv.\u001e:dKN\u0003\u0018N\u001c8j]\u001e\u001cFO]1uK\u001eLXCAAF\u0003I\u0011\u0017N\u001c3J]\n|WO\u001c3TiJ,\u0017-\\:\u0015\u0005\u0005]\u0006cB1\u0002:\u0006-\u00151R\u0005\u0004\u0003w\u0013'A\u0002+va2,''A\tsk:LeNY8v]\u0012\u001cFO]3b[N$b!a\u000f\u0002B\u0006\u0015\u0007bBAb3\u0001\u0007\u00111R\u0001\u0005a>\u0014H\u000fC\u0004\u0002Hf\u0001\r!a#\u0002\u0011\tLg\u000e\u001a)peR\fqC];o\u0013:\u0014w.\u001e8e\u0007>tGO]8m'R\u0014X-Y7\u0015\t\u0005m\u0012Q\u001a\u0005\b\u0003[S\u0002\u0019AA\f\u0003\u0001\u0012XO\\%oE>,h\u000eZ(sI&t\u0017M]=NKN\u001c\u0018mZ3t'R\u0014X-Y7\u0015\t\u0005m\u00121\u001b\u0005\b\u0003[[\u0002\u0019AA\f\u0003u\u0011XO\\%oE>,h\u000e\u001a'be\u001e,W*Z:tC\u001e,7o\u0015;sK\u0006lG\u0003BA\u001e\u00033Dq!!,\u001d\u0001\u0004\t9\"A\u000bva\u0012\fG/Z*ue\u0016\fW.T1u-\u0006dW/Z:\u0015\u0011\u0005m\u0012q\\Aq\u0003KDq!!#\u001e\u0001\u0004\tY\t\u0003\u0004\u0002dv\u0001\r\u0001T\u0001\u0015C\u0016\u0014xN\\*pkJ\u001cW\rT5gK\u000eL8\r\\3\t\u000f\u0005\u001dX\u00041\u0001\u0002l\u0005I1m\\7qY\u0016$X\rZ\u0001\u0012g\",H\u000fZ8x]R\u0013\u0018M\\:q_J$HCAA6\u00039\tW\u000f^8TK2,7\r\u001e)peR$B!a#\u0002r\"9\u00111_\u0010A\u0002\u0005]\u0011\u0001\u00035pgRt\u0017-\\3")
public class ArteryAeronUdpTransport
extends ArteryTransport {
    private final AtomicReference<Option<MediaDriver>> mediaDriver = new AtomicReference<None$>(None$.MODULE$);
    public volatile Aeron org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron;
    public volatile Cancellable org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask;
    public volatile Cancellable org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask;
    private volatile AeronErrorLog aeronErrorLog;
    private final TaskRunner org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner = new TaskRunner(this.system(), this.settings().Advanced().Aeron().IdleCpuLevel());

    public TaskRunner org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner() {
        return this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner;
    }

    private String outboundChannel(Address a) {
        return new StringBuilder(20).append("aeron:udp?endpoint=").append((Object)a.host().get()).append(":").append(a.port().get()).toString();
    }

    @Override
    public void startTransport() {
        this.startMediaDriver();
        this.startAeron();
        this.startAeronErrorLog();
        this.flightRecorder().transportAeronErrorLogStarted();
        if (this.settings().Advanced().Aeron().LogAeronCounters()) {
            this.startAeronCounterLog();
        }
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().start();
        this.flightRecorder().transportTaskRunnerStarted();
    }

    private void startMediaDriver() {
        if (this.settings().Advanced().Aeron().EmbeddedMediaDriver()) {
            MediaDriver.Context context;
            MediaDriver.Context driverContext = new MediaDriver.Context();
            if (new StringOps(Predef$.MODULE$.augmentString(this.settings().Advanced().Aeron().AeronDirectoryName())).nonEmpty()) {
                context = driverContext.aeronDirectoryName(this.settings().Advanced().Aeron().AeronDirectoryName());
            } else {
                String uniquePart = UUID.randomUUID().toString();
                String randomName = new StringBuilder(1).append(CommonContext.getAeronDirectoryName()).append(File.separator).append(this.system().name()).append("-").append(uniquePart).toString();
                context = driverContext.aeronDirectoryName(randomName);
            }
            driverContext.clientLivenessTimeoutNs(this.settings().Advanced().Aeron().ClientLivenessTimeout().toNanos());
            driverContext.publicationUnblockTimeoutNs(this.settings().Advanced().Aeron().PublicationUnblockTimeout().toNanos());
            driverContext.imageLivenessTimeoutNs(this.settings().Advanced().Aeron().ImageLivenessTimeout().toNanos());
            driverContext.driverTimeoutMs(this.settings().Advanced().Aeron().DriverTimeout().toMillis());
            int idleCpuLevel = this.settings().Advanced().Aeron().IdleCpuLevel();
            MediaDriver.Context context2 = idleCpuLevel == 10 ? driverContext.threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).conductorThreadFactory(this.system().threadFactory()).receiverThreadFactory(this.system().threadFactory()).senderThreadFactory(this.system().threadFactory()) : (idleCpuLevel == 1 ? driverContext.threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).sharedThreadFactory(this.system().threadFactory()) : (idleCpuLevel <= 7 ? driverContext.threadingMode(ThreadingMode.SHARED_NETWORK).sharedNetworkIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).sharedNetworkThreadFactory(this.system().threadFactory()).conductorThreadFactory(this.system().threadFactory()) : driverContext.threadingMode(ThreadingMode.DEDICATED).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).receiverThreadFactory(this.system().threadFactory()).senderThreadFactory(this.system().threadFactory()).conductorThreadFactory(this.system().threadFactory())));
            MediaDriver driver = MediaDriver.launchEmbedded((MediaDriver.Context)driverContext);
            this.log().info("Started embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            this.flightRecorder().transportMediaDriverStarted(driver.aeronDirectoryName());
            if (!this.mediaDriver.compareAndSet(None$.MODULE$, new Some<MediaDriver>(driver))) {
                throw new IllegalStateException("media driver started more than once");
            }
            return;
        }
    }

    private String aeronDir() {
        Option<MediaDriver> option = this.mediaDriver.get();
        if (option instanceof Some) {
            Some some = (Some)option;
            MediaDriver driver = (MediaDriver)some.value();
            return driver.aeronDirectoryName();
        }
        if (None$.MODULE$.equals(option)) {
            return this.settings().Advanced().Aeron().AeronDirectoryName();
        }
        throw new MatchError(option);
    }

    private void stopMediaDriver() {
        Option<MediaDriver> maybeDriver = this.mediaDriver.getAndSet(None$.MODULE$);
        maybeDriver.foreach((Function1<MediaDriver, Object> & Serializable & scala.Serializable)driver -> {
            ArteryAeronUdpTransport.$anonfun$stopMediaDriver$1(this, driver);
            return BoxedUnit.UNIT;
        });
    }

    private void startAeron() {
        Aeron.Context ctx = new Aeron.Context();
        ctx.driverTimeoutMs(this.settings().Advanced().Aeron().DriverTimeout().toMillis());
        ctx.threadFactory(this.system().threadFactory());
        ctx.availableImageHandler(new AvailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onAvailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(31).append("onAvailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ctx.unavailableImageHandler(new UnavailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onUnavailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(33).append("onUnavailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
                ((MapLike)this.$outer.streamMatValues().get()).valuesIterator().foreach((Function1<ArteryTransport.InboundStreamMatValues, Object> & Serializable & scala.Serializable)x0$1 -> {
                    $anon$2.$anonfun$onUnavailableImage$1(img, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onUnavailableImage$1(Image img$1, ArteryTransport.InboundStreamMatValues x0$1) {
                ArteryTransport.InboundStreamMatValues inboundStreamMatValues = x0$1;
                if (inboundStreamMatValues != null) {
                    AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)inboundStreamMatValues.lifeCycle();
                    resourceLife.onUnavailableImage(img$1.sessionId());
                    return;
                }
                throw new MatchError(inboundStreamMatValues);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onUnavailableImage$1$adapted(io.aeron.Image org.apache.pekko.remote.artery.ArteryTransport$InboundStreamMatValues )}, serializedLambda);
            }
        });
        ctx.errorHandler(new ErrorHandler(this){
            private final AtomicBoolean fatalErrorOccured;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            private AtomicBoolean fatalErrorOccured() {
                return this.fatalErrorOccured;
            }

            public void onError(Throwable cause) {
                Throwable throwable = cause;
                if (throwable instanceof ConductorServiceTimeoutException) {
                    ConductorServiceTimeoutException conductorServiceTimeoutException = (ConductorServiceTimeoutException)throwable;
                    this.handleFatalError((Throwable)conductorServiceTimeoutException);
                    return;
                }
                if (throwable instanceof DriverTimeoutException) {
                    DriverTimeoutException driverTimeoutException = (DriverTimeoutException)throwable;
                    this.handleFatalError(driverTimeoutException);
                    return;
                }
                if (throwable instanceof ArteryTransport.AeronTerminated) {
                    return;
                }
                this.$outer.log().error(cause, new StringBuilder(13).append("Aeron error, ").append(cause).toString());
            }

            private void handleFatalError(Throwable cause) {
                if (this.fatalErrorOccured().compareAndSet(false, true)) {
                    if (!this.$outer.isShutdown()) {
                        this.$outer.log().error(cause, "Fatal Aeron error {}. Have to terminate ActorSystem because it lost contact with the {} Aeron media driver. Possible configuration properties to mitigate the problem are 'client-liveness-timeout' or 'driver-timeout'. {}", (Object)Logging$.MODULE$.simpleName(cause), (Object)(this.$outer.settings().Advanced().Aeron().EmbeddedMediaDriver() ? "embedded" : "external"), (Object)cause);
                        this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop();
                        this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                        Serializable serializable = this.$outer.settings().Advanced().Aeron().LogAeronCounters() ? BoxesRunTime.boxToBoolean(this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask.cancel()) : BoxedUnit.UNIT;
                        this.$outer.system().terminate();
                        throw new ArteryTransport.AeronTerminated(cause);
                    }
                    return;
                }
                throw new ArteryTransport.AeronTerminated(cause);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fatalErrorOccured = new AtomicBoolean();
            }
        });
        ctx.aeronDirectoryName(this.aeronDir());
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron = Aeron.connect((Aeron.Context)ctx);
    }

    private void blockUntilChannelActive() {
        AeronSource.AeronLifecycle aeronLifecyle = (AeronSource.AeronLifecycle)((ArteryTransport.InboundStreamMatValues)((MapLike)this.streamMatValues().get()).apply(BoxesRunTime.boxToInteger(ArteryTransport$.MODULE$.ControlStreamId()))).lifeCycle();
        int waitInterval = 200;
        long retries = package$.MODULE$.max(1L, this.settings().Bind().BindTimeout().toMillis() / (long)waitInterval);
        this.retry$1(retries, aeronLifecyle, waitInterval);
    }

    private void startAeronErrorLog() {
        this.aeronErrorLog = new AeronErrorLog(new File(this.aeronDir(), "cnc.dat"), this.log());
        AtomicLong lastTimestamp = new AtomicLong(0L);
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask = this.system().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), () -> {
            if (!this.isShutdown()) {
                long newLastTimestamp = $this.aeronErrorLog.logErrors(this.log(), lastTimestamp.get());
                lastTimestamp.set(newLastTimestamp + 1L);
                return;
            }
        }, (ExecutionContext)ec);
    }

    private void startAeronCounterLog() {
        MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
        this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask = this.system().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), () -> {
            if (!this.isShutdown() && this.log().isDebugEnabled()) {
                $this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach(new CountersReader.MetaData(this){
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;

                    public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                        long value = this.$outer.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterId);
                        this.$outer.log().debug("Aeron Counter {}: {} {}]", BoxesRunTime.boxToInteger(counterId), (Object)BoxesRunTime.boxToLong(value), (Object)label);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
        }, (ExecutionContext)ec);
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        FiniteDuration giveUpAfter = streamId == ArteryTransport$.MODULE$.ControlStreamId() ? this.settings().Advanced().GiveUpSystemMessageAfter() : this.settings().Advanced().Aeron().GiveUpMessageAfter();
        return Sink$.MODULE$.fromGraph(new AeronSink(this.outboundChannel(outboundContext.remoteAddress()), streamId, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), bufferPool, giveUpAfter, this.flightRecorder()));
    }

    private Source<EnvelopeBuffer, AeronSource.AeronLifecycle> aeronSource(int streamId, EnvelopeBufferPool pool, String inboundChannel) {
        return Source$.MODULE$.fromGraph(new AeronSource(inboundChannel, streamId, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), pool, this.flightRecorder(), this.aeronSourceSpinningStrategy()));
    }

    private int aeronSourceSpinningStrategy() {
        if (this.settings().Advanced().InboundLanes() > 1 || this.settings().Advanced().Aeron().IdleCpuLevel() < 5) {
            return 0;
        }
        return 50 * this.settings().Advanced().Aeron().IdleCpuLevel() - 240;
    }

    @Override
    public Tuple2<Object, Object> bindInboundStreams() {
        int n;
        int n2;
        Tuple2$mcII$sp tuple2$mcII$sp = new Tuple2$mcII$sp(this.settings().Canonical().Port(), this.settings().Bind().Port());
        if (tuple2$mcII$sp != null) {
            int n3 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp();
            int n4 = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp();
            if (0 == n3 && 0 == n4) {
                int p = this.autoSelectPort(this.settings().Bind().Hostname());
                return new Tuple2$mcII$sp(p, p);
            }
        }
        if (tuple2$mcII$sp != null && 0 == (n2 = ((Tuple2)tuple2$mcII$sp)._1$mcI$sp())) {
            return new Tuple2$mcII$sp(this.settings().Bind().Port(), this.settings().Bind().Port());
        }
        if (tuple2$mcII$sp != null && 0 == (n = ((Tuple2)tuple2$mcII$sp)._2$mcI$sp())) {
            return new Tuple2$mcII$sp(this.settings().Canonical().Port(), this.autoSelectPort(this.settings().Bind().Hostname()));
        }
        return new Tuple2$mcII$sp(this.settings().Canonical().Port(), this.settings().Bind().Port());
    }

    @Override
    public void runInboundStreams(int port, int bindPort) {
        String inboundChannel = new StringBuilder(20).append("aeron:udp?endpoint=").append(this.settings().Bind().Hostname()).append(":").append(bindPort).toString();
        this.runInboundControlStream(inboundChannel);
        this.runInboundOrdinaryMessagesStream(inboundChannel);
        if (this.largeMessageChannelEnabled()) {
            this.runInboundLargeMessagesStream(inboundChannel);
        }
        this.blockUntilChannelActive();
    }

    private void runInboundControlStream(String inboundChannel) {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple3 tuple3 = (Tuple3)((RunnableGraph)((Source)this.aeronSource(ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool(), inboundChannel).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$))).toMat(this.inboundControlSink(), (Function2<AeronSource.AeronLifecycle, Tuple2, Tuple3> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2<AeronSource.AeronLifecycle, Tuple2> tuple2 = new Tuple2<AeronSource.AeronLifecycle, Tuple2>((AeronSource.AeronLifecycle)x0$1, (Tuple2)x1$1);
            if (tuple2 != null) {
                AeronSource.AeronLifecycle a = tuple2._1();
                Tuple2 tuple22 = tuple2._2();
                if (tuple22 != null) {
                    InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)tuple22._1();
                    Future d = (Future)tuple22._2();
                    return new Tuple3<AeronSource.AeronLifecycle, InboundControlJunction.ControlMessageSubject, Future>(a, c, d);
                }
            }
            throw new MatchError(tuple2);
        })).run(this.controlMaterializer());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
        Future completed2 = (Future)tuple3._3();
        Tuple3<AeronSource.AeronLifecycle, InboundControlJunction.ControlMessageSubject, Future> tuple32 = new Tuple3<AeronSource.AeronLifecycle, InboundControlJunction.ControlMessageSubject, Future>(resourceLife, ctrl, completed2);
        AeronSource.AeronLifecycle resourceLife2 = tuple32._1();
        InboundControlJunction.ControlMessageSubject ctrl2 = tuple32._2();
        Future completed3 = tuple32._3();
        this.attachControlMessageObserver(ctrl2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), resourceLife2, completed3);
        this.attachInboundStreamRestart("Inbound control stream", completed3, (JFunction0$mcV$sp & scala.Serializable)() -> this.runInboundControlStream(inboundChannel));
    }

    private void runInboundOrdinaryMessagesStream(String inboundChannel) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        if (this.inboundLanes() == 1) {
            tuple32 = (Tuple3)((RunnableGraph)((Source)this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool(), inboundChannel).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both())).toMat(this.inboundSink(this.envelopeBufferPool()), (Function2<Tuple2, Future, Tuple3> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2<Tuple2, Future> tuple2 = new Tuple2<Tuple2, Future>((Tuple2)x0$1, (Future)x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = tuple2._1();
                    Future c = tuple2._2();
                    if (tuple22 != null) {
                        AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple22._1();
                        Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple22._2();
                        return new Tuple3<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess, Future>(a, b, c);
                    }
                }
                throw new MatchError(tuple2);
            })).run(this.materializer());
        } else {
            SharedKillSwitch laneKillSwitch = KillSwitches$.MODULE$.shared("laneKillSwitch");
            FlowOps laneSource = ((Source)((Source)((Source)this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool(), inboundChannel).via(laneKillSwitch.flow())).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both())).via(Flow$.MODULE$.fromGraph(new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool())))).via(Flow$.MODULE$.fromGraph(new DuplicateFlush(this.inboundLanes(), this.system(), this.envelopeBufferPool())));
            Tuple3 tuple33 = (Tuple3)((RunnableGraph)((Source)laneSource).toMat((Graph)Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize())), (Function2<Tuple2, Source, Tuple3> & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2<Tuple2, Source> tuple2 = new Tuple2<Tuple2, Source>((Tuple2)x0$2, (Source)x1$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = tuple2._1();
                    Source c = tuple2._2();
                    if (tuple22 != null) {
                        AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple22._1();
                        Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple22._2();
                        return new Tuple3<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess, Source>(a, b, c);
                    }
                }
                throw new MatchError(tuple2);
            })).run(this.materializer());
            if (tuple33 == null) {
                throw new MatchError(tuple33);
            }
            AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple33._1();
            Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple33._2();
            Source laneHub = (Source)tuple33._3();
            Tuple3<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess, Source> tuple34 = new Tuple3<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess, Source>(resourceLife, compressionAccess, laneHub);
            AeronSource.AeronLifecycle resourceLife2 = tuple34._1();
            Decoder.InboundCompressionAccess compressionAccess2 = tuple34._2();
            Source laneHub2 = tuple34._3();
            Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
            Vector completedValues = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).iterator().map((Function1<Object, Future> & Serializable & scala.Serializable)x$3 -> ArteryAeronUdpTransport.$anonfun$runInboundOrdinaryMessagesStream$3(this, laneHub2, lane, BoxesRunTime.unboxToInt(x$3))).to(org.apache.pekko.util.ccompat.package$.MODULE$.genericCompanionToCBF(Vector$.MODULE$));
            MessageDispatcher ec = this.system().dispatchers().internalDispatcher();
            Future$.MODULE$.firstCompletedOf(completedValues, ec).failed().foreach((Function1<Throwable, Object> & Serializable & scala.Serializable)reason -> {
                laneKillSwitch.abort(reason);
                return BoxedUnit.UNIT;
            }, ec);
            Future allCompleted = Future$.MODULE$.sequence(completedValues, Vector$.MODULE$.canBuildFrom(), ec).map((Function1<Vector, Done$> & Serializable & scala.Serializable)x$4 -> Done$.MODULE$, ec);
            tuple32 = tuple3 = new Tuple3(resourceLife2, compressionAccess2, allCompleted);
        }
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
        Future completed2 = (Future)tuple3._3();
        Tuple3<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess, Future> tuple35 = new Tuple3<AeronSource.AeronLifecycle, Decoder.InboundCompressionAccess, Future>(resourceLife, inboundCompressionAccess, completed2);
        AeronSource.AeronLifecycle resourceLife3 = tuple35._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = tuple35._2();
        Future completed3 = tuple35._3();
        this.setInboundCompressionAccess(inboundCompressionAccess2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.OrdinaryStreamId(), resourceLife3, completed3);
        this.attachInboundStreamRestart("Inbound message stream", completed3, (JFunction0$mcV$sp & scala.Serializable)() -> this.runInboundOrdinaryMessagesStream(inboundChannel));
    }

    private void runInboundLargeMessagesStream(String inboundChannel) {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple2 tuple2 = (Tuple2)((RunnableGraph)((Source)this.aeronSource(ArteryTransport$.MODULE$.LargeStreamId(), this.largeEnvelopeBufferPool(), inboundChannel).via(this.inboundLargeFlow(this.settings()))).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both())).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple2._1();
        Future completed2 = (Future)tuple2._2();
        Tuple2<AeronSource.AeronLifecycle, Future> tuple22 = new Tuple2<AeronSource.AeronLifecycle, Future>(resourceLife, completed2);
        AeronSource.AeronLifecycle resourceLife2 = tuple22._1();
        Future completed3 = tuple22._2();
        this.updateStreamMatValues(ArteryTransport$.MODULE$.LargeStreamId(), resourceLife2, completed3);
        this.attachInboundStreamRestart("Inbound large message stream", completed3, (JFunction0$mcV$sp & scala.Serializable)() -> this.runInboundLargeMessagesStream(inboundChannel));
    }

    private void updateStreamMatValues(int streamId, AeronSource.AeronLifecycle aeronSourceLifecycle, Future<Done> completed2) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(streamId, new ArteryTransport.InboundStreamMatValues<Object>(aeronSourceLifecycle, completed2.recover(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                return (B1)Done$.MODULE$;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
        }, ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        return this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop().map((Function1<Done, Done$> & Serializable & scala.Serializable)x$7 -> {
            block3: {
                this.flightRecorder().transportStopped();
                if ($this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask != null) {
                    $this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                    this.flightRecorder().transportAeronErrorLogTaskStopped();
                }
                if ($this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron != null) {
                    $this.org$apache$pekko$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.close();
                }
                if ($this.aeronErrorLog != null) {
                    $this.aeronErrorLog.close();
                }
                if (!$this.mediaDriver.get().isDefined()) break block3;
                this.stopMediaDriver();
            }
            return Done$.MODULE$;
        }, this.system().dispatchers().internalDispatcher());
    }

    public int autoSelectPort(String hostname) {
        DatagramSocket socket = DatagramChannel.open().socket();
        socket.bind(new InetSocketAddress(hostname, 0));
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    public static final /* synthetic */ void $anonfun$stopMediaDriver$1(ArteryAeronUdpTransport $this, MediaDriver driver) {
        $this.log().info("Stopping embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
        try {
            driver.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                $this.log().warning("Couldn't close Aeron embedded media driver due to [{}]", e);
            }
            throw throwable;
        }
        try {
            if ($this.settings().Advanced().Aeron().DeleteAeronDirectory()) {
                IoUtil.delete(new File(driver.aeronDirectoryName()), false);
                $this.flightRecorder().transportMediaFileDeleted();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                $this.log().warning("Couldn't delete Aeron embedded media driver files in [{}] due to [{}]", (Object)driver.aeronDirectoryName(), (Object)e);
            }
            throw throwable;
        }
    }

    private final void retry$1(long retries, AeronSource.AeronLifecycle aeronLifecyle$1, int waitInterval$1) {
        block2: {
            while (true) {
                long status;
                if ((status = BoxesRunTime.unboxToLong(Await$.MODULE$.result(aeronLifecyle$1.channelEndpointStatus(), this.settings().Bind().BindTimeout()))) == 1L) break block2;
                if (status == -1L) {
                    this.aeronErrorLog.logErrors(this.log(), 0L);
                    this.stopMediaDriver();
                    throw new RemoteTransportException("Inbound Aeron channel is in errored state. See Aeron logs for details.");
                }
                if (status != 0L || retries <= 0L) break;
                Thread.sleep(waitInterval$1);
                --retries;
            }
            this.aeronErrorLog.logErrors(this.log(), 0L);
            this.stopMediaDriver();
            throw new RemoteTransportException("Timed out waiting for Aeron transport to bind. See Aeoron logs.");
        }
        this.log().debug("Inbound channel is now active");
    }

    public static final /* synthetic */ Future $anonfun$runInboundOrdinaryMessagesStream$3(ArteryAeronUdpTransport $this, Source laneHub$1, Sink lane$1, int x$3) {
        return (Future)((RunnableGraph)laneHub$1.toMat((Graph)lane$1, Keep$.MODULE$.right())).run($this.materializer());
    }

    public ArteryAeronUdpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }
}

