/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent.pekko;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.concurrent.ClassLoadingUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Cancellable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public final class ActorSystemScheduledExecutorAdapter
implements ScheduledExecutor {
    private final ActorSystem actorSystem;
    private final ClassLoader flinkClassLoader;

    public ActorSystemScheduledExecutorAdapter(ActorSystem actorSystem, ClassLoader flinkClassLoader) {
        this.actorSystem = (ActorSystem)Preconditions.checkNotNull((Object)actorSystem, (String)"rpcService");
        this.flinkClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)flinkClassLoader, (String)"flinkClassLoader");
    }

    @Nonnull
    public ScheduledFuture<?> schedule(@Nonnull Runnable command, long delay, @Nonnull TimeUnit unit) {
        ScheduledFutureTask scheduledFutureTask = new ScheduledFutureTask(command, unit.toNanos(delay), 0L);
        Cancellable cancellable = this.internalSchedule(scheduledFutureTask, delay, unit);
        scheduledFutureTask.setCancellable(cancellable);
        return scheduledFutureTask;
    }

    @Nonnull
    public <V> ScheduledFuture<V> schedule(@Nonnull Callable<V> callable, long delay, @Nonnull TimeUnit unit) {
        ScheduledFutureTask<V> scheduledFutureTask = new ScheduledFutureTask<V>(callable, unit.toNanos(delay), 0L);
        Cancellable cancellable = this.internalSchedule(scheduledFutureTask, delay, unit);
        scheduledFutureTask.setCancellable(cancellable);
        return scheduledFutureTask;
    }

    @Nonnull
    public ScheduledFuture<?> scheduleAtFixedRate(@Nonnull Runnable command, long initialDelay, long period, @Nonnull TimeUnit unit) {
        ScheduledFutureTask scheduledFutureTask = new ScheduledFutureTask(command, this.triggerTime(unit.toNanos(initialDelay)), unit.toNanos(period));
        Cancellable cancellable = this.actorSystem.scheduler().schedule(new FiniteDuration(initialDelay, unit), new FiniteDuration(period, unit), ClassLoadingUtils.withContextClassLoader(scheduledFutureTask, (ClassLoader)this.flinkClassLoader), (ExecutionContext)this.actorSystem.dispatcher());
        scheduledFutureTask.setCancellable(cancellable);
        return scheduledFutureTask;
    }

    @Nonnull
    public ScheduledFuture<?> scheduleWithFixedDelay(@Nonnull Runnable command, long initialDelay, long delay, @Nonnull TimeUnit unit) {
        ScheduledFutureTask scheduledFutureTask = new ScheduledFutureTask(command, this.triggerTime(unit.toNanos(initialDelay)), unit.toNanos(-delay));
        Cancellable cancellable = this.internalSchedule(scheduledFutureTask, initialDelay, unit);
        scheduledFutureTask.setCancellable(cancellable);
        return scheduledFutureTask;
    }

    public void execute(@Nonnull Runnable command) {
        this.actorSystem.dispatcher().execute(ClassLoadingUtils.withContextClassLoader((Runnable)command, (ClassLoader)this.flinkClassLoader));
    }

    private Cancellable internalSchedule(Runnable runnable, long delay, TimeUnit unit) {
        return this.actorSystem.scheduler().scheduleOnce(new FiniteDuration(delay, unit), ClassLoadingUtils.withContextClassLoader((Runnable)runnable, (ClassLoader)this.flinkClassLoader), (ExecutionContext)this.actorSystem.dispatcher());
    }

    private long now() {
        return System.nanoTime();
    }

    private long triggerTime(long delay) {
        return this.now() + delay;
    }

    private final class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private long time;
        private final long period;
        private volatile Cancellable cancellable;

        ScheduledFutureTask(Callable<V> callable, long time, long period) {
            super(callable);
            this.time = time;
            this.period = period;
        }

        ScheduledFutureTask(Runnable runnable, long time, long period) {
            super(runnable, null);
            this.time = time;
            this.period = period;
        }

        public void setCancellable(Cancellable newCancellable) {
            this.cancellable = newCancellable;
        }

        @Override
        public void run() {
            if (!this.isPeriodic()) {
                super.run();
            } else if (this.runAndReset()) {
                if (this.period > 0L) {
                    this.time += this.period;
                } else {
                    this.cancellable = ActorSystemScheduledExecutorAdapter.this.internalSchedule(this, -this.period, TimeUnit.NANOSECONDS);
                    if (this.isCancelled()) {
                        this.cancellable.cancel();
                    } else {
                        this.time = ActorSystemScheduledExecutorAdapter.this.triggerTime(-this.period);
                    }
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = super.cancel(mayInterruptIfRunning);
            return result && this.cancellable.cancel();
        }

        @Override
        public long getDelay(@Nonnull TimeUnit unit) {
            return unit.convert(this.time - ActorSystemScheduledExecutorAdapter.this.now(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@Nonnull Delayed o) {
            if (o == this) {
                return 0;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }
    }
}

